/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.loader;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.rocketplatform.client.generated.Modpack;
import net.rocketplatform.client.generated.PlayerModpackServerWorld;
import net.rocketplatform.client.generated.PlayerModpackServerWorldStorage;
import net.rocketplatform.client.generated.PlayerModpackServerWorldsList;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.loader.ListEntryLoader;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.type.AbstractListLayoutTemplate;
import net.rocketplatform.game.client.mod.ui.variable.VariableProcessor;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.jetbrains.annotations.Nullable;

public class WorldEntryLoader
extends ListEntryLoader {
    public WorldEntryLoader(String type, AbstractListLayoutTemplate.ListEntry entryTemplate) {
        super(type, entryTemplate);
    }

    @Override
    public CompletableFuture<List<ListEntryLoader.ListEntryTemplate>> loadEntries(@Nullable VariableStorage storage) {
        AbstractListLayoutTemplate.ListEntry entryTemplate = this.getEntryTemplate();
        if (storage == null) {
            RocketClientMod.getLogger().warn("No storage provided for world list entry loader, so no entries will be loaded.");
            return CompletableFuture.completedFuture(List.of());
        }
        if (!storage.contains("gameServerId")) {
            RocketClientMod.getLogger().warn("No game server ID provided for player list entry loader, so no entries will be loaded.");
            return CompletableFuture.completedFuture(List.of());
        }
        String gameServerId = (String)storage.retrieve("gameServerId");
        RocketClientMod clientMod = RocketClientMod.getInstance();
        return ((CompletableFuture)((CompletableFuture)clientMod.getClientHandler().thenCompose(client -> client.getPlayerServerWorlds(gameServerId))).thenApply(server -> {
            PlayerModpackServerWorldsList serverWorlds = server.getWorlds();
            if (serverWorlds == null) {
                return List.of();
            }
            PlayerModpackServerWorld selectedWorld = server.getSelectedWorld();
            ArrayList<ListEntryLoader.ListEntryTemplate> entries = new ArrayList<ListEntryLoader.ListEntryTemplate>();
            List worlds = serverWorlds.getWorlds();
            int i = 1;
            for (PlayerModpackServerWorld world : worlds) {
                if (world.getWorldId() == null) {
                    RocketClientMod.getLogger().warn("World ID is null for world {}, skipping.", (Object)world.getWorldName());
                    continue;
                }
                VariableStorage worldStorage = new VariableStorage();
                worldStorage.store("worldName", world.getWorldName() == null ? "World #" + i : world.getWorldName());
                worldStorage.store("worldId", world.getWorldId());
                worldStorage.store("gameServerId", gameServerId);
                if (selectedWorld != null && selectedWorld.getWorldId().equals(world.getWorldId())) {
                    worldStorage.store("selected", true);
                } else {
                    worldStorage.store("selected", false);
                }
                Modpack modpack = world.getModpack();
                if (modpack != null) {
                    worldStorage.store("packName", modpack.getDisplayName());
                } else {
                    worldStorage.store("packName", "");
                }
                String modpackForWorld = world.getModpackId();
                if (modpackForWorld == null || modpackForWorld.equals(clientMod.getModpackId())) {
                    worldStorage.store("worldDifferentModpack", false);
                } else {
                    worldStorage.store("worldDifferentModpack", true);
                }
                worldStorage.store("unselected", selectedWorld != null && !selectedWorld.getWorldId().equals(world.getWorldId()));
                PlayerModpackServerWorldStorage serverStorage = world.getStorage();
                if (serverStorage != null) {
                    Long bytesUsed = serverStorage.getBytesUsed();
                    if (serverStorage.getBytesMax() <= 1L) {
                        bytesUsed = 0L;
                    }
                    worldStorage.store("usedStorage", bytesUsed);
                    worldStorage.store("maxStorage", Math.max(1L, serverStorage.getBytesMax()));
                }
                List<ElementTemplate<?>> elements = WorldEntryLoader.processElements(entryTemplate, worldStorage);
                AbstractListLayoutTemplate.ListEntry entry = new AbstractListLayoutTemplate.ListEntry(VariableProcessor.process(entryTemplate.getId(), worldStorage), elements, entryTemplate.requiredDoubleClickVariable(), entryTemplate.getCallback(), entryTemplate.selectedCallback());
                entries.add(new ListEntryLoader.ListEntryTemplate(entry, worldStorage));
                ++i;
            }
            return entries;
        })).exceptionally(e -> {
            RocketClientMod.getLogger().error("Failed to load world entries", e);
            return List.of();
        });
    }
}

