/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.repository;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.client.RocketClientHandler;
import net.rocketplatform.game.client.mod.ui.repository.LayoutParser;
import net.rocketplatform.game.client.mod.ui.repository.LayoutRepository;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.LayoutTemplate;
import org.apache.commons.lang3.tuple.Pair;

public final class LayoutLoader {
    public static CompletableFuture<Void> loadLayouts(RocketClientHandler client, int menuVersion, LayoutRepository repository) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        client.getMenuConfigs(menuVersion).whenComplete((response, e) -> {
            if (e != null) {
                future.completeExceptionally(new RuntimeException("An error occurred loading menus!", (Throwable)e));
                return;
            }
            HttpClient httpClient = HttpClient.newHttpClient();
            Path cachedMenusPath = RocketClientMod.getInstance().getConfigPath().resolve("cached_menus");
            if (Files.notExists(cachedMenusPath, new LinkOption[0])) {
                try {
                    Files.createDirectories(cachedMenusPath, new FileAttribute[0]);
                }
                catch (Exception e1) {
                    future.completeExceptionally(new RuntimeException("An error occurred creating the cached menus directory!", e1));
                    return;
                }
            }
            ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
            for (String downloadUrl : response.getDownloadUrls()) {
                URI uri;
                String menuPath = downloadUrl.substring(downloadUrl.indexOf("menus/") + "menus/".length());
                Path cachedMenuPath = cachedMenusPath.resolve(menuPath);
                if (Files.notExists(cachedMenuPath, new LinkOption[0])) {
                    try {
                        Path parentPath = cachedMenuPath.getParent();
                        if (parentPath != null && Files.notExists(parentPath, new LinkOption[0])) {
                            Files.createDirectories(parentPath, new FileAttribute[0]);
                        }
                        Files.createFile(cachedMenuPath, new FileAttribute[0]);
                    }
                    catch (IOException ex) {
                        future.completeExceptionally(new RuntimeException("An error occurred creating the cached menu file!", ex));
                        return;
                    }
                    uri = URI.create(downloadUrl);
                    HttpRequest request = HttpRequest.newBuilder().uri(uri).GET().build();
                    futures.add(((CompletableFuture)httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofFile(cachedMenuPath)).thenApply(p -> {
                        try {
                            return Files.readString((Path)p.body());
                        }
                        catch (IOException ex) {
                            future.completeExceptionally(new RuntimeException("An error occurred reading the menu file!", ex));
                            return null;
                        }
                    })).thenApply(file -> Pair.of((Object)downloadUrl, (Object)file)));
                    continue;
                }
                try {
                    uri = URI.create(downloadUrl);
                    String md5Hash = LayoutLoader.calculateMd5(cachedMenuPath);
                    HttpRequest request = HttpRequest.newBuilder().uri(uri).header("If-None-Match", "\"" + md5Hash + "\"").build();
                    CompletableFuture<HttpResponse<Path>> bodyResponseFuture = httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofFile(cachedMenuPath));
                    CompletionStage menuResponse = bodyResponseFuture.thenApply(bodyResponse -> {
                        if (bodyResponse.statusCode() == 304) {
                            try {
                                return Files.readString(cachedMenuPath);
                            }
                            catch (IOException ex) {
                                future.completeExceptionally(new RuntimeException("An error occurred reading the cached menu file!", ex));
                                return null;
                            }
                        }
                        try {
                            return Files.readString((Path)bodyResponse.body());
                        }
                        catch (IOException ex) {
                            future.completeExceptionally(new RuntimeException("An error occurred reading the menu file!", ex));
                            return null;
                        }
                    });
                    futures.add(((CompletableFuture)menuResponse).thenApply(file -> Pair.of((Object)downloadUrl, (Object)file)));
                }
                catch (IOException | NoSuchAlgorithmException e1) {
                    future.completeExceptionally(new RuntimeException("An error occurred calculating the MD5 hash of the cached menu file!", e1));
                    return;
                }
            }
            CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).whenComplete((v, e2) -> {
                if (e2 != null) {
                    future.completeExceptionally(new RuntimeException("An error occurred loading menus!", (Throwable)e2));
                    return;
                }
                for (CompletableFuture layoutFuture : futures) {
                    ((CompletableFuture)layoutFuture.thenAccept(layout -> {
                        String file = (String)layout.getKey();
                        String value = (String)layout.getValue();
                        boolean standaloneElements = file.endsWith("standalone_elements.json");
                        if (standaloneElements) {
                            ElementTemplate.loadStandalone(value);
                            return;
                        }
                        LayoutTemplate template = LayoutParser.createTemplate(value);
                        repository.addLayout(template);
                    })).whenComplete((ignored, throwable) -> {
                        if (throwable != null) {
                            RocketClientMod.getLogger().error("An error occurred processing menu", throwable);
                        }
                    });
                }
                future.complete(null);
            });
        });
        return future;
    }

    private static String calculateMd5(Path filePath) throws IOException, NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] fileBytes = Files.readAllBytes(filePath);
        byte[] hashBytes = md.digest(fileBytes);
        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }
}

