/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.repository;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.LowerCaseEnumTypeAdapterFactory;
import net.rocketplatform.game.client.mod.ui.loader.ListEntryLoaderTypes;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallbackTypes;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTypes;
import net.rocketplatform.game.client.mod.ui.template.layout.LayoutTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.LayoutTypes;

public final class LayoutParser {
    private static Gson GSON;

    public static void init() {
        GsonBuilder gsonBuilder = new GsonBuilder().disableHtmlEscaping();
        LayoutTypes.registerTypeAdapter(gsonBuilder);
        ElementTypes.registerTypeAdapter(gsonBuilder);
        ElementCallbackTypes.registerTypeAdapter(gsonBuilder);
        ListEntryLoaderTypes.registerTypeAdapter(gsonBuilder);
        gsonBuilder.registerTypeHierarchyAdapter(Component.class, (Object)new Component.SerializerAdapter());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new LowerCaseEnumTypeAdapterFactory());
        GSON = gsonBuilder.create();
    }

    public static LayoutTemplate createTemplate(String json) {
        return (LayoutTemplate)GsonHelper.fromJson((Gson)GSON, (String)json, LayoutTemplate.class, (boolean)true);
    }

    public static LayoutTemplate createTemplate(InputStream inputStream) {
        return (LayoutTemplate)GsonHelper.fromJson((Gson)GSON, (Reader)new InputStreamReader(inputStream), LayoutTemplate.class, (boolean)true);
    }

    public static Gson getGson() {
        return GSON;
    }
}

