/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.callback.type;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.client.RocketClientHandler;
import net.rocketplatform.game.client.mod.ui.template.callback.CallbackHolder;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.jetbrains.annotations.Nullable;

public class ManageBillingCallback
extends ElementCallback {
    private static final int CACHED_URL_EXPIRY = 120000;
    private static URL cachedUrl;
    private static long lastFetchTime;

    public ManageBillingCallback(String action) {
        super(action);
    }

    @Override
    public void onPress(TemplateScreen screen, @Nullable CallbackHolder holder, VariableStorage variableStorage) {
        if (cachedUrl != null && System.currentTimeMillis() - lastFetchTime < 120000L) {
            Util.getPlatform().openUrl(cachedUrl);
            return;
        }
        ((CompletableFuture)RocketClientMod.getInstance().getClientHandler().thenCompose(RocketClientHandler::getCustomerPortalAddress)).whenComplete((response, e) -> {
            if (e != null) {
                RocketClientMod.getLogger().error("Unable to manage billing: Failed to get customer portal address.", e);
                return;
            }
            if (response == null) {
                RocketClientMod.getLogger().error("Unable to manage billing: Failed to get customer portal address.");
                return;
            }
            try {
                URL url;
                cachedUrl = url = URI.create(response.getUrl()).toURL();
                lastFetchTime = System.currentTimeMillis();
                Util.getPlatform().openUrl(url);
            }
            catch (MalformedURLException ex) {
                RocketClientMod.getLogger().error("Unable to checkout: Failed to open customer portal address. {}", (Object)response.getUrl(), (Object)ex);
            }
        });
    }
}

