/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.element.type;

import com.google.gson.annotations.SerializedName;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.element.WidgetElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import net.rocketplatform.game.client.mod.util.GuiUtils;
import org.joml.Vector2i;

public class DividerTemplate
extends WidgetElementTemplate {
    private static final String WIDTH_KEY = "width";
    private static final String HEIGHT_KEY = "height";
    private String icon;
    @SerializedName(value="end_position")
    private ElementTemplate.Position endPosition;

    public DividerTemplate(String type, String id, ElementTemplate.Position position, ElementCallback callback) {
        super(type, id, position, callback);
    }

    public Integer getWidth() {
        Number width = (Number)this.getOption(WIDTH_KEY);
        return width == null ? null : Integer.valueOf(width.intValue());
    }

    public Integer getHeight() {
        Number height = (Number)this.getOption(HEIGHT_KEY);
        return height == null ? null : Integer.valueOf(height.intValue());
    }

    public Integer getEndX() {
        if (this.endPosition == null) {
            throw new IllegalArgumentException("End position is required for DividerTemplate if width is not specified");
        }
        return this.endPosition.x();
    }

    public Integer getEndY() {
        if (this.endPosition == null) {
            throw new IllegalArgumentException("End position is required for DividerTemplate if height is not specified");
        }
        return this.endPosition.y();
    }

    @Override
    public Widget createElement0(TemplateScreen screen, int elementWidth, int elementHeight, int offsetX, int offsetY, VariableStorage variableStorage) {
        final ResourceLocation icon = this.icon == null ? Screen.BACKGROUND_LOCATION : new ResourceLocation(this.icon);
        final int widgetWidth = Objects.requireNonNullElseGet(this.getWidth(), () -> screen.getWidth() - this.getEndX() - this.getPosition().x());
        final int widgetHeight = Objects.requireNonNullElseGet(this.getHeight(), () -> screen.getHeight() - this.getEndY() - this.getPosition().y());
        final Vector2i pos = this.getPivot().apply(elementWidth, elementHeight, widgetWidth, widgetHeight);
        pos.add(offsetX + this.getPosition().x(), offsetY + this.getPosition().y());
        Widget widget = new Widget(screen.getPanel()){

            public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
                GuiHelper.setupDrawing();
                graphics.setColor(0.25f, 0.25f, 0.25f, 1.0f);
                graphics.blit(icon, pos.x(), pos.y(), 0.0f, 0.0f, widgetWidth, widgetHeight, 32, 32);
                graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                GuiUtils.fillHorizontalGradient(graphics, RenderType.guiOverlay(), x - 4, y, x, y + widgetWidth, 0, 0, -16777216);
                GuiUtils.fillHorizontalGradient(graphics, RenderType.guiOverlay(), x + widgetWidth, y, x + widgetWidth + 4, y + widgetHeight, 0, -16777216, 0);
            }
        };
        widget.setPosAndSize(pos.x(), pos.y(), widgetWidth, widgetHeight);
        return widget;
    }
}

