/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.element.type.text;

import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.rocketplatform.game.client.mod.ui.template.element.type.text.TextFormatter;

public class CapitalizationFormatter
implements TextFormatter {
    public static CapitalizationFormatter INSTANCE = new CapitalizationFormatter();

    @Override
    public Component apply(Component component) {
        return TextFormatter.processComponent(component, str -> {
            if (str.isBlank()) {
                return str;
            }
            str = str.toLowerCase(Locale.ROOT);
            char[] buffer = str.toCharArray();
            boolean capitalizeNext = true;
            for (int i = 0; i < buffer.length; ++i) {
                char nextChar = buffer[i];
                if (Character.isWhitespace(nextChar)) {
                    capitalizeNext = true;
                    continue;
                }
                if (!capitalizeNext) continue;
                buffer[i] = Character.toTitleCase(nextChar);
                capitalizeNext = false;
            }
            return new String(buffer);
        });
    }
}

