/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.layout.type.list;

import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.LoadingDotsText;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.SingleKeyCache;
import net.rocketplatform.game.client.mod.ui.template.callback.CallbackHolder;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.element.WidgetElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.template.layout.type.AbstractListLayoutTemplate;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import net.rocketplatform.game.client.mod.ui.widget.MultilineStringWidget;
import net.rocketplatform.game.client.mod.util.GuiUtils;
import org.jetbrains.annotations.Nullable;

public class ListLayoutList
extends ObjectSelectionList<ListEntry> {
    private final Theme theme;

    public ListLayoutList(Minecraft minecraft, int width, int height, Theme theme) {
        this(minecraft, width, height - 64 - 44, 44, 36, theme);
    }

    public ListLayoutList(Minecraft minecraft, int width, int height, int y, int itemHeight, Theme theme) {
        super(minecraft, width, height, y, itemHeight);
        this.theme = theme;
    }

    public int addEntry(ListEntry entry) {
        return super.addEntry((AbstractSelectionList.Entry)entry);
    }

    public int getRowWidth() {
        return super.getRowWidth() + 85;
    }

    public void refreshEntries(List<ListEntry> newEntries) {
        this.children().clear();
        this.children().addAll(newEntries);
        ListEntry prevSelected = (ListEntry)this.getSelected();
        if (prevSelected != null && !newEntries.contains((Object)prevSelected)) {
            this.setSelected(null);
        } else if (prevSelected != null) {
            ListEntry newSelected = newEntries.stream().filter(e -> e.equals((Object)prevSelected)).findFirst().orElse(null);
            this.setSelected((AbstractSelectionList.Entry)newSelected);
            if (newSelected != null && newSelected.entry.selectedCallback() != null) {
                CallbackHolder.runCallbacks(prevSelected.screen, newSelected.entry, newSelected.entry.selectedCallback(), newSelected.variableStorage);
            }
        }
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 30;
    }

    public static class ListEntry
    extends ObjectSelectionList.Entry<ListEntry> {
        private final TemplateScreen screen;
        private final ListLayoutList list;
        private final AbstractListLayoutTemplate.ListEntry entry;
        private long lastClickTime;
        private final List<Widget> widgets = new ArrayList<Widget>();
        private boolean initedOnce;
        private int lastWidth;
        private int lastHeight;
        private int lastLeft;
        private int lastTop;
        private final VariableStorage variableStorage;

        public ListEntry(TemplateScreen screen, ListLayoutList list, AbstractListLayoutTemplate.ListEntry entry, @Nullable VariableStorage variableStorage) {
            this.screen = screen;
            this.list = list;
            this.entry = entry;
            this.variableStorage = variableStorage;
            if (variableStorage != null) {
                variableStorage.inherit(screen.getStorage(), false);
            }
        }

        public Component getNarration() {
            return Component.literal((String)"Entry");
        }

        public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            if (this.lastWidth != width || this.lastHeight != height || this.lastLeft != left || this.lastTop != top) {
                this.initedOnce = false;
                this.lastWidth = width;
                this.lastHeight = height;
                this.lastLeft = left;
                this.lastTop = top;
            }
            if (!this.initedOnce) {
                this.initedOnce = true;
                this.widgets.clear();
                for (ElementTemplate elementTemplate : this.entry.elements()) {
                    if (!(elementTemplate instanceof WidgetElementTemplate)) continue;
                    WidgetElementTemplate ftbElement = (WidgetElementTemplate)elementTemplate;
                    this.widgets.add((Widget)ftbElement.createElement(this.screen, width, height, left, top, this.variableStorage));
                }
            }
            for (Widget widget : this.widgets) {
                widget.draw(guiGraphics, this.list.theme, widget.posX, widget.posY, width, height);
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            this.list.setSelected((AbstractSelectionList.Entry)this);
            if (Util.getMillis() - this.lastClickTime < 250L) {
                if ((this.entry.requiredDoubleClickVariable() == null || GuiUtils.shouldProcess(this.entry.requiredDoubleClickVariable(), this.variableStorage)) && this.entry.callback() != null) {
                    this.entry.runCallbacks(this.screen);
                }
            } else if (this.entry.selectedCallback() != null) {
                CallbackHolder.runCallbacks(this.screen, this.entry, this.entry.selectedCallback(), this.variableStorage);
            }
            this.lastClickTime = Util.getMillis();
            return false;
        }

        public void setFocused(boolean focused) {
            if (focused && this.entry != null && this.entry.selectedCallback() != null) {
                CallbackHolder.runCallbacks(this.screen, this.entry, this.entry.selectedCallback(), this.variableStorage);
            }
        }

        public List<Widget> getWidgets() {
            return this.widgets;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ListEntry listEntry = (ListEntry)((Object)o);
            return Objects.equals(this.entry.id(), listEntry.entry.id());
        }

        public int hashCode() {
            return Objects.hashCode(this.entry.id());
        }
    }

    public static class LoadingHeader
    extends ListEntry {
        private static final Component LOADING_LABEL = Component.translatable((String)"rgp_client.gui.loading_entries");

        public LoadingHeader(TemplateScreen screen, ListLayoutList list, AbstractListLayoutTemplate.ListEntry entry, @Nullable VariableStorage variableStorage) {
            super(screen, list, entry, variableStorage);
        }

        @Override
        public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            Minecraft minecraft = Minecraft.getInstance();
            int i = (minecraft.screen.width - minecraft.font.width((FormattedText)LOADING_LABEL)) / 2;
            int j = top + (height - 9) / 2;
            guiGraphics.drawString(minecraft.font, LOADING_LABEL, i, j, 0xFFFFFF, false);
            String s = LoadingDotsText.get((long)Util.getMillis());
            int k = (minecraft.screen.width - minecraft.font.width(s)) / 2;
            int l = j + 9;
            guiGraphics.drawString(minecraft.font, s, k, l, 0x808080, false);
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            return false;
        }

        @Override
        public Component getNarration() {
            return LOADING_LABEL;
        }

        @Override
        public boolean equals(Object o) {
            return this == o;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode((Object)this);
        }
    }

    public static class EmptyHeader
    extends ListEntry {
        private final Component emptyEntry;
        private final SingleKeyCache<MultilineStringWidget.CacheKey, MultiLineLabel> cache;

        public EmptyHeader(TemplateScreen screen, Component emptyEntry, ListLayoutList list, AbstractListLayoutTemplate.ListEntry entry, @Nullable VariableStorage variableStorage) {
            super(screen, list, entry, variableStorage);
            this.emptyEntry = emptyEntry;
            this.cache = Util.singleKeyCache(key -> key.maxRows().isPresent() ? MultiLineLabel.create((Font)Theme.DEFAULT.getFont(), (FormattedText)key.message(), (int)key.maxWidth(), (int)key.maxRows().getAsInt()) : MultiLineLabel.create((Font)Theme.DEFAULT.getFont(), (FormattedText)key.message(), (int)key.maxWidth()));
        }

        @Override
        public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            if (this.emptyEntry == null) {
                return;
            }
            Minecraft minecraft = Minecraft.getInstance();
            MultiLineLabel multiLineLabel = (MultiLineLabel)this.cache.getValue((Object)this.getFreshCacheKey());
            multiLineLabel.renderCentered(guiGraphics, minecraft.screen.width / 2, top + (height - 9) / 2, 12, 0xFFFFFF);
        }

        private MultilineStringWidget.CacheKey getFreshCacheKey() {
            return new MultilineStringWidget.CacheKey(this.emptyEntry, 250, OptionalInt.empty());
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            return false;
        }

        @Override
        public Component getNarration() {
            return this.emptyEntry;
        }

        @Override
        public boolean equals(Object o) {
            return this == o;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode((Object)this);
        }
    }
}

