/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.layout.type.list;

import dev.architectury.platform.Platform;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.IScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.KeyModifiers;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.ItemStack;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.loader.ListEntryLoader;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.template.layout.type.AbstractListLayoutTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.type.list.IListScreen;
import net.rocketplatform.game.client.mod.ui.template.layout.type.list.ListLayoutList;
import net.rocketplatform.game.client.mod.ui.template.layout.type.list.ListScreen;

public class ListScreenWrapper
extends Screen
implements IScreenWrapper,
IListScreen {
    protected final ListScreen screen;
    protected ListLayoutList list;
    protected final Theme theme;
    protected boolean initedOnce;
    protected final List<AbstractListLayoutTemplate.ListEntry> entries;
    protected final List<ListEntryLoader.ListEntryTemplate> entryTemplates;
    protected final TooltipList tooltipList = new TooltipList();
    private Consumer<ListLayoutList> listConsumer;

    public ListScreenWrapper(ListScreen screen, Theme theme, List<AbstractListLayoutTemplate.ListEntry> entries, List<ListEntryLoader.ListEntryTemplate> entryTemplates) {
        super(screen.getTitle());
        this.screen = screen;
        this.theme = theme;
        this.entries = entries;
        this.entryTemplates = entryTemplates;
        screen.setWrapper(this);
    }

    public void init() {
        super.init();
        this.screen.initGui();
        if (this.initedOnce) {
            this.list.setRectangle(this.screen.getWidth(), this.screen.getHeight() - 64 - 44, 0, 44);
        } else {
            this.initedOnce = true;
            if (this.list == null) {
                this.list = new ListLayoutList(Minecraft.getInstance(), this.screen.getWidth(), this.screen.getHeight(), this.theme);
                if (this.listConsumer != null) {
                    this.listConsumer.accept(this.list);
                }
            }
            for (AbstractListLayoutTemplate.ListEntry entry : this.entries) {
                this.list.addEntry(new ListLayoutList.ListEntry(this.getGui(), this.list, entry, null));
            }
            for (ListEntryLoader.ListEntryTemplate template : this.entryTemplates) {
                AbstractListLayoutTemplate.ListEntry entry = template.entry();
                ListLayoutList.ListEntry internalEntry = new ListLayoutList.ListEntry(this.getGui(), this.list, entry, template.storage());
                this.list.addEntry(internalEntry);
            }
        }
        this.addWidget((GuiEventListener)this.list);
    }

    public void refreshEntries() {
        ArrayList<ListLayoutList.ListEntry> newEntries = new ArrayList<ListLayoutList.ListEntry>();
        for (AbstractListLayoutTemplate.ListEntry entry : this.entries) {
            newEntries.add(new ListLayoutList.ListEntry(this.getGui(), this.list, entry, null));
        }
        CompletableFuture<List<ListEntryLoader.ListEntryTemplate>> newTemplateEntries = this.screen.getTemplate().getEntryLoader().loadEntries(this.screen.getStorage());
        newTemplateEntries.whenComplete((entries, e) -> {
            if (e != null) {
                RocketClientMod.getLogger().error("Failed to load list entries", e);
                return;
            }
            for (ListEntryLoader.ListEntryTemplate template : entries) {
                AbstractListLayoutTemplate.ListEntry entry = template.entry();
                ListLayoutList.ListEntry internalEntry = new ListLayoutList.ListEntry(this.getGui(), this.list, entry, template.storage());
                newEntries.add(internalEntry);
            }
            if (newEntries.isEmpty() && this.screen.getTemplate().getEmptyEntry() != null) {
                newEntries.add(new ListLayoutList.EmptyHeader(this.screen.getTemplateScreen(), this.screen.getTemplate().getEmptyEntry(), this.list, null, null));
            }
            this.list.refreshEntries(newEntries);
        });
    }

    public boolean isPauseScreen() {
        return this.screen.doesGuiPauseGame();
    }

    public boolean mouseClicked(double x, double y, int button) {
        this.screen.updateMouseOver((int)x, (int)y);
        if (button == MouseButton.BACK.id) {
            this.screen.onBack();
            return true;
        }
        return this.screen.mousePressed(MouseButton.get((int)button)) || super.mouseClicked(x, y, button);
    }

    public boolean mouseReleased(double x, double y, int button) {
        this.screen.updateMouseOver((int)x, (int)y);
        this.screen.mouseReleased(MouseButton.get((int)button));
        return super.mouseReleased(x, y, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        return this.screen.mouseScrolled(scrollY) || super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean mouseDragged(double x, double y, int button, double dragX, double dragY) {
        return this.screen.mouseDragged(button, dragX, dragY) || super.mouseDragged(x, y, button, dragX, dragY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        Key key = new Key(keyCode, scanCode, modifiers);
        if (this.screen.keyPressed(key)) {
            return true;
        }
        if (key.backspace()) {
            this.screen.onBack();
            return true;
        }
        if (this.screen.onClosedByKey(key)) {
            if (this.shouldCloseOnEsc()) {
                this.screen.closeGui(true);
            }
            return true;
        }
        if (Platform.isModLoaded((String)"jei")) {
            this.screen.getIngredientUnderMouse().ifPresent(underMouse -> this.handleIngredientKey(key, underMouse.ingredient()));
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        Key key = new Key(keyCode, scanCode, modifiers);
        this.screen.keyReleased(key);
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char keyChar, int modifiers) {
        if (this.screen.charTyped(keyChar, new KeyModifiers(modifiers))) {
            return true;
        }
        return super.charTyped(keyChar, (int)keyChar);
    }

    private void handleIngredientKey(Key key, Object object) {
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.screen.updateGui(mouseX, mouseY, partialTicks);
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        GuiHelper.setupDrawing();
        int x = this.screen.getX();
        int y = this.screen.getY();
        int w = this.screen.width;
        int h = this.screen.height;
        Theme theme = this.screen.getTheme();
        this.screen.draw(graphics, theme, x, y, w, h);
        this.screen.drawForeground(graphics, theme, x, y, w, h);
        for (ListLayoutList.ListEntry entry : this.list.children()) {
            for (Widget widget : entry.getWidgets()) {
                widget.updateMouseOver(mouseX, mouseY);
            }
        }
        this.screen.addMouseOverText(this.tooltipList);
        if (!this.tooltipList.shouldRender()) {
            this.screen.getIngredientUnderMouse().ifPresent(underMouse -> {
                ItemStack stack;
                Object ingredient;
                if (underMouse.tooltip() && (ingredient = underMouse.ingredient()) instanceof ItemStack && !(stack = (ItemStack)ingredient).isEmpty()) {
                    graphics.pose().pushPose();
                    graphics.pose().translate(0.0f, 0.0f, (float)this.tooltipList.zOffsetItemTooltip);
                    graphics.renderTooltip(theme.getFont(), (ItemStack)ingredient, mouseX, mouseY);
                    graphics.pose().popPose();
                }
            });
        } else {
            graphics.pose().translate(0.0f, 0.0f, 600.0f);
            graphics.setColor(1.0f, 1.0f, 1.0f, 0.8f);
            graphics.renderTooltip(theme.getFont(), this.tooltipList.getLines(), Optional.empty(), mouseX, Math.max(mouseY, 18));
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            graphics.pose().translate(0.0f, 0.0f, -600.0f);
        }
        this.tooltipList.reset();
    }

    public void renderBackground(GuiGraphics matrixStack, int x, int y, float partialTicks) {
        if (this.screen.drawDefaultBackground(matrixStack)) {
            super.renderBackground(matrixStack, x, y, partialTicks);
        }
    }

    public void tick() {
        super.tick();
        this.screen.tick();
    }

    public ListScreen getGui() {
        return this.screen;
    }

    public void removed() {
        this.screen.onClosed();
        super.removed();
    }

    public boolean shouldCloseOnEsc() {
        return this.getGui().shouldCloseOnEsc();
    }

    @Override
    public ListLayoutList getList() {
        return this.list;
    }

    @Override
    public TemplateScreen getTemplateScreen() {
        return this.screen;
    }

    @Override
    public void onListCreate(Consumer<ListLayoutList> listConsumer) {
        this.listConsumer = listConsumer;
    }
}

