/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.variable;

import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;

public class VariableProcessor {
    public static String process(String input, VariableStorage storage) {
        for (Map.Entry<String, Object> entry : storage.getContents().entrySet()) {
            if (entry.getValue() == null) {
                RocketClientMod.getLogger().debug("Variable {} was not specified. Not storing anything.", (Object)entry.getKey());
                continue;
            }
            input = input.replace("$" + entry.getKey(), entry.getValue().toString());
        }
        return input;
    }

    public static Component processComponent(Component input, VariableStorage storage) {
        MutableComponent result;
        ComponentContents componentContents = input.getContents();
        if (componentContents instanceof PlainTextContents.LiteralContents) {
            PlainTextContents.LiteralContents contents = (PlainTextContents.LiteralContents)componentContents;
            result = Component.literal((String)VariableProcessor.process(contents.text(), storage)).setStyle(input.getStyle());
        } else {
            componentContents = input.getContents();
            if (componentContents instanceof TranslatableContents) {
                TranslatableContents contents = (TranslatableContents)componentContents;
                Object[] args = new Object[contents.getArgs().length];
                for (int i = 0; i < args.length; ++i) {
                    Object oldArg = contents.getArgs()[i];
                    if (oldArg instanceof Component) {
                        Component component = (Component)oldArg;
                        args[i] = VariableProcessor.processComponent(component, storage);
                        continue;
                    }
                    if (oldArg instanceof String) {
                        String str = (String)oldArg;
                        args[i] = VariableProcessor.process(str, storage);
                        continue;
                    }
                    args[i] = oldArg;
                }
                result = Component.translatable((String)contents.getKey(), (Object[])args).setStyle(input.getStyle());
            } else {
                return input;
            }
        }
        for (Component sibling : input.getSiblings()) {
            result.append(VariableProcessor.processComponent(sibling, storage));
        }
        return result;
    }
}

