/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.io.FilenameUtils;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.BookContentLoader;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookFolderLoader;

public final class BookContentExternalLoader
implements BookContentLoader {
    public static final BookContentExternalLoader INSTANCE = new BookContentExternalLoader();

    private BookContentExternalLoader() {
    }

    @Override
    public void findFiles(Book book, String dir, List<ResourceLocation> list) {
        File searchDir;
        File root = new File(BookFolderLoader.loadDir, book.id.getPath());
        File enUs = new File(root, "en_us");
        if (enUs.exists() && (searchDir = new File(enUs, dir)).exists()) {
            this.crawl(searchDir, searchDir, list);
        }
    }

    private void crawl(File realRoot, File root, List<ResourceLocation> list) {
        File[] files;
        for (File f : files = root.listFiles()) {
            if (f.isDirectory()) {
                this.crawl(realRoot, f, list);
                continue;
            }
            if (!f.getName().endsWith(".json")) continue;
            list.add(this.relativize(realRoot, f));
        }
    }

    private ResourceLocation relativize(File root, File f) {
        String rootPath = root.getAbsolutePath();
        String filePath = f.getAbsolutePath().substring(rootPath.length() + 1);
        String cleanPath = FilenameUtils.removeExtension((String)FilenameUtils.separatorsToUnix((String)filePath));
        return new ResourceLocation("patchouli", cleanPath);
    }

    @Override
    public BookContentLoader.LoadResult loadJson(Book book, ResourceLocation file) {
        try {
            String path = file.getPath().substring(BookFolderLoader.loadDir.getName().length());
            File targetFile = new File(BookFolderLoader.loadDir, path);
            if (targetFile.exists()) {
                return new BookContentLoader.LoadResult(BookContentLoader.streamToJson(new FileInputStream(targetFile)), null);
            }
        }
        catch (IOException e) {
            PatchouliAPI.LOGGER.warn("Failed to load {}.", (Object)file, (Object)e);
            return null;
        }
        return null;
    }
}

