/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.PatchouliAPI;

public class ShapedBookRecipe
extends ShapedRecipe {
    public static final RecipeSerializer<ShapedBookRecipe> SERIALIZER = new Serializer();
    final ShapedRecipePattern pattern;
    final ItemStack result;
    final String group;
    @Nullable
    final ResourceLocation outputBook;

    public ShapedBookRecipe(String group, ShapedRecipePattern recipePattern, ItemStack result, @Nullable ResourceLocation outputBook) {
        super(group, CraftingBookCategory.MISC, recipePattern, ShapedBookRecipe.getOutputBook(result, outputBook));
        this.pattern = recipePattern;
        this.result = result;
        this.group = group;
        this.outputBook = outputBook;
    }

    private static ItemStack getOutputBook(ItemStack result, @Nullable ResourceLocation outputBook) {
        if (outputBook != null) {
            return PatchouliAPI.get().getBookStack(outputBook);
        }
        return result;
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public static class Serializer
    implements RecipeSerializer<ShapedBookRecipe> {
        public static final Codec<ShapedBookRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.strictOptionalField((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(bookRecipe -> bookRecipe.group), (App)ShapedRecipePattern.MAP_CODEC.forGetter(bookRecipe -> bookRecipe.pattern), (App)ExtraCodecs.strictOptionalField((Codec)ItemStack.ITEM_WITH_COUNT_CODEC, (String)"result", (Object)ItemStack.EMPTY).forGetter(bookRecipe -> bookRecipe.result), (App)ExtraCodecs.strictOptionalField((Codec)ResourceLocation.CODEC, (String)"book", null).forGetter(bookRecipe -> bookRecipe.outputBook)).apply((Applicative)instance, ShapedBookRecipe::new));

        public Codec<ShapedBookRecipe> codec() {
            return CODEC;
        }

        public ShapedBookRecipe fromNetwork(FriendlyByteBuf buf) {
            String group = buf.readUtf();
            ShapedRecipePattern recipePattern = ShapedRecipePattern.fromNetwork((FriendlyByteBuf)buf);
            ItemStack result = buf.readItem();
            ResourceLocation outputBook = buf.readBoolean() ? buf.readResourceLocation() : null;
            return new ShapedBookRecipe(group, recipePattern, result, outputBook);
        }

        public void toNetwork(FriendlyByteBuf buf, ShapedBookRecipe bookRecipe) {
            buf.writeUtf(bookRecipe.group);
            bookRecipe.pattern.toNetwork(buf);
            buf.writeItem(bookRecipe.result);
            buf.writeBoolean(bookRecipe.outputBook != null);
            if (bookRecipe.outputBook != null) {
                buf.writeResourceLocation(bookRecipe.outputBook);
            }
        }
    }
}

