/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.neoforge.common;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.CreativeModeTabRegistry;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import vazkii.patchouli.common.base.PatchouliSounds;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.command.OpenBookCommand;
import vazkii.patchouli.common.handler.LecternEventHandler;
import vazkii.patchouli.common.handler.ReloadContentsHandler;
import vazkii.patchouli.common.item.ItemModBook;
import vazkii.patchouli.common.item.PatchouliItems;
import vazkii.patchouli.neoforge.common.NeoForgePatchouliConfig;
import vazkii.patchouli.neoforge.network.NeoForgeNetworkHandler;

@Mod.EventBusSubscriber(modid="patchouli", bus=Mod.EventBusSubscriber.Bus.MOD)
@Mod(value="patchouli")
public class NeoForgeModInitializer {
    public NeoForgeModInitializer(IEventBus eventBus) {
        NeoForgePatchouliConfig.setup();
        eventBus.addListener(NeoForgeNetworkHandler::setupPackets);
    }

    @SubscribeEvent
    public static void register(RegisterEvent evt) {
        evt.register(Registries.SOUND_EVENT, rh -> PatchouliSounds.submitRegistrations((arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)rh).register(arg_0, arg_1)));
        evt.register(Registries.ITEM, rh -> PatchouliItems.submitItemRegistrations((arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)rh).register(arg_0, arg_1)));
        evt.register(Registries.RECIPE_SERIALIZER, rh -> PatchouliItems.submitRecipeSerializerRegistrations((arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)rh).register(arg_0, arg_1)));
    }

    @SubscribeEvent
    public static void processCreativeTabs(BuildCreativeModeTabContentsEvent evt) {
        BookRegistry.INSTANCE.books.values().forEach(b -> {
            if (!b.noBook) {
                ItemStack book = ItemModBook.forBook(b);
                if (evt.getTab() == CreativeModeTabs.searchTab()) {
                    evt.accept(book);
                } else if (b.creativeTab != null && evt.getTab() == CreativeModeTabRegistry.getTab((ResourceLocation)b.creativeTab)) {
                    evt.accept(book);
                }
            }
        });
    }

    @SubscribeEvent
    public static void onInitialize(FMLCommonSetupEvent evt) {
        NeoForge.EVENT_BUS.addListener(e -> OpenBookCommand.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher()));
        NeoForge.EVENT_BUS.addListener(e -> {
            InteractionResult result = LecternEventHandler.rightClick(e.getEntity(), e.getLevel(), e.getHand(), e.getHitVec());
            if (result.consumesAction()) {
                e.setCanceled(true);
                e.setCancellationResult(result);
            }
        });
        BookRegistry.INSTANCE.init();
        NeoForge.EVENT_BUS.addListener(e -> ReloadContentsHandler.dataReloaded(e.getServer()));
    }
}

