/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.harvest_with_ease.api;

import it.crystalnest.cobweb.api.block.BlockUtils;
import it.crystalnest.cobweb.api.item.TierUtils;
import it.crystalnest.harvest_with_ease.config.ModConfig;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.NoSuchElementException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.PitcherCropBlock;
import net.minecraft.world.level.block.TorchflowerCropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public final class HarvestUtils {
    public static final TagKey<Block> BLACKLIST = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)new ResourceLocation("harvest_with_ease", "blacklist"));

    private HarvestUtils() {
    }

    public static boolean isCrop(Block block) {
        return !(block instanceof TorchflowerCropBlock) && (block instanceof CropBlock || block instanceof NetherWartBlock || block instanceof CocoaBlock || block instanceof PitcherCropBlock || ModConfig.getCrops().contains(BlockUtils.getStringKey((Block)block)));
    }

    public static boolean isAllowed(BlockState block) {
        return ModConfig.getBlacklist().stream().noneMatch(id -> id.equalsIgnoreCase(BlockUtils.getStringKey((Block)block.getBlock()))) && !block.is(BLACKLIST);
    }

    public static boolean hasEnoughHunger(Player player) {
        return player.level().getDifficulty() == Difficulty.PEACEFUL || ModConfig.getExhaustionMultiplier().compareTo(BigDecimal.ZERO) == 0 || (double)((float)player.getFoodData().getFoodLevel() + player.getFoodData().getSaturationLevel()) - Math.floor(player.getFoodData().getExhaustionLevel() / 4.0f) >= 0.0;
    }

    public static IntegerProperty getAge(BlockState blockState) throws NullPointerException, NoSuchElementException, ClassCastException {
        return (IntegerProperty)blockState.getProperties().stream().filter(property -> "age".equals(property.getName())).findFirst().orElseThrow();
    }

    public static boolean isMature(BlockState blockState, IntegerProperty age) {
        return blockState.getOptionalValue((Property)age).orElse(0) >= (Integer)Collections.max(age.getPossibleValues());
    }

    public static boolean isMature(BlockState blockState) throws NullPointerException, NoSuchElementException, ClassCastException {
        return HarvestUtils.isMature(blockState, HarvestUtils.getAge(blockState));
    }

    public static boolean isTallCrop(BlockGetter level, BlockState blockState, BlockPos blockPos) {
        return blockState.is(BlockTags.CROPS) && level.getBlockState(blockPos.below()).is(blockState.getBlock()) || level.getBlockState(blockPos.above()).is(blockState.getBlock());
    }

    public static boolean isTierForMultiHarvest(TieredItem tool) {
        return TierUtils.compare((Tier)tool.getTier(), (Tier)TierUtils.getTier((String)ModConfig.getMultiHarvestStartingTier())) >= 0;
    }
}

