/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.harvest_with_ease.handler;

import it.crystalnest.harvest_with_ease.handler.HarvestHandler;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

@Mod.EventBusSubscriber(modid="harvest_with_ease", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class NeoForgeHarvestHandler
extends HarvestHandler {
    private NeoForgeHarvestHandler() {
    }

    @SubscribeEvent
    private static void handle(BlockEvent.BreakEvent event) {
        NeoForgeHarvestHandler.handle(event.getLevel(), event.getState(), event.getPos());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    private static void handle(PlayerInteractEvent.RightClickBlock event) {
        if (NeoForgeHarvestHandler.canInteract(event.getEntity(), event) && NeoForgeHarvestHandler.handle(event.getLevel(), event.getLevel().getBlockState(event.getHitVec().getBlockPos()), event.getHitVec().getDirection(), event.getHitVec().getBlockPos(), event.getHitVec(), event.getEntity(), event.getHand())) {
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    private static boolean canInteract(Player player, PlayerInteractEvent.RightClickBlock event) {
        return !player.isSpectator() && event.getUseBlock() != Event.Result.DENY && event.getUseItem() != Event.Result.DENY && event.getResult() != Event.Result.DENY;
    }
}

