/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;

public class TickBoxButton
extends ImageButton {
    private static final ResourceLocation CHECKBOX_TEX = new ResourceLocation("textures/gui/sprites/widget/checkbox.png");
    private static final ResourceLocation CHECKBOX_SELECTED_TEX = new ResourceLocation("textures/gui/sprites/widget/checkbox_selected.png");
    private static final ResourceLocation CHECKBOX_HIGHLIGHTED_TEX = new ResourceLocation("textures/gui/sprites/widget/checkbox_highlighted.png");
    private static final ResourceLocation CHECKBOX_SELECTED_HIGHLIGHTED_TEX = new ResourceLocation("textures/gui/sprites/widget/checkbox_selected_highlighted.png");
    private boolean isToggled;
    private final Runnable onPressed;

    public TickBoxButton(int x, int y, Runnable onPressed) {
        this(x, y, null, onPressed);
    }

    public TickBoxButton(int x, int y, TickBoxButton prev, Runnable onPressed) {
        super(x, y, 20, 20, new WidgetSprites(CHECKBOX_SELECTED_TEX, CHECKBOX_TEX, CHECKBOX_SELECTED_HIGHLIGHTED_TEX, CHECKBOX_HIGHLIGHTED_TEX), btn -> {});
        this.onPressed = onPressed;
        if (prev != null) {
            this.isToggled = prev.isToggled;
        }
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        boolean texX = false;
        boolean texY = false;
        ResourceLocation tex = this.sprites.get(this.isToggled, this.isHovered());
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        graphics.blit(tex, this.getX(), this.getY(), (float)texX, (float)texY, this.width, this.height, 20, 20);
    }

    public void onPress() {
        this.toggle();
        this.onPressed.run();
    }

    public void toggle() {
        this.isToggled = !this.isToggled;
    }

    public boolean isToggled() {
        return this.isToggled;
    }

    private static void toggle(Button btn) {
        if (btn instanceof TickBoxButton) {
            ((TickBoxButton)btn).toggle();
        }
    }
}

