/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen;

import com.bisecthosting.mods.bhmenu.config.GlobalConfigs;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.data.api.PublicServerApiData;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen.PublicServersScreen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;

public class PublicServerLoadingScreen
extends Screen {
    private static final Component LOADING_TEXT = Component.translatable((String)"modules.public_server_list.loading.loading");
    private static final Component FAILED_TO_LOAD_TEXT = Component.translatable((String)"modules.public_server_list.loading.failed");
    private CompletableFuture<List<ServerData>> task;
    private List<ServerData> publicServers = new ArrayList<ServerData>();
    private JoinMultiplayerScreen parent;
    private String errorMessage;

    public PublicServerLoadingScreen(Screen parent) {
        super((Component)Component.translatable((String)"modules.public_server_list.loading.title"));
        this.parent = (JoinMultiplayerScreen)parent;
        this.task = PublicServerApiData.reloadData((String)GlobalConfigs.packId.get()).whenComplete((v, e) -> {
            if (e != null) {
                this.errorMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                return;
            }
            this.publicServers.addAll((Collection<ServerData>)v);
        });
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_BACK, b -> this.onClose()).pos((this.width - 100) / 2, this.height - 40).width(100).build());
    }

    public void tick() {
        if (this.task.isDone() && !this.task.isCompletedExceptionally()) {
            this.minecraft.setScreen((Screen)new PublicServersScreen(this.parent, this.publicServers));
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphics, mouseX, mouseY, delta);
        super.render(graphics, mouseX, mouseY, delta);
        if (!this.task.isDone()) {
            graphics.drawString(this.font, LOADING_TEXT, this.width / 2 - this.font.width((FormattedText)LOADING_TEXT) / 2, this.height / 2 - 25, 0xFFFFFF);
            String s = switch ((int)(Util.getMillis() / 300L % 4L)) {
                default -> "O o o";
                case 1, 3 -> "o O o";
                case 2 -> "o o O";
            };
            graphics.drawString(this.font, s, this.width / 2 - this.font.width(s) / 2, this.height / 2 - 10, 0xFFFFFF);
        } else if (this.task.isCompletedExceptionally()) {
            graphics.drawString(this.font, FAILED_TO_LOAD_TEXT, this.width / 2 - this.font.width((FormattedText)FAILED_TO_LOAD_TEXT) / 2, this.height / 2 - 25, 0xFFFFFF);
            MutableComponent errorText = Component.literal((String)this.errorMessage);
            int i = 0;
            for (FormattedCharSequence text : this.font.split((FormattedText)errorText, 200)) {
                int n = this.width / 2 - this.font.width(text) / 2;
                int n2 = this.height / 2;
                Objects.requireNonNull(this.font);
                graphics.drawString(this.font, text, n, n2 + (i + 2) * 9, 0xFFFFFF);
                ++i;
            }
        }
    }

    public void onClose() {
        if (!this.task.isDone()) {
            this.task.cancel(true);
        }
        this.minecraft.setScreen((Screen)this.parent);
    }
}

