/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.ftb.mods.ftbfiltersystem.api.FTBFilterSystemAPI;
import dev.ftb.mods.ftbfiltersystem.api.FilterException;
import dev.ftb.mods.ftbfiltersystem.api.filter.DumpedFilter;
import dev.ftb.mods.ftbfiltersystem.api.filter.SmartFilter;
import dev.ftb.mods.ftbfiltersystem.registry.item.SmartFilterItem;
import dev.ftb.mods.ftbfiltersystem.util.FilterParser;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class FilterSystemCommands {
    public static final DynamicCommandExceptionType PARSE_FAILED = new DynamicCommandExceptionType(object -> Component.translatable((String)"ftbfiltersystem.message.parse_failed", (Object[])new Object[]{object}));
    public static final SimpleCommandExceptionType NOT_A_FILTER = new SimpleCommandExceptionType((Message)Component.translatable((String)"ftbfiltersystem.message.not_a_filter"));
    public static final SimpleCommandExceptionType NO_OFFHAND_ITEM = new SimpleCommandExceptionType((Message)Component.translatable((String)"ftbfiltersystem.message.no_offhand_item"));
    private static final Component TICK_MARK = Component.literal((String)"\u2713 ").withStyle(ChatFormatting.GREEN);
    private static final Component X_MARK = Component.literal((String)"\u2717 ").withStyle(ChatFormatting.RED);

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context, Commands.CommandSelection selection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ftbfiltersystem").then(Commands.literal((String)"parse").then(Commands.argument((String)"string", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> FilterSystemCommands.tryParseCommand((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"string")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"get_filter").executes(ctx -> FilterSystemCommands.tryShowFilter((CommandSourceStack)ctx.getSource(), false))).then(Commands.literal((String)"pretty").executes(ctx -> FilterSystemCommands.tryShowFilter((CommandSourceStack)ctx.getSource(), true))))).then(Commands.literal((String)"set_filter").then(Commands.argument((String)"string", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> FilterSystemCommands.trySetFilter((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"string")))))).then(Commands.literal((String)"try_match").executes(ctx -> FilterSystemCommands.tryMatch((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"dump_nbt").requires(ctx -> ctx.hasPermission(2))).executes(ctx -> FilterSystemCommands.dumpNbt((CommandSourceStack)ctx.getSource()))));
    }

    private static int tryParseCommand(CommandSourceStack source, String string) throws CommandSyntaxException {
        try {
            for (DumpedFilter entry : FTBFilterSystemAPI.api().dump(FilterParser.parse(string))) {
                source.sendSuccess(() -> {
                    MutableComponent txt = entry.filter().getDisplayName().copy().withStyle(ChatFormatting.AQUA);
                    if (!(entry.filter() instanceof SmartFilter.Compound)) {
                        txt.append(" ").append((Component)entry.filter().getDisplayArg().copy().withStyle(ChatFormatting.YELLOW));
                    }
                    return Component.literal((String)FilterSystemCommands.makeDumpPrefix(entry.indent())).withStyle(ChatFormatting.YELLOW).append((Component)txt);
                }, false);
            }
        }
        catch (FilterException e) {
            throw PARSE_FAILED.create((Object)e.getMessage());
        }
        return 0;
    }

    private static int tryShowFilter(CommandSourceStack source, boolean prettyPrint) throws CommandSyntaxException {
        String filterString = SmartFilterItem.getFilterString(FilterSystemCommands.getHeldFilter(source));
        if (prettyPrint) {
            return FilterSystemCommands.tryParseCommand(source, filterString);
        }
        source.sendSuccess(() -> Component.literal((String)filterString), false);
        return 1;
    }

    private static int trySetFilter(CommandSourceStack source, String string) throws CommandSyntaxException {
        try {
            SmartFilterItem.setFilter(FilterSystemCommands.getHeldFilter(source), FilterParser.parse(string).toString());
            return 1;
        }
        catch (FilterException e) {
            source.sendFailure((Component)Component.literal((String)e.getMessage()).withStyle(ChatFormatting.RED));
            return 0;
        }
    }

    public static int tryMatch(CommandSourceStack source) throws CommandSyntaxException {
        ItemStack offhandItem = source.getPlayerOrException().getOffhandItem();
        if (offhandItem.isEmpty()) {
            throw NO_OFFHAND_ITEM.create();
        }
        SmartFilter filter = FilterParser.parse(SmartFilterItem.getFilterString(FilterSystemCommands.getHeldFilter(source)));
        if (filter.test(offhandItem)) {
            source.sendSuccess(() -> TICK_MARK.copy().append((Component)Component.translatable((String)"ftbfiltersystem.message.matched", (Object[])new Object[]{offhandItem.getDisplayName()})), false);
            return 1;
        }
        source.sendSuccess(() -> X_MARK.copy().append((Component)Component.translatable((String)"ftbfiltersystem.message.not_matched", (Object[])new Object[]{offhandItem.getDisplayName()})), false);
        return 0;
    }

    private static int dumpNbt(CommandSourceStack source) throws CommandSyntaxException {
        ItemStack stack = source.getPlayerOrException().getMainHandItem();
        if (stack.hasTag()) {
            source.sendSuccess(() -> Component.literal((String)"NBT dump:").withStyle(ChatFormatting.YELLOW), false);
            source.sendSuccess(() -> Component.literal((String)stack.getTag().toString()), false);
            return 1;
        }
        source.sendFailure((Component)Component.literal((String)"No NBT").withStyle(ChatFormatting.RED));
        return 0;
    }

    private static ItemStack getHeldFilter(CommandSourceStack source) throws CommandSyntaxException {
        ItemStack stack = source.getPlayerOrException().getMainHandItem();
        if (stack.getItem() instanceof SmartFilterItem) {
            return stack;
        }
        throw NOT_A_FILTER.create();
    }

    private static String makeDumpPrefix(int indent) {
        if (indent == 0) {
            return "";
        }
        String s1 = "\u2503 ".repeat(indent - 1);
        return s1 + "\u2523\u2501";
    }
}

