/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.api;

import dev.ftb.mods.ftbfiltersystem.api.FTBFilterSystemRegistry;
import dev.ftb.mods.ftbfiltersystem.api.FilterException;
import dev.ftb.mods.ftbfiltersystem.api.client.FTBFilterSystemClientAPI;
import dev.ftb.mods.ftbfiltersystem.api.filter.DumpedFilter;
import dev.ftb.mods.ftbfiltersystem.api.filter.SmartFilter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class FTBFilterSystemAPI {
    public static final String MOD_ID = "ftbfiltersystem";
    private static API instance;
    private static FTBFilterSystemClientAPI clientInstance;

    @NotNull
    public static API api() {
        return Objects.requireNonNull(instance);
    }

    @NotNull
    public static FTBFilterSystemClientAPI clientApi() {
        return Objects.requireNonNull(clientInstance);
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static ResourceLocation modDefaultedRL(String str) {
        return str.indexOf(58) > 0 ? new ResourceLocation(str) : new ResourceLocation(MOD_ID, str);
    }

    public static String modDefaultedString(ResourceLocation rl) {
        return rl.getNamespace().equals(MOD_ID) ? rl.getPath() : rl.toString();
    }

    @ApiStatus.Internal
    public static void _init(API instance) {
        if (FTBFilterSystemAPI.instance != null) {
            throw new IllegalStateException("can't init more than once!");
        }
        FTBFilterSystemAPI.instance = instance;
    }

    @ApiStatus.Internal
    public static void _initClient(FTBFilterSystemClientAPI instance) {
        if (clientInstance != null) {
            throw new IllegalStateException("can't init more than once!");
        }
        clientInstance = instance;
    }

    public static interface API {
        public FTBFilterSystemRegistry getRegistry();

        public boolean isFilterItem(ItemStack var1);

        public boolean doesFilterMatch(ItemStack var1, ItemStack var2);

        public List<DumpedFilter> dump(SmartFilter var1);

        public Optional<SmartFilter> createDefaultFilter(@NotNull SmartFilter.Compound var1, ResourceLocation var2);

        public SmartFilter parseFilter(String var1) throws FilterException;

        public SmartFilter parseFilter(ItemStack var1) throws FilterException;

        public List<SmartFilter> parseFilterList(@NotNull SmartFilter.Compound var1, String var2) throws FilterException;

        public ItemStack makeTagFilter(TagKey<Item> var1);
    }
}

