/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.client.gui;

import dev.ftb.mods.ftbfiltersystem.api.FilterException;
import dev.ftb.mods.ftbfiltersystem.api.client.gui.AbstractFilterScreen;
import dev.ftb.mods.ftbfiltersystem.client.gui.AbstractItemEditorConfigScreen;
import dev.ftb.mods.ftbfiltersystem.client.gui.GhostDropReceiver;
import dev.ftb.mods.ftbfiltersystem.client.gui.widget.CustomCheckbox;
import dev.ftb.mods.ftbfiltersystem.filter.NbtFilter;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class NBTConfigScreen
extends AbstractItemEditorConfigScreen<NbtFilter>
implements GhostDropReceiver {
    private CustomCheckbox fuzzyCB;

    public NBTConfigScreen(NbtFilter filter, AbstractFilterScreen parentScreen) {
        super(filter, parentScreen, 320, 176);
    }

    @Override
    protected void init() {
        super.init();
        MutableComponent str = Component.translatable((String)"ftbfiltersystem.gui.fuzzy_match");
        this.fuzzyCB = (CustomCheckbox)this.addRenderableWidget((GuiEventListener)new CustomCheckbox(this.leftPos + 180, this.topPos + 110, this.font.width((FormattedText)str), 20, (Component)str, ((NbtFilter)this.filter).isFuzzyMatch()));
        this.editBox.setValue(((NbtFilter)this.filter).getTag().toString());
    }

    @Override
    protected void doScheduledUpdate() {
        if (this.editBox.getValue().isEmpty()) {
            this.setStatus(true, (Component)Component.empty(), null);
        } else {
            try {
                NbtFilter.fromString(((NbtFilter)this.filter).getParent(), this.editBox.getValue());
                this.setStatus(true, (Component)Component.translatable((String)"ftbfiltersystem.gui.nbt_ok"), null);
            }
            catch (FilterException e) {
                this.setStatus(false, (Component)Component.translatable((String)"ftbfiltersystem.gui.nbt_bad"), e.getMessage());
            }
        }
    }

    @Override
    @Nullable
    protected NbtFilter makeNewFilter() {
        try {
            String str = NbtFilter.getNBTPrefix(this.fuzzyCB.selected()) + this.editBox.getValue();
            return NbtFilter.fromString(((NbtFilter)this.filter).getParent(), str);
        }
        catch (FilterException e) {
            return null;
        }
    }

    @Override
    protected Predicate<ItemStack> inventoryChecker() {
        return ItemStack::hasTag;
    }

    @Override
    protected String serialize(ItemStack stack) {
        return Objects.requireNonNull(stack.getTag()).toString();
    }

    @Override
    public Rect2i getGhostDropRegion() {
        return new Rect2i(this.editBox.getX(), this.editBox.getY(), this.editBox.getWidth(), this.editBox.getHeight());
    }

    @Override
    public void receiveGhostDrop(ItemStack stack) {
        if (stack.hasTag()) {
            this.editBox.setValue(this.serialize(stack));
            this.customHoverName = stack.hasCustomHoverName() ? stack.getHoverName() : null;
            this.setFocused((GuiEventListener)this.editBox);
        }
    }
}

