/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class CustomCheckbox
extends AbstractButton {
    private boolean selected;
    private final boolean showLabel;

    public CustomCheckbox(int pX, int pY, int pWidth, int pHeight, Component pMessage, boolean pSelected) {
        this(pX, pY, pWidth, pHeight, pMessage, pSelected, true);
    }

    public CustomCheckbox(int pX, int pY, int pWidth, int pHeight, Component pMessage, boolean pSelected, boolean pShowLabel) {
        super(pX, pY, pWidth, pHeight, pMessage);
        this.selected = pSelected;
        this.showLabel = pShowLabel;
    }

    public void onPress() {
        this.selected = !this.selected;
    }

    public boolean selected() {
        return this.selected;
    }

    public void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
        pNarrationElementOutput.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
        if (this.active) {
            if (this.isFocused()) {
                pNarrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.checkbox.usage.focused"));
            } else {
                pNarrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.checkbox.usage.hovered"));
            }
        }
    }

    public void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Minecraft minecraft = Minecraft.getInstance();
        RenderSystem.enableDepthTest();
        Font font = minecraft.font;
        pGuiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        RenderSystem.enableBlend();
        Objects.requireNonNull(font);
        int boxSize = 2 * (9 / 2) + 4;
        int yBase = this.getY() + (this.height - boxSize) / 2;
        if (this.isFocused()) {
            pGuiGraphics.fill(this.getX() - 1, yBase - 1, this.getX() + boxSize + 1, yBase + boxSize + 1, -1);
        }
        pGuiGraphics.fill(this.getX(), yBase, this.getX() + boxSize, yBase + boxSize, -8355712);
        pGuiGraphics.fill(this.getX() + 1, yBase + 1, this.getX() + boxSize - 1, yBase + boxSize - 1, -14671840);
        if (this.selected) {
            pGuiGraphics.drawString(font, (Component)Component.literal((String)"\u2713").withStyle(ChatFormatting.BOLD), this.getX() + 2, yBase + 1, -16732160);
        }
        pGuiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.showLabel) {
            pGuiGraphics.drawString(font, this.getMessage(), this.getX() + boxSize + 2, this.getY() + (this.height - 8) / 2, 0x404040 | Mth.ceil((float)(this.alpha * 255.0f)) << 24, false);
        }
    }
}

