/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbfiltersystem.FTBFilterSystem;
import dev.ftb.mods.ftbfiltersystem.api.FilterException;
import dev.ftb.mods.ftbfiltersystem.network.FTBFilterSystemNet;
import dev.ftb.mods.ftbfiltersystem.registry.item.SmartFilterItem;
import dev.ftb.mods.ftbfiltersystem.util.FilterParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class SyncFilterMessage
extends BaseC2SMessage {
    private final String filterStr;
    @Nullable
    private final String newTitle;
    private final InteractionHand hand;

    public SyncFilterMessage(String filterStr, @Nullable String newTitle, InteractionHand hand) {
        this.filterStr = filterStr;
        this.newTitle = newTitle;
        this.hand = hand;
    }

    public SyncFilterMessage(FriendlyByteBuf buf) {
        this.filterStr = buf.readUtf();
        this.newTitle = (String)buf.readNullable(FriendlyByteBuf::readUtf);
        this.hand = (InteractionHand)buf.readEnum(InteractionHand.class);
    }

    public MessageType getType() {
        return FTBFilterSystemNet.SYNC_FILTER;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeUtf(this.filterStr);
        buf.writeNullable((Object)this.newTitle, FriendlyByteBuf::writeUtf);
        buf.writeEnum((Enum)this.hand);
    }

    public void handle(NetworkManager.PacketContext context) {
        ItemStack stack = context.getPlayer().getItemInHand(this.hand);
        if (stack.getItem() instanceof SmartFilterItem) {
            try {
                SmartFilterItem.setFilter(stack, FilterParser.parse(this.filterStr).toString());
                if (this.newTitle != null) {
                    if (this.newTitle.isEmpty()) {
                        stack.resetHoverName();
                    } else {
                        stack.setHoverName((Component)Component.literal((String)this.newTitle));
                    }
                }
            }
            catch (FilterException e) {
                FTBFilterSystem.LOGGER.error("received filter sync message with bad filter data from client {}: {}", (Object)context.getPlayer().getGameProfile().getName(), (Object)e.getMessage());
            }
        }
    }
}

