/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.util;

import dev.ftb.mods.ftbfiltersystem.api.FilterException;
import dev.ftb.mods.ftbfiltersystem.api.filter.SmartFilter;
import dev.ftb.mods.ftbfiltersystem.util.FilterParser;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;

public enum FilterCache {
    INSTANCE;

    private static final int MAX_SIZE = 1000;
    private final Object2ObjectLinkedOpenHashMap<String, SmartFilter> cache = new Object2ObjectLinkedOpenHashMap();

    public SmartFilter getOrCreateFilter(String filterStr) throws FilterException {
        SmartFilter filter;
        if (this.cache.containsKey((Object)filterStr)) {
            return (SmartFilter)this.cache.getAndMoveToFirst((Object)filterStr);
        }
        try {
            filter = FilterParser.parseRaw(filterStr);
        }
        catch (FilterException e) {
            filter = null;
        }
        if (this.cache.size() >= 1000) {
            this.cache.removeLast();
        }
        this.cache.put((Object)filterStr, (Object)filter);
        return filter;
    }
}

