/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.util;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class NBTUtil {
    public static boolean compareNbt(@Nullable Tag tagA, @Nullable Tag tagB, boolean fuzzy, boolean compareLists) {
        if (tagA == tagB) {
            return true;
        }
        if (tagA == null) {
            return true;
        }
        if (tagB == null) {
            return false;
        }
        if (!tagA.getType().equals(tagB.getType())) {
            return false;
        }
        if (tagA instanceof CompoundTag) {
            CompoundTag compoundA = (CompoundTag)tagA;
            if (tagB instanceof CompoundTag) {
                CompoundTag compoundB = (CompoundTag)tagB;
                Set keysA = compoundA.getAllKeys();
                Set keysB = compoundB.getAllKeys();
                if (!(fuzzy || keysA.size() == keysB.size() && Sets.intersection((Set)keysA, (Set)keysB).size() == keysA.size())) {
                    return false;
                }
                return keysA.stream().allMatch(key -> NBTUtil.compareNbt(compoundA.get(key), compoundB.get(key), fuzzy, compareLists));
            }
        }
        if (compareLists && tagA instanceof ListTag) {
            ListTag listA = (ListTag)tagA;
            if (tagB instanceof ListTag) {
                ListTag listB = (ListTag)tagB;
                if (listA.isEmpty()) {
                    return listB.isEmpty();
                }
                if (listA.size() != listB.size()) {
                    return false;
                }
                return IntStream.range(0, listA.size()).allMatch(i -> NBTUtil.compareNbt(listA.get(i), listB.get(i), fuzzy, true));
            }
        }
        return tagA.equals(tagB);
    }
}

