/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.durabilitytooltip;

import com.supermartijn642.durabilitytooltip.DurabilityTooltipConfig;
import com.supermartijn642.durabilitytooltip.TooltipColorStyle;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public enum TooltipStyle {
    BAR,
    NUMBERS,
    TEXT;


    public void appendTooltip(List<Component> tooltips, int durability, int maxDurability) {
        boolean showTooltipHint = DurabilityTooltipConfig.showTooltipHint.get();
        ChatFormatting baseColor = DurabilityTooltipConfig.baseTooltipColor.get();
        TooltipColorStyle colorStyle = DurabilityTooltipConfig.tooltipColorStyle.get();
        ChatFormatting reactiveColor = colorStyle.getColorForDurability(baseColor, durability, maxDurability);
        switch (this) {
            case BAR: {
                if (showTooltipHint) {
                    tooltips.add((Component)Component.translatable((String)"durabilitytooltip.info.bar.durability_hint").withStyle(baseColor));
                }
                int fullCharacters = Math.round(10.0f * (float)durability / (float)maxDurability);
                MutableComponent innerBar = Component.literal((String)"");
                for (int character = 0; character < 10; ++character) {
                    innerBar.append((Component)Component.translatable((String)(character < fullCharacters ? "durabilitytooltip.info.bar.full_symbol" : "durabilitytooltip.info.bar.empty_symbol")).withStyle(reactiveColor));
                }
                MutableComponent bar = Component.translatable((String)"durabilitytooltip.info.bar.bar_line", (Object[])new Object[]{innerBar}).withStyle(baseColor);
                tooltips.add((Component)bar);
                break;
            }
            case NUMBERS: {
                MutableComponent durabilityComponent = Component.literal((String)Integer.toString(durability)).withStyle(reactiveColor);
                MutableComponent maxDurabilityComponent = Component.literal((String)Integer.toString(maxDurability)).withStyle(colorStyle == TooltipColorStyle.VARYING ? baseColor : reactiveColor);
                MutableComponent numbers = durability == maxDurability ? Component.translatable((String)"durabilitytooltip.info.numbers.full_durability", (Object[])new Object[]{maxDurabilityComponent}).withStyle(baseColor) : Component.translatable((String)"durabilitytooltip.info.numbers.damaged", (Object[])new Object[]{durabilityComponent, maxDurabilityComponent}).withStyle(baseColor);
                if (showTooltipHint) {
                    numbers = Component.translatable((String)"durabilitytooltip.info.numbers.durability_hint", (Object[])new Object[]{numbers}).withStyle(baseColor);
                }
                tooltips.add((Component)numbers);
                break;
            }
            case TEXT: {
                String translationKey = durability == maxDurability ? "durabilitytooltip.info.text.full_durability" : ((float)durability >= 0.4f * (float)maxDurability ? "durabilitytooltip.info.text.damaged" : ((float)durability >= 0.1f * (float)maxDurability ? "durabilitytooltip.info.text.severely_damaged" : "durabilitytooltip.info.text.nearly_broken"));
                MutableComponent tooltip = Component.translatable((String)translationKey).withStyle(reactiveColor);
                if (showTooltipHint) {
                    tooltip = Component.translatable((String)"durabilitytooltip.info.text.durability_hint", (Object[])new Object[]{tooltip}).withStyle(baseColor);
                }
                tooltips.add((Component)tooltip);
            }
        }
    }
}

