/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells;

import appeng.api.client.StorageCellModels;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.networking.GridServices;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.upgrades.Upgrades;
import appeng.block.networking.EnergyCellBlockItem;
import appeng.capabilities.AppEngCapabilities;
import appeng.client.gui.implementations.InterfaceScreen;
import appeng.client.gui.implementations.PatternProviderScreen;
import appeng.client.render.crafting.AbstractCraftingUnitModelProvider;
import appeng.client.render.crafting.CraftingCubeModel;
import appeng.client.render.crafting.CraftingMonitorRenderer;
import appeng.core.AppEng;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.BlockDefinition;
import appeng.core.definitions.ItemDefinition;
import appeng.core.localization.GuiText;
import appeng.hooks.BuiltInModelHooks;
import appeng.hotkeys.HotkeyActions;
import appeng.init.InitVillager;
import appeng.init.client.InitScreens;
import appeng.items.storage.BasicStorageCell;
import appeng.items.tools.powered.AbstractPortableCell;
import appeng.items.tools.powered.powersink.PoweredItemCapabilities;
import gripe._90.megacells.block.MEGACraftingUnitType;
import gripe._90.megacells.client.render.MEGACraftingUnitModelProvider;
import gripe._90.megacells.definition.MEGABlockEntities;
import gripe._90.megacells.definition.MEGABlocks;
import gripe._90.megacells.definition.MEGAConfig;
import gripe._90.megacells.definition.MEGACreativeTab;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.definition.MEGAMenus;
import gripe._90.megacells.integration.Addons;
import gripe._90.megacells.integration.ae2wt.AE2WTIntegration;
import gripe._90.megacells.integration.appmek.AppMekIntegration;
import gripe._90.megacells.integration.appmek.AppMekItems;
import gripe._90.megacells.integration.appmek.item.RadioactiveCellItem;
import gripe._90.megacells.item.cell.BulkCellItem;
import gripe._90.megacells.misc.CompressionService;
import gripe._90.megacells.misc.DecompressionService;
import gripe._90.megacells.misc.LavaTransformLogic;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.apache.commons.lang3.ArrayUtils;

@Mod(value="megacells")
public class MEGACells {
    public static final String MODID = "megacells";

    public MEGACells(IEventBus modEventBus) {
        modEventBus.addListener(MEGACells::registerAll);
        modEventBus.addListener(MEGACells::initUpgrades);
        modEventBus.addListener(MEGACells::initStorageCells);
        modEventBus.addListener(MEGACells::initVillagerTrades);
        modEventBus.addListener(MEGACells::initCapabilities);
        MEGACells.initCompression();
        MEGACells.initLavaTransform();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)MEGAConfig.SPEC);
        if (FMLEnvironment.dist.isClient()) {
            Client.init(modEventBus);
        }
    }

    public static ResourceLocation makeId(String path) {
        return new ResourceLocation(MODID, path);
    }

    private static void registerAll(RegisterEvent event) {
        if (Addons.APPMEK.isLoaded()) {
            AppMekItems.init();
        }
        MEGABlocks.getBlocks().forEach(block -> {
            event.register(Registries.BLOCK, block.id(), () -> ((BlockDefinition)block).block());
            event.register(Registries.ITEM, block.id(), () -> ((BlockDefinition)block).asItem());
        });
        MEGAItems.getItems().forEach(item -> event.register(Registries.ITEM, item.id(), () -> ((ItemDefinition)item).asItem()));
        event.register(Registries.BLOCK_ENTITY_TYPE, helper -> MEGABlockEntities.getBEs().forEach((arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)helper).register(arg_0, arg_1)));
        event.register(Registries.MENU, helper -> MEGAMenus.getMenuTypes().forEach((arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)helper).register(arg_0, arg_1)));
        event.register(Registries.CREATIVE_MODE_TAB, MEGACreativeTab.ID, () -> MEGACreativeTab.TAB);
    }

    private static void initUpgrades(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            String storageCellGroup = GuiText.StorageCells.getTranslationKey();
            String portableCellGroup = GuiText.PortableCells.getTranslationKey();
            String interfaceGroup = GuiText.Interface.getTranslationKey();
            String wirelessTerminalGroup = GuiText.WirelessTerminals.getTranslationKey();
            for (ItemDefinition<?> itemDefinition : MEGAItems.getItemCells()) {
                Upgrades.add((ItemLike)AEItems.FUZZY_CARD, itemDefinition, (int)1, (String)storageCellGroup);
                Upgrades.add((ItemLike)AEItems.INVERTER_CARD, itemDefinition, (int)1, (String)storageCellGroup);
                Upgrades.add((ItemLike)AEItems.EQUAL_DISTRIBUTION_CARD, itemDefinition, (int)1, (String)storageCellGroup);
                Upgrades.add((ItemLike)AEItems.VOID_CARD, itemDefinition, (int)1, (String)storageCellGroup);
            }
            for (ItemDefinition<?> itemDefinition : MEGAItems.getFluidCells()) {
                Upgrades.add((ItemLike)AEItems.INVERTER_CARD, itemDefinition, (int)1, (String)storageCellGroup);
                Upgrades.add((ItemLike)AEItems.EQUAL_DISTRIBUTION_CARD, itemDefinition, (int)1, (String)storageCellGroup);
                Upgrades.add((ItemLike)AEItems.VOID_CARD, itemDefinition, (int)1, (String)storageCellGroup);
            }
            for (ItemDefinition itemDefinition : MEGAItems.getItemPortables()) {
                Upgrades.add((ItemLike)AEItems.FUZZY_CARD, (ItemLike)itemDefinition, (int)1, (String)portableCellGroup);
                Upgrades.add((ItemLike)AEItems.INVERTER_CARD, (ItemLike)itemDefinition, (int)1, (String)portableCellGroup);
                Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (ItemLike)itemDefinition, (int)2, (String)portableCellGroup);
                Upgrades.add((ItemLike)AEItems.EQUAL_DISTRIBUTION_CARD, (ItemLike)itemDefinition, (int)1, (String)storageCellGroup);
                Upgrades.add((ItemLike)AEItems.VOID_CARD, (ItemLike)itemDefinition, (int)1, (String)storageCellGroup);
            }
            for (ItemDefinition itemDefinition : MEGAItems.getFluidPortables()) {
                Upgrades.add((ItemLike)AEItems.INVERTER_CARD, (ItemLike)itemDefinition, (int)1, (String)portableCellGroup);
                Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (ItemLike)itemDefinition, (int)2, (String)portableCellGroup);
                Upgrades.add((ItemLike)AEItems.EQUAL_DISTRIBUTION_CARD, (ItemLike)itemDefinition, (int)1, (String)storageCellGroup);
                Upgrades.add((ItemLike)AEItems.VOID_CARD, (ItemLike)itemDefinition, (int)1, (String)storageCellGroup);
            }
            Upgrades.add((ItemLike)AEItems.CRAFTING_CARD, MEGABlocks.MEGA_INTERFACE, (int)1, (String)interfaceGroup);
            Upgrades.add((ItemLike)AEItems.CRAFTING_CARD, MEGAItems.MEGA_INTERFACE, (int)1, (String)interfaceGroup);
            Upgrades.add((ItemLike)AEItems.FUZZY_CARD, MEGABlocks.MEGA_INTERFACE, (int)1, (String)interfaceGroup);
            Upgrades.add((ItemLike)AEItems.FUZZY_CARD, MEGAItems.MEGA_INTERFACE, (int)1, (String)interfaceGroup);
            Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (ItemLike)AEItems.WIRELESS_TERMINAL, (int)2, (String)wirelessTerminalGroup);
            Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (ItemLike)AEItems.WIRELESS_CRAFTING_TERMINAL, (int)2, (String)wirelessTerminalGroup);
            Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (ItemLike)AEItems.COLOR_APPLICATOR, (int)2);
            Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (ItemLike)AEItems.MATTER_CANNON, (int)2);
            Upgrades.add(MEGAItems.COMPRESSION_CARD, MEGAItems.BULK_ITEM_CELL, (int)1);
            for (ItemDefinition itemDefinition : List.of(AEItems.PORTABLE_ITEM_CELL1K, AEItems.PORTABLE_ITEM_CELL4K, AEItems.PORTABLE_ITEM_CELL16K, AEItems.PORTABLE_ITEM_CELL64K, AEItems.PORTABLE_ITEM_CELL256K, AEItems.PORTABLE_FLUID_CELL1K, AEItems.PORTABLE_FLUID_CELL4K, AEItems.PORTABLE_FLUID_CELL16K, AEItems.PORTABLE_FLUID_CELL64K, AEItems.PORTABLE_FLUID_CELL256K)) {
                Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (ItemLike)itemDefinition, (int)2, (String)portableCellGroup);
            }
            if (Addons.AE2WTLIB.isLoaded()) {
                AE2WTIntegration.initUpgrades();
            }
            if (Addons.APPMEK.isLoaded()) {
                AppMekIntegration.initUpgrades();
            }
        });
    }

    private static void initStorageCells(FMLCommonSetupEvent event) {
        StorageCells.addCellHandler((ICellHandler)BulkCellItem.HANDLER);
        event.enqueueWork(() -> {
            MEGAItems.getItemPortables().forEach(cell -> HotkeyActions.registerPortableCell((ItemDefinition)cell, (String)"portable_item_cell"));
            MEGAItems.getFluidPortables().forEach(cell -> HotkeyActions.registerPortableCell((ItemDefinition)cell, (String)"portable_fluid_cell"));
        });
        if (Addons.APPMEK.isLoaded()) {
            StorageCells.addCellHandler((ICellHandler)RadioactiveCellItem.HANDLER);
        }
    }

    private static void initVillagerTrades(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            MEGACells.addVillagerTrade(MEGAItems.SKY_STEEL_INGOT, 8, 3, 20);
            MEGACells.addVillagerTrade(MEGAItems.ACCUMULATION_PROCESSOR_PRESS, 40, 1, 50);
        });
    }

    private static void addVillagerTrade(ItemLike item, int cost, int quantity, int xp) {
        Int2ObjectMap offers = VillagerTrades.TRADES.computeIfAbsent(InitVillager.PROFESSION, k -> new Int2ObjectOpenHashMap());
        Object[] masterEntries = (VillagerTrades.ItemListing[])offers.computeIfAbsent(5, k -> new VillagerTrades.ItemListing[0]);
        masterEntries = (VillagerTrades.ItemListing[])ArrayUtils.add((Object[])masterEntries, (i, j) -> new MerchantOffer(new ItemStack((ItemLike)Items.EMERALD, cost), new ItemStack(item, quantity), 12, xp, 0.05f));
        offers.put(5, (Object)masterEntries);
    }

    private static void initCompression() {
        NeoForge.EVENT_BUS.addListener(event -> {
            MinecraftServer server = event.getServer();
            CompressionService.INSTANCE.loadRecipes(server.getRecipeManager(), (RegistryAccess)server.registryAccess());
        });
        NeoForge.EVENT_BUS.addListener(event -> {
            if (event.getPlayer() == null) {
                MinecraftServer server = event.getPlayerList().getServer();
                CompressionService.INSTANCE.loadRecipes(server.getRecipeManager(), (RegistryAccess)server.registryAccess());
            }
        });
        GridServices.register(DecompressionService.class, DecompressionService.class);
    }

    private static void initLavaTransform() {
        NeoForge.EVENT_BUS.addListener(event -> LavaTransformLogic.clearCache());
        NeoForge.EVENT_BUS.addListener(event -> {
            if (event.getPlayer() == null) {
                LavaTransformLogic.clearCache();
            }
        });
    }

    private static void initCapabilities(RegisterCapabilitiesEvent event) {
        for (BlockEntityType<?> type : MEGABlockEntities.getBEs().values()) {
            event.registerBlockEntity(AppEngCapabilities.IN_WORLD_GRID_NODE_HOST, type, (be, context) -> (IInWorldGridNodeHost)be);
        }
        event.registerBlockEntity(AppEngCapabilities.GENERIC_INTERNAL_INV, MEGABlockEntities.MEGA_INTERFACE, (be, context) -> be.getInterfaceLogic().getStorage());
        event.registerBlockEntity(AppEngCapabilities.ME_STORAGE, MEGABlockEntities.MEGA_INTERFACE, (be, context) -> be.getInterfaceLogic().getInventory());
        event.registerBlockEntity(AppEngCapabilities.GENERIC_INTERNAL_INV, MEGABlockEntities.MEGA_PATTERN_PROVIDER, (be, context) -> be.getLogic().getReturnInv());
        MEGAItems.getItemPortables().forEach(portable -> MEGACells.registerPoweredItemCapability(event, portable));
        MEGAItems.getFluidPortables().forEach(portable -> MEGACells.registerPoweredItemCapability(event, portable));
        if (Addons.APPMEK.isLoaded()) {
            AppMekItems.getPortables().forEach(portable -> MEGACells.registerPoweredItemCapability(event, portable));
        }
    }

    private static <T extends Item> void registerPoweredItemCapability(RegisterCapabilitiesEvent event, ItemDefinition<T> item) {
        event.registerItem(Capabilities.EnergyStorage.ITEM, (object, context) -> new PoweredItemCapabilities(object, (IAEItemPowerStorage)item.asItem()), new ItemLike[]{item});
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class Client {
        private Client() {
        }

        private static void init(IEventBus modEventBus) {
            modEventBus.addListener(Client::initScreens);
            modEventBus.addListener(Client::initCraftingUnitModels);
            modEventBus.addListener(Client::initEnergyCellProps);
            modEventBus.addListener(Client::initItemColours);
            modEventBus.addListener(Client::initStorageCellModels);
        }

        private static void initScreens(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                InitScreens.register(MEGAMenus.MEGA_INTERFACE, InterfaceScreen::new, (String)"/screens/megacells/mega_interface.json");
                InitScreens.register(MEGAMenus.MEGA_PATTERN_PROVIDER, PatternProviderScreen::new, (String)"/screens/megacells/mega_pattern_provider.json");
            });
        }

        private static void initCraftingUnitModels(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                for (MEGACraftingUnitType type : MEGACraftingUnitType.values()) {
                    BuiltInModelHooks.addBuiltInModel((ResourceLocation)MEGACells.makeId("block/crafting/" + type.getAffix() + "_formed"), (UnbakedModel)new CraftingCubeModel((AbstractCraftingUnitModelProvider)new MEGACraftingUnitModelProvider(type)));
                    ItemBlockRenderTypes.setRenderLayer((Block)type.getDefinition().block(), (RenderType)RenderType.cutout());
                }
                BlockEntityRenderers.register(MEGABlockEntities.MEGA_CRAFTING_MONITOR, CraftingMonitorRenderer::new);
            });
        }

        private static void initEnergyCellProps(FMLClientSetupEvent event) {
            event.enqueueWork(() -> ItemProperties.register((Item)MEGABlocks.MEGA_ENERGY_CELL.asItem(), (ResourceLocation)AppEng.makeId((String)"fill_level"), (is, level, entity, i) -> {
                EnergyCellBlockItem energyCell = (EnergyCellBlockItem)MEGABlocks.MEGA_ENERGY_CELL.asItem();
                double curPower = energyCell.getAECurrentPower(is);
                double maxPower = energyCell.getAEMaxPower(is);
                return (float)(curPower / maxPower);
            }));
        }

        private static void initItemColours(RegisterColorHandlersEvent.Item event) {
            ArrayList standardCells = new ArrayList();
            standardCells.addAll(MEGAItems.getItemCells());
            standardCells.addAll(MEGAItems.getFluidCells());
            standardCells.add(MEGAItems.BULK_ITEM_CELL);
            ArrayList<ItemDefinition<? extends AbstractPortableCell>> portableCells = new ArrayList<ItemDefinition<? extends AbstractPortableCell>>();
            portableCells.addAll(MEGAItems.getItemPortables());
            portableCells.addAll(MEGAItems.getFluidPortables());
            if (Addons.APPMEK.isLoaded()) {
                standardCells.addAll(AppMekItems.getCells());
                standardCells.add(AppMekItems.RADIOACTIVE_CHEMICAL_CELL);
                portableCells.addAll(AppMekItems.getPortables());
            }
            event.register(BasicStorageCell::getColor, standardCells.toArray(new ItemLike[0]));
            event.register(AbstractPortableCell::getColor, portableCells.toArray(new ItemLike[0]));
        }

        private static void initStorageCellModels(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                ResourceLocation itemCell = MEGACells.makeId("block/drive/cells/mega_item_cell");
                MEGAItems.getItemCells().forEach(cell -> StorageCellModels.registerModel((ItemLike)cell, (ResourceLocation)itemCell));
                MEGAItems.getItemPortables().forEach(cell -> StorageCellModels.registerModel((ItemLike)cell, (ResourceLocation)itemCell));
                ResourceLocation fluidCell = MEGACells.makeId("block/drive/cells/mega_item_cell");
                MEGAItems.getFluidCells().forEach(cell -> StorageCellModels.registerModel((ItemLike)cell, (ResourceLocation)fluidCell));
                MEGAItems.getFluidPortables().forEach(cell -> StorageCellModels.registerModel((ItemLike)cell, (ResourceLocation)fluidCell));
                StorageCellModels.registerModel(MEGAItems.BULK_ITEM_CELL, (ResourceLocation)MEGACells.makeId("block/drive/cells/bulk_item_cell"));
                if (Addons.APPMEK.isLoaded()) {
                    ResourceLocation chemCell = MEGACells.makeId("block/drive/cells/mega_chemical_cell");
                    AppMekItems.getCells().forEach(cell -> StorageCellModels.registerModel((ItemLike)cell, (ResourceLocation)chemCell));
                    AppMekItems.getPortables().forEach(cell -> StorageCellModels.registerModel((ItemLike)cell, (ResourceLocation)chemCell));
                    StorageCellModels.registerModel((ItemLike)AppMekItems.RADIOACTIVE_CHEMICAL_CELL.asItem(), (ResourceLocation)MEGACells.makeId("block/drive/cells/radioactive_chemical_cell"));
                }
            });
        }
    }
}

