/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.definition;

import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.blockentity.crafting.CraftingBlockEntity;
import appeng.blockentity.crafting.CraftingMonitorBlockEntity;
import appeng.blockentity.networking.EnergyCellBlockEntity;
import appeng.core.definitions.BlockDefinition;
import gripe._90.megacells.MEGACells;
import gripe._90.megacells.block.entity.MEGAInterfaceBlockEntity;
import gripe._90.megacells.block.entity.MEGAPatternProviderBlockEntity;
import gripe._90.megacells.definition.MEGABlocks;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public final class MEGABlockEntities {
    private static final Map<ResourceLocation, BlockEntityType<?>> BLOCK_ENTITY_TYPES = new HashMap();
    public static final BlockEntityType<EnergyCellBlockEntity> MEGA_ENERGY_CELL = MEGABlockEntities.create("mega_energy_cell", EnergyCellBlockEntity.class, EnergyCellBlockEntity::new, MEGABlocks.MEGA_ENERGY_CELL);
    public static final BlockEntityType<CraftingBlockEntity> MEGA_CRAFTING_UNIT = MEGABlockEntities.create("mega_crafting_unit", CraftingBlockEntity.class, CraftingBlockEntity::new, MEGABlocks.MEGA_CRAFTING_UNIT, MEGABlocks.CRAFTING_ACCELERATOR);
    public static final BlockEntityType<CraftingBlockEntity> MEGA_CRAFTING_STORAGE = MEGABlockEntities.create("mega_crafting_storage", CraftingBlockEntity.class, CraftingBlockEntity::new, MEGABlocks.CRAFTING_STORAGE_1M, MEGABlocks.CRAFTING_STORAGE_4M, MEGABlocks.CRAFTING_STORAGE_16M, MEGABlocks.CRAFTING_STORAGE_64M, MEGABlocks.CRAFTING_STORAGE_256M);
    public static final BlockEntityType<CraftingMonitorBlockEntity> MEGA_CRAFTING_MONITOR = MEGABlockEntities.create("mega_crafting_monitor", CraftingMonitorBlockEntity.class, CraftingMonitorBlockEntity::new, MEGABlocks.CRAFTING_MONITOR);
    public static final BlockEntityType<MEGAInterfaceBlockEntity> MEGA_INTERFACE = MEGABlockEntities.create("mega_interface", MEGAInterfaceBlockEntity.class, MEGAInterfaceBlockEntity::new, MEGABlocks.MEGA_INTERFACE);
    public static final BlockEntityType<MEGAPatternProviderBlockEntity> MEGA_PATTERN_PROVIDER = MEGABlockEntities.create("mega_pattern_provider", MEGAPatternProviderBlockEntity.class, MEGAPatternProviderBlockEntity::new, MEGABlocks.MEGA_PATTERN_PROVIDER);

    public static Map<ResourceLocation, BlockEntityType<?>> getBEs() {
        return Collections.unmodifiableMap(BLOCK_ENTITY_TYPES);
    }

    @SafeVarargs
    private static <T extends AEBaseBlockEntity> BlockEntityType<T> create(String id, Class<T> entityClass, BlockEntityFactory<T> factory, BlockDefinition<? extends AEBaseEntityBlock<?>> ... blockDefinitions) {
        if (blockDefinitions.length == 0) {
            throw new IllegalArgumentException();
        }
        AEBaseEntityBlock[] blocks = (AEBaseEntityBlock[])Arrays.stream(blockDefinitions).map(BlockDefinition::block).toArray(AEBaseEntityBlock[]::new);
        AtomicReference<BlockEntityType> typeHolder = new AtomicReference<BlockEntityType>();
        BlockEntityType type = BlockEntityType.Builder.of((pos, state) -> factory.create((BlockEntityType)typeHolder.get(), pos, state), (Block[])blocks).build(null);
        typeHolder.set(type);
        BLOCK_ENTITY_TYPES.put(MEGACells.makeId(id), type);
        AEBaseBlockEntity.registerBlockEntityItem((BlockEntityType)type, (Item)blockDefinitions[0].asItem());
        AEBaseEntityBlock[] aEBaseEntityBlockArray = blocks;
        int n = aEBaseEntityBlockArray.length;
        for (int i = 0; i < n; ++i) {
            AEBaseEntityBlock block;
            AEBaseEntityBlock baseBlock = block = aEBaseEntityBlockArray[i];
            baseBlock.setBlockEntity(entityClass, type, null, null);
        }
        return type;
    }

    private static interface BlockEntityFactory<T extends AEBaseBlockEntity> {
        public T create(BlockEntityType<T> var1, BlockPos var2, BlockState var3);
    }
}

