/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.integration.appmek.item;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import gripe._90.megacells.definition.MEGAConfig;
import gripe._90.megacells.integration.appmek.item.RadioactiveCellItem;
import java.util.Objects;
import me.ramidzkh.mekae2.ae2.MekanismKey;
import me.ramidzkh.mekae2.ae2.MekanismKeyType;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.common.registries.MekanismGases;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class RadioactiveCellInventory
implements StorageCell {
    private static final String KEY = "key";
    private static final String COUNT = "count";
    static final int MAX_BYTES = 256;
    private static final long MAX_MB = 256L * (long)MekanismKeyType.TYPE.getAmountPerByte();
    private final ISaveProvider container;
    private final ItemStack stack;
    private AEKey storedChemical;
    private final MekanismKey filterChemical;
    private long chemAmount;
    private boolean isPersisted = true;

    RadioactiveCellInventory(ItemStack stack, ISaveProvider container) {
        MekanismKey chemical;
        this.stack = stack;
        this.container = container;
        RadioactiveCellItem cell = (RadioactiveCellItem)stack.getItem();
        AEKey filter = cell.getConfigInventory(this.stack).getKey(0);
        this.filterChemical = filter instanceof MekanismKey ? (chemical = (MekanismKey)filter) : null;
        this.storedChemical = this.getTag().contains(KEY) ? AEKey.fromTagGeneric((CompoundTag)this.getTag().getCompound(KEY)) : null;
        this.chemAmount = this.getTag().getLong(COUNT);
    }

    private CompoundTag getTag() {
        return this.stack.getOrCreateTag();
    }

    public CellState getStatus() {
        if (this.chemAmount == 0L) {
            return CellState.EMPTY;
        }
        if (this.chemAmount == MAX_MB) {
            return CellState.FULL;
        }
        if (this.chemAmount > MAX_MB / 2L) {
            return CellState.TYPES_FULL;
        }
        if (!this.storedChemical.equals(this.getFilterChemical())) {
            return CellState.FULL;
        }
        return CellState.NOT_EMPTY;
    }

    public AEKey getStoredChemical() {
        return this.storedChemical;
    }

    public long getChemAmount() {
        return this.chemAmount;
    }

    public AEKey getFilterChemical() {
        return this.filterChemical;
    }

    public long getUsedBytes() {
        return this.chemAmount / (long)MekanismKeyType.TYPE.getAmountPerByte();
    }

    public double getIdleDrain() {
        return 250.0;
    }

    public boolean isBlackListed(AEKey what) {
        MekanismKey key;
        return !(what instanceof MekanismKey) || ((key = (MekanismKey)what).getStack().getType() == MekanismGases.SPENT_NUCLEAR_WASTE.get() ? !MEGAConfig.CONFIG.isSpentWasteAllowed() : ChemicalAttributeValidator.DEFAULT.process(key.getStack()));
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (amount == 0L || !MekanismKeyType.TYPE.contains(what)) {
            return 0L;
        }
        if (!what.equals(this.filterChemical) || this.isBlackListed(what)) {
            return 0L;
        }
        if (this.storedChemical != null && !this.storedChemical.equals(what)) {
            return 0L;
        }
        if (this.chemAmount == MAX_MB) {
            return 0L;
        }
        long remainingAmount = Math.max(0L, MAX_MB - this.chemAmount);
        if (amount > remainingAmount) {
            amount = remainingAmount;
        }
        if (mode == Actionable.MODULATE) {
            if (this.storedChemical == null) {
                this.storedChemical = what;
            }
            this.chemAmount += amount;
            this.saveChanges();
        }
        return amount;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        long extractAmount = Math.min(Integer.MAX_VALUE, amount);
        long currentCount = this.chemAmount;
        if (this.chemAmount > 0L && Objects.equals(this.storedChemical, what)) {
            if (extractAmount >= currentCount) {
                if (mode == Actionable.MODULATE) {
                    this.storedChemical = null;
                    this.chemAmount = 0L;
                    this.saveChanges();
                }
                return currentCount;
            }
            if (mode == Actionable.MODULATE) {
                this.chemAmount -= extractAmount;
                this.saveChanges();
            }
            return extractAmount;
        }
        return 0L;
    }

    protected void saveChanges() {
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges();
        } else {
            this.persist();
        }
    }

    public void persist() {
        if (this.isPersisted) {
            return;
        }
        if (this.storedChemical == null || this.chemAmount < 0L) {
            this.getTag().remove(KEY);
            this.getTag().remove(COUNT);
        } else {
            this.getTag().put(KEY, (Tag)this.storedChemical.toTagGeneric());
            this.getTag().putLong(COUNT, this.chemAmount);
        }
        this.isPersisted = true;
    }

    public void getAvailableStacks(KeyCounter out) {
        if (this.storedChemical != null && this.chemAmount > 0L) {
            out.add(this.storedChemical, this.chemAmount);
        }
    }

    public boolean canFitInsideCell() {
        return this.filterChemical == null && this.storedChemical == null && this.chemAmount == 0L;
    }

    public Component getDescription() {
        return this.stack.getHoverName();
    }
}

