/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.misc;

import appeng.api.stacks.AEItemKey;
import gripe._90.megacells.definition.MEGATags;
import gripe._90.megacells.misc.CompressionChain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;

public class CompressionService {
    public static final CompressionService INSTANCE = new CompressionService();
    private final Set<CompressionChain> compressionChains = new HashSet<CompressionChain>();
    private final Set<Override> overrides = new HashSet<Override>();

    private CompressionService() {
    }

    public Optional<CompressionChain> getChain(AEItemKey item) {
        return this.compressionChains.stream().filter(chain -> chain.containsVariant(item)).findFirst();
    }

    public void loadRecipes(RecipeManager recipeManager, RegistryAccess access) {
        this.compressionChains.clear();
        this.overrides.clear();
        ArrayList<CraftingRecipe> compressed = new ArrayList<CraftingRecipe>();
        ArrayList<CraftingRecipe> decompressed = new ArrayList<CraftingRecipe>();
        for (RecipeHolder recipe2 : recipeManager.getAllRecipesFor(RecipeType.CRAFTING)) {
            if (this.isCompressionRecipe((CraftingRecipe)recipe2.value(), access)) {
                compressed.add((CraftingRecipe)recipe2.value());
                continue;
            }
            if (!this.isDecompressionRecipe((CraftingRecipe)recipe2.value(), access)) continue;
            decompressed.add((CraftingRecipe)recipe2.value());
        }
        compressed.removeIf(recipe -> this.isIrreversible((CraftingRecipe)recipe, (List<CraftingRecipe>)decompressed, access));
        decompressed.removeIf(recipe -> this.isIrreversible((CraftingRecipe)recipe, (List<CraftingRecipe>)compressed, access));
        Comparator<CraftingRecipe> ingredientSize = Comparator.comparingInt(r -> ((Ingredient)r.getIngredients().get(0)).getItems().length);
        compressed.sort(ingredientSize);
        decompressed.sort(ingredientSize);
        Stream.concat(compressed.stream(), decompressed.stream()).forEach(recipe -> {
            Item baseVariant = recipe.getResultItem(access).getItem();
            if (this.getChain(AEItemKey.of((ItemLike)baseVariant)).isEmpty()) {
                this.compressionChains.add(this.generateChain(baseVariant, compressed, decompressed, access));
            }
        });
    }

    private CompressionChain generateChain(Item baseVariant, List<CraftingRecipe> compressed, List<CraftingRecipe> decompressed, RegistryAccess access) {
        LinkedList<Item> variants = new LinkedList<Item>();
        LinkedList<Byte> multipliers = new LinkedList<Byte>();
        variants.addFirst(baseVariant);
        Variant lower = this.getNextVariant(baseVariant, decompressed, false, access);
        while (lower != null) {
            variants.addFirst(lower.item().getItem());
            multipliers.addFirst(lower.factor());
            lower = this.getNextVariant(lower.item().getItem(), decompressed, false, access);
        }
        multipliers.addFirst((byte)1);
        CompressionChain chain = new CompressionChain();
        for (int i = 0; i < variants.size(); ++i) {
            chain.add(AEItemKey.of((ItemLike)((ItemLike)variants.get(i))), (Byte)multipliers.get(i));
        }
        Variant higher = this.getNextVariant(baseVariant, compressed, true, access);
        while (higher != null) {
            chain.add(higher);
            higher = this.getNextVariant(higher.item().getItem(), compressed, true, access);
        }
        return chain;
    }

    private Variant getNextVariant(Item item, List<CraftingRecipe> recipes, boolean compressed, RegistryAccess access) {
        for (Override override : this.overrides) {
            if (compressed && override.smaller.equals(item)) {
                return new Variant(override.larger, override.factor);
            }
            if (compressed || !override.larger.equals(item)) continue;
            return new Variant(override.smaller, override.factor);
        }
        for (CraftingRecipe recipe : recipes) {
            for (ItemStack input : ((Ingredient)recipe.getIngredients().get(0)).getItems()) {
                if (!input.getItem().equals(item)) continue;
                return new Variant(recipe.getResultItem(access).getItem(), (byte)(compressed ? recipe.getIngredients().size() : recipe.getResultItem(access).getCount()));
            }
        }
        return null;
    }

    private boolean isDecompressionRecipe(CraftingRecipe recipe, RegistryAccess access) {
        return recipe.getIngredients().stream().filter(i -> !i.isEmpty()).count() == 1L && Set.of(Integer.valueOf(4), Integer.valueOf(9)).contains(recipe.getResultItem(access).getCount());
    }

    private boolean isCompressionRecipe(CraftingRecipe recipe, RegistryAccess access) {
        NonNullList ingredients = recipe.getIngredients();
        return recipe.getResultItem(access).getCount() == 1 && ingredients.stream().noneMatch(Ingredient::isEmpty) && Set.of(Integer.valueOf(4), Integer.valueOf(9)).contains(ingredients.size()) && this.sameIngredient(recipe);
    }

    private boolean sameIngredient(CraftingRecipe recipe) {
        NonNullList ingredients = recipe.getIngredients();
        if (recipe instanceof ShapedRecipe) {
            return ingredients.stream().distinct().count() <= 1L;
        }
        ItemStack[] first = ((Ingredient)ingredients.get(0)).getItems();
        for (Ingredient ingredient : ingredients) {
            ItemStack[] stacks = ingredient.getItems();
            if (stacks.length != first.length) {
                return false;
            }
            for (int i = 0; i < stacks.length; ++i) {
                if (ItemStack.isSameItemSameTags((ItemStack)stacks[i], (ItemStack)first[i])) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isIrreversible(CraftingRecipe recipe, List<CraftingRecipe> candidates, RegistryAccess access) {
        if (this.overrideRecipe(recipe, access)) {
            return false;
        }
        ItemStack[] testInput = ((Ingredient)recipe.getIngredients().get(0)).getItems();
        Item testOutput = recipe.getResultItem(access).getItem();
        for (CraftingRecipe candidate : candidates) {
            ItemStack[] input = ((Ingredient)candidate.getIngredients().get(0)).getItems();
            Item output = candidate.getResultItem(access).getItem();
            boolean compressible = Arrays.stream(input).anyMatch(i -> i.is(testOutput));
            boolean decompressible = Arrays.stream(testInput).anyMatch(i -> i.is(output));
            if (!compressible || !decompressible) continue;
            return false;
        }
        return true;
    }

    private boolean overrideRecipe(CraftingRecipe recipe, RegistryAccess access) {
        for (ItemStack input : ((Ingredient)recipe.getIngredients().get(0)).getItems()) {
            if (!input.is(MEGATags.COMPRESSION_OVERRIDES)) continue;
            boolean compressed = !this.isDecompressionRecipe(recipe, access);
            ItemStack output = recipe.getResultItem(access);
            Item smaller = compressed ? input.getItem() : output.getItem();
            Item larger = compressed ? output.getItem() : input.getItem();
            byte factor = (byte)(compressed ? recipe.getIngredients().size() : output.getCount());
            this.overrides.add(new Override(smaller, larger, factor));
            return true;
        }
        return false;
    }

    public record Variant(AEItemKey item, byte factor) {
        private Variant(Item item, byte factor) {
            this(AEItemKey.of((ItemLike)item), factor);
        }
    }

    private record Override(Item smaller, Item larger, byte factor) {
    }
}

