/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.mixin.client;

import gripe._90.megacells.mixin.client.BuiltInModelHooksAccessor;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModelBakery.class})
public abstract class ModelBakeryMixin {
    @Inject(method={"loadModel"}, at={@At(value="HEAD")}, cancellable=true)
    private void loadModelHook(ResourceLocation id, CallbackInfo ci) {
        UnbakedModel model = this.megacells$getUnbakedModel(id);
        if (model != null) {
            this.cacheAndQueueDependencies(id, model);
            ci.cancel();
        }
    }

    @Unique
    private UnbakedModel megacells$getUnbakedModel(ResourceLocation variantId) {
        if (!variantId.getNamespace().equals("megacells")) {
            return null;
        }
        if (variantId instanceof ModelResourceLocation) {
            ModelResourceLocation modelId = (ModelResourceLocation)variantId;
            if ("inventory".equals(modelId.getVariant())) {
                ResourceLocation itemModelId = new ResourceLocation(modelId.getNamespace(), "item/" + modelId.getPath());
                return BuiltInModelHooksAccessor.getBuiltInModels().get(itemModelId);
            }
            return null;
        }
        return BuiltInModelHooksAccessor.getBuiltInModels().get(variantId);
    }

    @Shadow
    protected abstract void cacheAndQueueDependencies(ResourceLocation var1, UnbakedModel var2);
}

