/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lucent.api;

import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public abstract class VecTransformer {
    private static final Vec3[] AXIS_VECS = (Vec3[])Util.make(() -> {
        Vec3[] vecs = new Vec3[]{new Vec3(1.0, 0.0, 0.0), new Vec3(0.0, 1.0, 0.0), new Vec3(0.0, 0.0, 1.0)};
        return vecs;
    });
    protected final Vec3 vec;

    public VecTransformer(Vec3 vec) {
        this.vec = vec;
    }

    public abstract Vec3 apply();

    public Vec3 applyForEntity(Entity entity) {
        return this.apply().add(entity.position());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof VecTransformer)) return false;
        VecTransformer v = (VecTransformer)obj;
        if (this.getClass() != v.getClass()) return false;
        if (!Objects.equals(this.vec, v.vec)) return false;
        return true;
    }

    public static Vec3 rotateVec(Vec3 vec, float angleDegrees, Direction.Axis axis) {
        double theta = (float)Math.PI / 180 * angleDegrees;
        Vec3 axisVec = AXIS_VECS[axis.ordinal()];
        double x = vec.x();
        double y = vec.y();
        double z = vec.z();
        double u = axisVec.x();
        double v = axisVec.y();
        double w = axisVec.z();
        double xPrime = u * (u * x + v * y + w * z) * (1.0 - Math.cos(theta)) + x * Math.cos(theta) + (-w * y + v * z) * Math.sin(theta);
        double yPrime = v * (u * x + v * y + w * z) * (1.0 - Math.cos(theta)) + y * Math.cos(theta) + (w * x - u * z) * Math.sin(theta);
        double zPrime = w * (u * x + v * y + w * z) * (1.0 - Math.cos(theta)) + z * Math.cos(theta) + (-v * x + u * y) * Math.sin(theta);
        return new Vec3(xPrime, yPrime, zPrime);
    }

    public static class PitchAndYaw
    extends VecTransformer {
        private final float pitch;
        private final float yaw;
        private final Direction.Axis pitchAxis;

        public PitchAndYaw(Vec3 vec, float pitchDegrees, float yawDegrees) {
            this(vec, pitchDegrees, yawDegrees, Direction.Axis.X);
        }

        public PitchAndYaw(Vec3 vec, float pitchDegrees, float yawDegrees, Direction.Axis pitchAxis) {
            super(vec);
            this.pitch = pitchDegrees;
            this.yaw = yawDegrees;
            this.pitchAxis = pitchAxis;
        }

        @Override
        public Vec3 apply() {
            Vec3 vec = PitchAndYaw.rotateVec(this.vec, this.pitch, this.pitchAxis);
            return PitchAndYaw.rotateVec(vec, this.yaw, Direction.Axis.Y);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) return false;
            if (!(obj instanceof PitchAndYaw)) return false;
            PitchAndYaw v = (PitchAndYaw)obj;
            if (this.pitch != v.pitch) return false;
            if (this.yaw != v.yaw) return false;
            if (this.pitchAxis != v.pitchAxis) return false;
            return true;
        }
    }

    public static class Rotated
    extends VecTransformer {
        private final float angle;
        private final Direction.Axis axis;

        public Rotated(Vec3 vec, float angleDegrees, Direction.Axis axis) {
            super(vec);
            this.angle = angleDegrees;
            this.axis = axis;
        }

        @Override
        public Vec3 apply() {
            return Rotated.rotateVec(this.vec, this.angle, this.axis);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) return false;
            if (!(obj instanceof Rotated)) return false;
            Rotated v = (Rotated)obj;
            if (this.axis != v.axis) return false;
            if (this.angle != v.angle) return false;
            return true;
        }
    }

    public static class RaytracedFacing
    extends VecTransformer {
        private final Vec3 anchor;
        private final ClipContext.Block blockClip;
        private final ClipContext.Fluid fluidClip;

        public RaytracedFacing(Vec3 maxDist, Vec3 anchor, ClipContext.Block blockClip, ClipContext.Fluid fluidClip) {
            super(maxDist);
            this.anchor = anchor;
            this.blockClip = blockClip;
            this.fluidClip = fluidClip;
        }

        public RaytracedFacing(float maxDist, Vec3 anchor) {
            this(new Vec3(0.0, 0.0, (double)maxDist), anchor);
        }

        public RaytracedFacing(Vec3 maxDist, Vec3 anchor) {
            this(maxDist, anchor, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE);
        }

        @Override
        public Vec3 apply() {
            return this.vec.add(this.anchor);
        }

        @Override
        public Vec3 applyForEntity(Entity entity) {
            Vec3 dest = new Facing(this.vec, this.anchor).applyForEntity(entity);
            BlockHitResult hitResult = entity.level().clip(new ClipContext(entity.position().add(this.anchor), dest, this.blockClip, this.fluidClip, entity));
            return hitResult.getLocation().add(new Vec3(hitResult.getDirection().step()));
        }
    }

    public static class Facing
    extends VecTransformer {
        private final Vec3 anchor;

        public Facing(Vec3 vec, Vec3 anchor) {
            super(vec);
            this.anchor = anchor;
        }

        public Facing(Vec3 vec) {
            this(vec, Vec3.ZERO);
        }

        public Facing(float left, float up, float forward) {
            this(new Vec3((double)left, (double)up, (double)forward));
        }

        @Override
        public Vec3 apply() {
            return this.vec.add(this.anchor);
        }

        @Override
        public Vec3 applyForEntity(Entity entity) {
            Vec2 lookVec = entity.getRotationVector();
            Vec3 pos = new PitchAndYaw(this.vec, lookVec.x, -lookVec.y).apply();
            return pos.add(this.anchor).add(entity.position());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) return false;
            if (!(obj instanceof Facing)) return false;
            Facing v = (Facing)obj;
            if (!Objects.equals(this.anchor, v.anchor)) return false;
            return true;
        }
    }

    public static class Relative
    extends VecTransformer {
        public Relative(Vec3 vec) {
            super(vec);
        }

        public Relative(float x, float y, float z) {
            this(new Vec3((double)x, (double)y, (double)z));
        }

        @Override
        public Vec3 apply() {
            return this.vec;
        }
    }

    public static class Direct
    extends VecTransformer {
        public Direct(Vec3 vec) {
            super(vec);
        }

        @Override
        public Vec3 apply() {
            return Vec3.ZERO;
        }

        @Override
        public Vec3 applyForEntity(Entity entity) {
            return this.apply().add(this.vec);
        }
    }
}

