/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lucent.api.data.objects;

import com.legacy.lucent.api.data.objects.LightLevelProvider;
import com.legacy.lucent.core.LucentMod;
import com.legacy.lucent.core.LucentRegistry;
import com.legacy.lucent.core.data.managers.DatapackType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;

public class EntityLighting<T extends Entity> {
    private static final Codec<EntityLighting<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().optionalFieldOf("id").forGetter(r -> r.entity), (App)LightLevelProvider.codec(LightLevelProvider.Source.ENTITY).fieldOf("light").forGetter(r -> r.provider), (App)Codec.BOOL.optionalFieldOf("works_underwater", (Object)true).forGetter(r -> r.worksUnderwater), (App)Codec.BOOL.optionalFieldOf("works_on_land", (Object)true).forGetter(r -> r.worksOnLand)).apply((Applicative)instance, EntityLighting::new));
    public static final DatapackType<ResourceLocation, EntityLighting<?>> TYPE = DatapackType.byName(EntityLighting.class, "dynamic_lighting/entity", CODEC);
    private final Optional<EntityType<?>> entity;
    private final LightLevelProvider<?> provider;
    private final boolean worksUnderwater;
    private final boolean worksOnLand;

    private EntityLighting(Optional<EntityType<?>> entity, LightLevelProvider<?> provider, boolean worksUnderwater, boolean worksOnLand) {
        this.entity = entity;
        this.provider = provider;
        this.worksUnderwater = worksUnderwater;
        this.worksOnLand = worksOnLand;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<EntityType<?>> entity() {
        return this.entity;
    }

    public LightLevelProvider<?> provider() {
        return this.provider;
    }

    public boolean worksUnderwater() {
        return this.worksUnderwater;
    }

    public boolean worksOnLand() {
        return this.worksOnLand;
    }

    public static class Builder {
        Optional<EntityType<? extends Entity>> entityType = Optional.empty();
        LightLevelProvider<?> provider = LightLevelProvider.Direct.MAX_LIGHTING;
        boolean worksUnderwater = true;
        boolean worksOnLand = true;
        boolean failed = false;

        private Builder() {
        }

        public Builder entity(@Nullable EntityType<?> entityType) {
            this.entityType = Optional.ofNullable(entityType);
            return this;
        }

        public Builder entity(ResourceLocation entityID) {
            if (BuiltInRegistries.ENTITY_TYPE.containsKey(entityID)) {
                return this.entity((EntityType)BuiltInRegistries.ENTITY_TYPE.get(entityID));
            }
            LucentMod.LOGGER.warn("  [" + LucentRegistry.sourceName + "] -> [" + entityID + "] was not found in registry", new Object[0]);
            this.failed = true;
            return this;
        }

        public Builder entity(String entityID) {
            if (ResourceLocation.isValidResourceLocation((String)entityID)) {
                return this.entity(new ResourceLocation(entityID));
            }
            LucentMod.LOGGER.warn("  [" + LucentRegistry.sourceName + "] -> [" + entityID + "] is not a valid resource location", new Object[0]);
            this.failed = true;
            return this;
        }

        public Builder light(LightLevelProvider<?> provider) {
            this.provider = provider;
            return this;
        }

        public Builder light(int light) {
            return this.light(new LightLevelProvider.Direct(light));
        }

        public Builder light(Block block) {
            return this.light(new LightLevelProvider.MatchBlock(block));
        }

        public Builder light(Function<? extends Entity, Integer> function) {
            return this.light(new LightLevelProvider.Custom<Entity>(function));
        }

        public Builder worksUnderwater(boolean worksUnderwater) {
            this.worksUnderwater = worksUnderwater;
            return this;
        }

        public Builder worksOnLand(boolean worksOnLand) {
            this.worksOnLand = worksOnLand;
            return this;
        }

        public boolean hasFailed() {
            return this.failed;
        }

        public EntityLighting<?> build() {
            return new EntityLighting(this.entityType, this.provider, this.worksUnderwater, this.worksOnLand);
        }
    }
}

