/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lucent.api.data.objects;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.legacy.lucent.api.registry.ItemLightingRegistry;
import com.legacy.lucent.core.LucentMod;
import com.legacy.lucent.core.LucentRegistry;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.ResourceLocationException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.apache.logging.log4j.util.Strings;

public interface LightLevelProvider<T> {
    public static final byte MIN_LIGHT = 0;
    public static final byte MAX_LIGHT = 15;

    public static Codec<LightLevelProvider<?>> codec(Source source) {
        Codec codec = LightLevelProviderType.REGISTRY_CODEC.dispatch(LightLevelProvider::getType, LightLevelProviderType::getCodec);
        if (source != Source.ANY) {
            Function<LightLevelProvider, DataResult> validate = prov -> {
                if (prov.getSource().children.contains((Object)source)) {
                    return DataResult.success((Object)prov);
                }
                return DataResult.error(() -> LightLevelProviderType.REGISTRY.inverse().get(prov.getType()) + " is not applicable on " + source);
            };
            codec = codec.flatXmap(validate, validate);
        }
        Codec tryDirect = Codec.either((Codec)Codec.INT, (Codec)codec).xmap(either -> (LightLevelProvider)either.map(Direct::new, Function.identity()), prov -> Either.right((Object)prov));
        return tryDirect;
    }

    public int getLightLevel(RegistryAccess var1, T var2);

    public LightLevelProviderType<? extends LightLevelProvider<?>> getType();

    public Source getSource();

    public static Optional<NbtPathArgument.NbtPath> parseNbtPath(String tagPath) {
        try {
            return Optional.of(new NbtPathArgument().parse(new StringReader(tagPath)));
        }
        catch (CommandSyntaxException e) {
            return Optional.empty();
        }
    }

    public static Optional<CompoundTag> parseTag(String tagString) {
        try {
            tagString = tagString.replace("'", "\"");
            return Optional.of(new TagParser(new StringReader(tagString)).readStruct());
        }
        catch (CommandSyntaxException e) {
            return Optional.empty();
        }
    }

    public static interface LightLevelProviderType<A extends LightLevelProvider<?>> {
        public static final BiMap<ResourceLocation, LightLevelProviderType<?>> REGISTRY = HashBiMap.create();
        public static final Codec<LightLevelProviderType<?>> REGISTRY_CODEC = ResourceLocation.CODEC.flatXmap(key -> Optional.ofNullable((LightLevelProviderType)REGISTRY.get(key)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown light level provider type for key " + key + ". Registered providers: " + REGISTRY.keySet())), type -> Optional.ofNullable((ResourceLocation)REGISTRY.inverse().get(type)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown light level provider type for object " + type)));
        public static final LightLevelProviderType<Direct<?>> DIRECT = LightLevelProviderType.register("direct", () -> Direct.CODEC);
        public static final LightLevelProviderType<MatchBlock<?>> MATCH_BLOCK = LightLevelProviderType.register("match_block", () -> MatchBlock.CODEC);
        public static final LightLevelProviderType<IfNbt<?>> IF_NBT = LightLevelProviderType.register("if_nbt", () -> IfNbt.CODEC);
        public static final LightLevelProviderType<MatchNbt<?>> MATCH_NBT = LightLevelProviderType.register("match_nbt", () -> MatchNbt.CODEC);
        public static final LightLevelProviderType<MatchNbtItem<?>> MATCH_NBT_ITEM = LightLevelProviderType.register("match_nbt_item", () -> MatchNbtItem.CODEC);
        public static final LightLevelProviderType<MatchNbtBlock<?>> MATCH_NBT_BLOCK = LightLevelProviderType.register("match_nbt_block", () -> MatchNbtBlock.CODEC);
        public static final LightLevelProviderType<MatchNbtFluid<?>> MATCH_NBT_FLUID = LightLevelProviderType.register("match_nbt_fluid", () -> MatchNbtFluid.CODEC);
        public static final LightLevelProviderType<MatchEnchantment> MATCH_ENCHANTMENT = LightLevelProviderType.register("match_enchantment", () -> MatchEnchantment.CODEC);
        public static final LightLevelProviderType<MatchArmorTrim> MATCH_ARMOR_TRIM = LightLevelProviderType.register("match_armor_trim", () -> MatchArmorTrim.CODEC);
        public static final LightLevelProviderType<Composite<?>> COMPOSITE = LightLevelProviderType.register("composite", () -> Composite.CODEC);
        public static final LightLevelProviderType<MinComposite<?>> MIN_COMPOSITE = LightLevelProviderType.register("min_composite", () -> MinComposite.CODEC);
        public static final LightLevelProviderType<AverageComposite<?>> AVERAGE_COMPOSITE = LightLevelProviderType.register("average_composite", () -> AverageComposite.CODEC);
        public static final LightLevelProviderType<Custom<?>> CUSTOM = LightLevelProviderType.register("custom", () -> Custom.CODEC);

        public Codec<A> getCodec();

        private static <A extends LightLevelProvider<?>> LightLevelProviderType<A> register(String name, LightLevelProviderType<A> type) {
            return LightLevelProviderType.register(LucentMod.locate(name), type);
        }

        public static <A extends LightLevelProvider<?>> LightLevelProviderType<A> register(ResourceLocation name, LightLevelProviderType<A> type) {
            REGISTRY.put((Object)name, type);
            return type;
        }

        default public String getTypeName() {
            return Optional.ofNullable((ResourceLocation)REGISTRY.inverse().get((Object)this)).map(ResourceLocation::toString).orElse("null");
        }
    }

    public static enum Source {
        ITEM_STACK("item", ItemStack.class, new Source[0]),
        ENTITY("entity", Entity.class, new Source[0]),
        ANY("any", Object.class, ITEM_STACK, ENTITY);

        private final Class<?> validator;
        private final Set<Source> children;
        private final String name;

        private Source(String name, Class<?> validator, Source ... children) {
            this.name = name;
            this.validator = validator;
            HashSet<Source> s = new HashSet<Source>();
            s.add(this);
            for (Source child : children) {
                s.add(child);
            }
            this.children = Set.copyOf(s);
        }

        public boolean isValidClass(Object o) {
            return this.validator.isInstance(o);
        }

        public String toString() {
            return this.name;
        }
    }

    public static interface TagGetter {
        default public Optional<CompoundTag> getNbt(Object o) {
            if (o instanceof ItemStack) {
                return Optional.ofNullable(((ItemStack)o).getTag());
            }
            if (o instanceof Entity) {
                CompoundTag t = new CompoundTag();
                ((Entity)o).saveWithoutId(t);
                return Optional.of(t);
            }
            if (o instanceof BlockEntity) {
                return Optional.of(((BlockEntity)o).saveWithoutMetadata());
            }
            return Optional.empty();
        }

        default public Optional<Tag> getTag(CompoundTag tag, NbtPathArgument.NbtPath tagPath) {
            try {
                List tags = tagPath.get((Tag)tag);
                Iterator it = tags.iterator();
                Tag ret = (Tag)it.next();
                if (it.hasNext()) {
                    LucentMod.LOGGER.error("Found multiple tags matching {}", tagPath);
                }
                return Optional.ofNullable(ret);
            }
            catch (CommandSyntaxException e) {
                return Optional.empty();
            }
        }
    }

    public record Custom<T>(BiFunction<RegistryAccess, T, Integer> lightFunction) implements LightLevelProvider<T>
    {
        private static final Custom<?> INSTANCE = new Custom<Object>(o -> 0);
        private static final Codec<Custom<?>> CODEC = new Codec<Custom<?>>(){

            public <U> DataResult<Pair<Custom<?>, U>> decode(DynamicOps<U> ops, U input) {
                return DataResult.error(() -> "Cannot decode light provider lucent:custom. This is to be used internally.", (Object)Pair.of(INSTANCE, input));
            }

            public <U> DataResult<U> encode(Custom<?> input, DynamicOps<U> ops, U prefix) {
                return DataResult.error(() -> "Cannot encode light provider lucent:custom. This is to be used internally.");
            }
        };

        public Custom(Function<T, Integer> lightFunction) {
            this((RegistryAccess r, T o) -> (Integer)lightFunction.apply(o));
        }

        @Override
        public int getLightLevel(RegistryAccess registryAccess, T o) {
            return this.lightFunction.apply(registryAccess, (RegistryAccess)o);
        }

        @Override
        public LightLevelProviderType<? extends LightLevelProvider<?>> getType() {
            return LightLevelProviderType.CUSTOM;
        }

        @Override
        public Source getSource() {
            return Source.ANY;
        }

        @Override
        public String toString() {
            return String.format("%s", LightLevelProviderType.REGISTRY.inverse().get(this.getType()));
        }
    }

    public static class AverageComposite<T>
    extends Composite<T> {
        private static final Codec<AverageComposite<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LightLevelProvider.codec(Source.ANY).listOf().fieldOf("children").forGetter(r -> r.children)).apply((Applicative)instance, AverageComposite::new));

        public AverageComposite(List<LightLevelProvider<?>> children) {
            super(children);
        }

        @Override
        public int getLightLevel(RegistryAccess registryAccess, T o) {
            OptionalDouble optionalRet = this.children.stream().mapToInt(lp -> {
                if (lp.getSource().isValidClass(o)) {
                    return lp.getLightLevel(registryAccess, o);
                }
                return 0;
            }).filter(i -> i > 0).average();
            return optionalRet.isPresent() ? (int)Math.round(optionalRet.getAsDouble()) : 0;
        }

        @Override
        public LightLevelProviderType<? extends LightLevelProvider<?>> getType() {
            return LightLevelProviderType.AVERAGE_COMPOSITE;
        }
    }

    public static class MinComposite<T>
    extends Composite<T> {
        private static final Codec<MinComposite<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LightLevelProvider.codec(Source.ANY).listOf().fieldOf("children").forGetter(r -> r.children)).apply((Applicative)instance, MinComposite::new));

        public MinComposite(List<LightLevelProvider<?>> children) {
            super(children);
        }

        @Override
        public int getLightLevel(RegistryAccess registryAccess, T o) {
            OptionalInt optionalRet = this.children.stream().mapToInt(lp -> {
                if (lp.getSource().isValidClass(o)) {
                    return lp.getLightLevel(registryAccess, o);
                }
                return 0;
            }).filter(i -> i > 0).min();
            return optionalRet.isPresent() ? optionalRet.getAsInt() : 0;
        }

        @Override
        public LightLevelProviderType<? extends LightLevelProvider<?>> getType() {
            return LightLevelProviderType.MIN_COMPOSITE;
        }
    }

    public static class Composite<T>
    implements LightLevelProvider<T> {
        private static final Codec<Composite<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LightLevelProvider.codec(Source.ANY).listOf().fieldOf("children").forGetter(r -> r.children)).apply((Applicative)instance, Composite::new));
        protected final List<LightLevelProvider<?>> children;

        public Composite(List<LightLevelProvider<?>> children) {
            this.children = children;
        }

        @Override
        public int getLightLevel(RegistryAccess registryAccess, T o) {
            OptionalInt optionalRet = this.children.stream().mapToInt(lp -> {
                if (lp.getSource().isValidClass(o)) {
                    return lp.getLightLevel(registryAccess, o);
                }
                return 0;
            }).filter(i -> i > 0).max();
            return optionalRet.isPresent() ? optionalRet.getAsInt() : 0;
        }

        @Override
        public LightLevelProviderType<? extends LightLevelProvider<?>> getType() {
            return LightLevelProviderType.COMPOSITE;
        }

        @Override
        public Source getSource() {
            return Source.ANY;
        }

        public String toString() {
            return String.format("%s[%s]", LightLevelProviderType.REGISTRY.inverse().get(this.getType()), Strings.join(this.children, (char)','));
        }
    }

    public record MatchArmorTrim(ResourceKey<TrimMaterial> trimMaterial, int value) implements LightLevelProvider<ItemStack>
    {
        private static final Codec<MatchArmorTrim> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.TRIM_MATERIAL).fieldOf("trim_material").forGetter(r -> r.trimMaterial), (App)Codec.INT.fieldOf("value").forGetter(r -> r.value)).apply((Applicative)instance, MatchArmorTrim::new));

        @Override
        public int getLightLevel(RegistryAccess registryAccess, ItemStack o) {
            Optional trim = ArmorTrim.getTrim((RegistryAccess)registryAccess, (ItemStack)o, (boolean)false);
            if (trim.isPresent() && ((ArmorTrim)trim.get()).material().is(this.trimMaterial)) {
                return this.value;
            }
            return 0;
        }

        @Override
        public LightLevelProviderType<? extends LightLevelProvider<?>> getType() {
            return LightLevelProviderType.MATCH_ARMOR_TRIM;
        }

        @Override
        public Source getSource() {
            return Source.ITEM_STACK;
        }

        @Override
        public String toString() {
            return String.format("%s[armor_trim_material=%s, value=%f]", LightLevelProviderType.REGISTRY.inverse().get(this.getType()), this.trimMaterial.location(), this.value);
        }
    }

    public record MatchEnchantment(Enchantment enchantment, float scale) implements LightLevelProvider<ItemStack>
    {
        private static final Codec<MatchEnchantment> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ENCHANTMENT.byNameCodec().fieldOf("enchantment").forGetter(r -> r.enchantment), (App)Codec.FLOAT.fieldOf("scale").forGetter(r -> Float.valueOf(r.scale))).apply((Applicative)instance, MatchEnchantment::new));

        @Override
        public int getLightLevel(RegistryAccess registryAccess, ItemStack o) {
            Integer level = (Integer)o.getAllEnchantments().get(this.enchantment);
            return level != null ? Mth.floor((float)((float)(o.getEnchantmentLevel(this.enchantment) + 1) * this.scale)) : 0;
        }

        @Override
        public LightLevelProviderType<? extends LightLevelProvider<?>> getType() {
            return LightLevelProviderType.MATCH_ENCHANTMENT;
        }

        @Override
        public Source getSource() {
            return Source.ITEM_STACK;
        }

        @Override
        public String toString() {
            return String.format("%s[enchantment=%s, scale=%f]", LightLevelProviderType.REGISTRY.inverse().get(this.getType()), BuiltInRegistries.ENCHANTMENT.getKey((Object)this.enchantment), Float.valueOf(this.scale));
        }
    }

    public record MatchNbtFluid<T>(NbtPathArgument.NbtPath tagPath) implements LightLevelProvider<T>,
    TagGetter
    {
        private static final Codec<MatchNbtFluid<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("tag_path").flatXmap(s -> LightLevelProvider.parseNbtPath(s).map(DataResult::success).orElse(DataResult.error(() -> s + " is not a valid nbt tag path.")), t -> DataResult.success((Object)t.toString())).forGetter(r -> r.tagPath)).apply((Applicative)instance, MatchNbtFluid::new));
        private static final Function<String, Integer> FLUID_LIGHT_CACHE = Util.memoize(fluidName -> {
            try {
                Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(new ResourceLocation(fluidName));
                if (fluid != null) {
                    return fluid.defaultFluidState().createLegacyBlock().getLightEmission();
                }
            }
            catch (ResourceLocationException e) {
                LucentMod.LOGGER.error((Object)e, new Object[0]);
                e.printStackTrace();
            }
            return 0;
        });

        public MatchNbtFluid(String tagPath) {
            this(LightLevelProvider.parseNbtPath(tagPath).orElseThrow(() -> new IllegalArgumentException("[lucent] [light provider = " + LightLevelProviderType.MATCH_NBT_FLUID.getTypeName() + "] " + tagPath + " could not be read as an nbt tag path.")));
        }

        @Override
        public int getLightLevel(RegistryAccess registryAccess, T o) {
            Optional<Tag> opTag;
            Optional<CompoundTag> opNbt = this.getNbt(o);
            if (opNbt.isPresent() && (opTag = this.getTag(opNbt.get(), this.tagPath)).isPresent()) {
                return FLUID_LIGHT_CACHE.apply(opTag.get().getAsString());
            }
            return 0;
        }

        @Override
        public LightLevelProviderType<? extends LightLevelProvider<?>> getType() {
            return LightLevelProviderType.MATCH_NBT_FLUID;
        }

        @Override
        public Source getSource() {
            return Source.ANY;
        }

        @Override
        public String toString() {
            return String.format("%s[tag_path=%s]", LightLevelProviderType.REGISTRY.inverse().get(this.getType()), this.tagPath);
        }
    }

    public record MatchNbtBlock<T>(NbtPathArgument.NbtPath tagPath) implements LightLevelProvider<T>,
    TagGetter
    {
        private static final Codec<MatchNbtBlock<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("tag_path").flatXmap(s -> LightLevelProvider.parseNbtPath(s).map(DataResult::success).orElse(DataResult.error(() -> s + " is not a valid nbt tag path.")), t -> DataResult.success((Object)t.toString())).forGetter(r -> r.tagPath)).apply((Applicative)instance, MatchNbtBlock::new));
        private static final Function<String, Integer> BLOCK_LIGHT_CACHE = Util.memoize(blockName -> {
            try {
                Block block = (Block)BuiltInRegistries.BLOCK.get(new ResourceLocation(blockName));
                if (block != null) {
                    return block.defaultBlockState().getLightEmission();
                }
            }
            catch (ResourceLocationException e) {
                LucentMod.LOGGER.error((Object)e, new Object[0]);
                e.printStackTrace();
            }
            return 0;
        });

        public MatchNbtBlock(String tagPath) {
            this(LightLevelProvider.parseNbtPath(tagPath).orElseThrow(() -> new IllegalArgumentException("[lucent] [light provider = " + LightLevelProviderType.MATCH_NBT_BLOCK.getTypeName() + "] " + tagPath + " could not be read as an nbt tag path.")));
        }

        @Override
        public int getLightLevel(RegistryAccess registryAccess, T o) {
            Optional<Tag> opTag;
            Optional<CompoundTag> opNbt = this.getNbt(o);
            if (opNbt.isPresent() && (opTag = this.getTag(opNbt.get(), this.tagPath)).isPresent()) {
                return BLOCK_LIGHT_CACHE.apply(opTag.get().getAsString());
            }
            return 0;
        }

        @Override
        public LightLevelProviderType<? extends LightLevelProvider<?>> getType() {
            return LightLevelProviderType.MATCH_NBT_BLOCK;
        }

        @Override
        public Source getSource() {
            return Source.ANY;
        }

        @Override
        public String toString() {
            return String.format("%s[tag_path=%s]", LightLevelProviderType.REGISTRY.inverse().get(this.getType()), this.tagPath);
        }
    }

    public record MatchNbtItem<T>(NbtPathArgument.NbtPath tagPath) implements LightLevelProvider<T>,
    TagGetter
    {
        private static final Codec<MatchNbtItem<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("tag_path").flatXmap(s -> LightLevelProvider.parseNbtPath(s).map(DataResult::success).orElse(DataResult.error(() -> s + " is not a valid nbt tag path.")), t -> DataResult.success((Object)t.toString())).forGetter(r -> r.tagPath)).apply((Applicative)instance, MatchNbtItem::new));
        private static final Function<String, Item> ITEM_CACHE = Util.memoize(itemName -> {
            try {
                Item item = (Item)BuiltInRegistries.ITEM.get(new ResourceLocation(itemName));
                if (item != null) {
                    return item;
                }
            }
            catch (ResourceLocationException e) {
                LucentMod.LOGGER.error((Object)e, new Object[0]);
                e.printStackTrace();
            }
            return Items.AIR;
        });

        public MatchNbtItem(String tagPath) {
            this(LightLevelProvider.parseNbtPath(tagPath).orElseThrow(() -> new IllegalArgumentException("[lucent] [light provider = " + LightLevelProviderType.MATCH_NBT_ITEM.getTypeName() + "] " + tagPath + " could not be read as an nbt tag path.")));
        }

        @Override
        public int getLightLevel(RegistryAccess registryAccess, T o) {
            Optional<Tag> opTag;
            Optional<CompoundTag> opNbt = this.getNbt(o);
            if (opNbt.isPresent() && (opTag = this.getTag(opNbt.get(), this.tagPath)).isPresent()) {
                ItemStack stack;
                Tag tag = opTag.get();
                if (tag instanceof CompoundTag) {
                    CompoundTag stackTag = (CompoundTag)tag;
                    stack = ItemStack.of((CompoundTag)stackTag);
                } else if (tag instanceof StringTag) {
                    StringTag stringTag = (StringTag)tag;
                    stack = ITEM_CACHE.apply(stringTag.getAsString()).getDefaultInstance();
                } else {
                    stack = ItemStack.EMPTY;
                }
                return ItemLightingRegistry.get(stack);
            }
            return 0;
        }

        @Override
        public LightLevelProviderType<? extends LightLevelProvider<?>> getType() {
            return LightLevelProviderType.MATCH_NBT_ITEM;
        }

        @Override
        public Source getSource() {
            return Source.ANY;
        }

        @Override
        public String toString() {
            return String.format("%s[tag_path=%s]", LightLevelProviderType.REGISTRY.inverse().get(this.getType()), this.tagPath);
        }
    }

    public record MatchNbt<T>(NbtPathArgument.NbtPath tagPath, float scale) implements LightLevelProvider<T>,
    TagGetter
    {
        private static final Codec<MatchNbt<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("tag_path").flatXmap(s -> LightLevelProvider.parseNbtPath(s).map(DataResult::success).orElse(DataResult.error(() -> s + " is not a valid nbt tag path.")), t -> DataResult.success((Object)t.toString())).forGetter(r -> r.tagPath), (App)Codec.FLOAT.fieldOf("scale").forGetter(r -> Float.valueOf(r.scale))).apply((Applicative)instance, MatchNbt::new));

        public MatchNbt(String tagPath, float scale) {
            this(LightLevelProvider.parseNbtPath(tagPath).orElseThrow(() -> new IllegalArgumentException("[lucent] [light provider = " + LightLevelProviderType.MATCH_NBT.getTypeName() + "] " + tagPath + " could not be read as an nbt tag path.")), scale);
        }

        @Override
        public int getLightLevel(RegistryAccess registryAccess, T o) {
            Optional<Tag> opTag;
            Optional<CompoundTag> opNbt = this.getNbt(o);
            if (opNbt.isPresent() && (opTag = this.getTag(opNbt.get(), this.tagPath)).isPresent()) {
                Tag tag = opTag.get();
                if (tag instanceof NumericTag) {
                    NumericTag numeric = (NumericTag)tag;
                    return Mth.floor((double)(numeric.getAsDouble() * (double)this.scale));
                }
                return Mth.floor((float)this.scale);
            }
            return 0;
        }

        @Override
        public LightLevelProviderType<? extends LightLevelProvider<?>> getType() {
            return LightLevelProviderType.MATCH_NBT;
        }

        @Override
        public Source getSource() {
            return Source.ANY;
        }

        @Override
        public String toString() {
            return String.format("%s[tag_path=%s, scale=%f]", LightLevelProviderType.REGISTRY.inverse().get(this.getType()), this.tagPath, Float.valueOf(this.scale));
        }
    }

    public record IfNbt<T>(CompoundTag tag, int value) implements LightLevelProvider<T>,
    TagGetter
    {
        private static final Codec<IfNbt<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("tag").flatXmap(s -> LightLevelProvider.parseTag(s).map(DataResult::success).orElse(DataResult.error(() -> s + " is not a valid nbt tag.")), nbt -> DataResult.success((Object)nbt.getAsString())).forGetter(r -> r.tag), (App)Codec.INT.fieldOf("value").forGetter(r -> r.value)).apply((Applicative)instance, IfNbt::new));

        public IfNbt(String tagString, int value) {
            this(LightLevelProvider.parseTag(tagString).orElseThrow(() -> new IllegalArgumentException("[lucent] [light provider = " + LightLevelProviderType.IF_NBT.getTypeName() + "] " + tagString + " could not be read as an nbt tag.")), value);
        }

        @Override
        public int getLightLevel(RegistryAccess registryAccess, T o) {
            Optional<CompoundTag> opNbt = this.getNbt(o);
            if (opNbt.isPresent() && NbtUtils.compareNbt((Tag)this.tag, (Tag)((Tag)opNbt.get()), (boolean)true)) {
                return this.value;
            }
            return 0;
        }

        @Override
        public LightLevelProviderType<? extends LightLevelProvider<?>> getType() {
            return LightLevelProviderType.IF_NBT;
        }

        @Override
        public Source getSource() {
            return Source.ANY;
        }

        @Override
        public String toString() {
            return String.format("%s[tag=%s, value=%d]", LightLevelProviderType.REGISTRY.inverse().get(this.getType()), this.tag, this.value);
        }
    }

    public static class MatchBlock<T>
    implements LightLevelProvider<T> {
        private static final Codec<MatchBlock<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("block").forGetter(r -> r.block)).apply((Applicative)instance, MatchBlock::new));
        private final Block block;
        private byte cachedVal = (byte)-128;

        public MatchBlock(Block block) {
            this.block = block;
        }

        @Override
        public int getLightLevel(RegistryAccess registryAccess, T o) {
            if (this.cachedVal == -128) {
                Minecraft mc = Minecraft.getInstance();
                BlockState state = this.block.defaultBlockState();
                this.cachedVal = (byte)Mth.clamp((int)(mc.level == null ? state.getLightEmission() : state.getLightEmission((BlockGetter)mc.level, LucentRegistry.DEFAULT_POS)), (int)0, (int)15);
            }
            return this.cachedVal;
        }

        @Override
        public LightLevelProviderType<? extends LightLevelProvider<?>> getType() {
            return LightLevelProviderType.MATCH_BLOCK;
        }

        @Override
        public Source getSource() {
            return Source.ANY;
        }

        public String toString() {
            return String.format("%s[block=%s]", LightLevelProviderType.REGISTRY.inverse().get(this.getType()), BuiltInRegistries.BLOCK.getKey((Object)this.block));
        }
    }

    public record Direct<T>(byte value) implements LightLevelProvider<T>
    {
        private static final Codec<Direct<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BYTE.fieldOf("value").forGetter(r -> r.value)).apply((Applicative)instance, Direct::new));
        public static final Direct<?> MAX_LIGHTING = new Direct(15);

        public Direct(int value) {
            this((byte)Mth.clamp((int)value, (int)0, (int)15));
        }

        @Override
        public int getLightLevel(RegistryAccess registryAccess, T o) {
            return this.value;
        }

        @Override
        public LightLevelProviderType<? extends LightLevelProvider<?>> getType() {
            return LightLevelProviderType.DIRECT;
        }

        @Override
        public Source getSource() {
            return Source.ANY;
        }

        @Override
        public String toString() {
            return String.format("%s[value=%d]", LightLevelProviderType.REGISTRY.inverse().get(this.getType()), this.value);
        }
    }
}

