/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lucent.api.data.providers;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.legacy.lucent.core.data.managers.DatapackType;
import com.legacy.lucent.core.data.managers.LucentDataManager;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class LucentDataProvider<K, V>
implements DataProvider {
    protected static final Logger LOGGER = LogManager.getLogger();
    private final BiMap<ResourceLocation, V> registry = HashBiMap.create();
    protected final PackOutput packOutput;
    protected final String directory;
    protected final DatapackType<K, V> type;
    protected final LucentDataManager<K, V> manager;
    private CompletableFuture<HolderLookup.Provider> lookupProvider;

    public LucentDataProvider(LucentDataManager<K, V> manager, PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        this.packOutput = output;
        this.type = manager.getType();
        this.directory = manager.getDirectory();
        this.manager = manager;
        this.lookupProvider = lookupProvider;
    }

    public PackType getPackType() {
        return PackType.SERVER_DATA;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        Path outputFolder = this.packOutput.getOutputFolder();
        try {
            HolderLookup.Provider prov = this.lookupProvider.get();
            this.gatherData(prov);
        }
        catch (InterruptedException | ExecutionException e1) {
            e1.printStackTrace();
        }
        ArrayList<CompletableFuture> list = new ArrayList<CompletableFuture>();
        for (Map.Entry dataEntry : this.getRegistry().entrySet()) {
            Path outputFile = this.createPath(outputFolder, (ResourceLocation)dataEntry.getKey());
            try {
                Object val = dataEntry.getValue();
                JsonObject json = ((JsonElement)this.type.valueCodec().encodeStart((DynamicOps)JsonOps.INSTANCE, val).getOrThrow(false, IllegalStateException::new)).getAsJsonObject();
                list.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)outputFile));
            }
            catch (Exception e2) {
                LOGGER.error("Couldn't save {} {}", (Object)this.directory, (Object)outputFile, (Object)e2);
            }
        }
        Map<Object, Object> keyedData = this.registry.entrySet().stream().collect(Collectors.toMap(e -> this.type.keyCompute().apply((ResourceLocation)e.getKey(), e.getValue()), e -> e.getValue()));
        this.manager.injectData(keyedData);
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    protected abstract void gatherData(HolderLookup.Provider var1);

    protected BiMap<ResourceLocation, V> getRegistry() {
        return this.registry;
    }

    protected void register(String fileName, V object) throws IllegalArgumentException {
        this.register(this.locate(fileName), object);
    }

    protected void register(ResourceLocation fileLocation, V object) throws IllegalArgumentException {
        if (this.getRegistry().putIfAbsent((Object)fileLocation, object) != null) {
            throw new IllegalArgumentException("Duplicate key! Item " + this.directory + " exists under the name " + fileLocation);
        }
    }

    protected Path createPath(Path outputFolder, ResourceLocation dataEntryName) {
        return outputFolder.resolve(this.getPackType().getDirectory() + "/" + dataEntryName.getNamespace() + "/" + this.directory + "/" + dataEntryName.getPath() + ".json");
    }

    public String getName() {
        return this.directory;
    }

    public ResourceLocation locate(String resourceLocationPath) {
        return new ResourceLocation("lucent", resourceLocationPath);
    }

    public static abstract class Client<K, V>
    extends LucentDataProvider<K, V> {
        public Client(LucentDataManager<K, V> manager, PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(manager, output, lookupProvider);
        }

        @Override
        public PackType getPackType() {
            return PackType.CLIENT_RESOURCES;
        }
    }
}

