/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lucent.api.registry;

import com.legacy.lucent.core.LucentConfig;
import com.legacy.lucent.core.LucentMod;
import com.legacy.lucent.core.LucentRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EntityLightSourcePosRegistry {
    public static final Map<EntityType<?>, Function<Entity, Vec3>> REGISTRY = new HashMap();
    private final BiConsumer<EntityType<?>, Function<Entity, Vec3>> register;

    public EntityLightSourcePosRegistry(BiConsumer<EntityType<?>, Function<Entity, Vec3>> register) {
        this.register = register;
    }

    public <T extends Entity> void register(EntityType<T> entityType, Function<T, Vec3> positionGetter) {
        this.register.accept(entityType, positionGetter);
    }

    public void register(ResourceLocation entityTypeId, Function<Entity, Vec3> positionGetter) {
        if (BuiltInRegistries.ENTITY_TYPE.containsKey(entityTypeId)) {
            this.register((EntityType)BuiltInRegistries.ENTITY_TYPE.get(entityTypeId), positionGetter);
        } else if (((Boolean)LucentConfig.CLIENT.logRegistry.get()).booleanValue()) {
            LucentMod.LOGGER.warn("  [" + LucentRegistry.sourceName + "] -> [" + entityTypeId + "] was not found in registry", new Object[0]);
        }
    }

    public void register(String entityTypeId, Function<Entity, Vec3> positionGetter) {
        this.register(new ResourceLocation(entityTypeId), positionGetter);
    }

    public static Vec3 get(Entity entity) {
        Function<Entity, Vec3> getter = REGISTRY.get(entity.getType());
        if (getter != null) {
            return getter.apply(entity);
        }
        return new Vec3(entity.getX(), (double)entity.getBbHeight() / 2.0 + entity.getY(), entity.getZ());
    }
}

