/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lucent.api.registry;

import com.legacy.lucent.api.data.objects.EntityLighting;
import com.legacy.lucent.api.data.objects.LightLevelProvider;
import com.legacy.lucent.core.LucentConfig;
import com.legacy.lucent.core.LucentMod;
import com.legacy.lucent.core.LucentRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EntityLightingRegistry {
    private static final Map<EntityType<?>, List<EntityLighting<?>>> PROVIDER_REGISTRY = new HashMap();
    private static final List<EntityLighting<?>> DEFAULT_PROVIDERS = new ArrayList();
    private static Map<EntityType<?>, LucentRegistry.Source> registeredBy = new HashMap();

    public void register(EntityLighting<?> lighting) {
        LightLevelProvider<?> prov = lighting.provider();
        lighting.entity().ifPresentOrElse(entity -> {
            LightLevelProvider.Direct direct;
            if (prov instanceof LightLevelProvider.Direct && (direct = (LightLevelProvider.Direct)prov).value() <= -1) {
                this.remove((EntityType<?>)entity);
            } else {
                boolean overwrote = false;
                LucentRegistry.Source source = registeredBy.get(entity);
                if (source != null && source.isBuiltin && source.priority < LucentRegistry.currentSource.priority) {
                    ArrayList<EntityLighting> list = new ArrayList<EntityLighting>();
                    list.add(lighting);
                    PROVIDER_REGISTRY.put((EntityType<?>)entity, (List<EntityLighting<?>>)list);
                    overwrote = true;
                } else {
                    PROVIDER_REGISTRY.computeIfAbsent((EntityType<?>)entity, i -> new ArrayList()).add(lighting);
                }
                registeredBy.put((EntityType<?>)entity, LucentRegistry.currentSource);
                if (((Boolean)LucentConfig.CLIENT.logRegistry.get()).booleanValue()) {
                    LucentMod.LOGGER.info("  [" + LucentRegistry.sourceName + "] -> [" + BuiltInRegistries.ENTITY_TYPE.getKey(entity) + "] " + (overwrote ? "overwrote " : "added ") + prov, new Object[0]);
                }
            }
        }, () -> {
            DEFAULT_PROVIDERS.add(lighting);
            if (((Boolean)LucentConfig.CLIENT.logRegistry.get()).booleanValue()) {
                LucentMod.LOGGER.info("  [" + LucentRegistry.sourceName + "] -> [all entities] added " + prov, new Object[0]);
            }
        });
    }

    public void register(EntityLighting.Builder entityLightingBuilder) {
        if (!entityLightingBuilder.hasFailed()) {
            this.register(entityLightingBuilder.build());
        }
    }

    public void register(@Nullable EntityType<?> entityType, LightLevelProvider<?> lightLevelProvider) {
        this.register(EntityLighting.builder().entity(entityType).light(lightLevelProvider));
    }

    public void register(LightLevelProvider<?> lightLevelProvider) {
        this.register(null, lightLevelProvider);
    }

    public void register(@Nullable EntityType<?> entityType, int lightLevel) {
        if (lightLevel <= -1) {
            this.remove(entityType);
        } else {
            this.register(EntityLighting.builder().entity(entityType).light(new LightLevelProvider.Direct(lightLevel)));
        }
    }

    public void register(ResourceLocation entityTypeId, int lightLevel) {
        if (BuiltInRegistries.ENTITY_TYPE.containsKey(entityTypeId)) {
            this.register((EntityType)BuiltInRegistries.ENTITY_TYPE.get(entityTypeId), lightLevel);
        } else if (((Boolean)LucentConfig.CLIENT.logRegistry.get()).booleanValue()) {
            LucentMod.LOGGER.warn("  [" + LucentRegistry.sourceName + "] -> [" + entityTypeId + "] was not found in registry", new Object[0]);
        }
    }

    public void register(String entityTypeId, int lightLevel) {
        if (ResourceLocation.isValidResourceLocation((String)entityTypeId)) {
            this.register(new ResourceLocation(entityTypeId), lightLevel);
        } else {
            LucentRegistry.logInvalidResourceLocation(entityTypeId);
        }
    }

    public <T extends Entity> void register(@Nullable EntityType<T> entityType, @Nullable Function<T, Integer> lightLevel) {
        if (lightLevel == null) {
            this.remove(entityType);
        } else {
            this.register(EntityLighting.builder().entity(entityType).light(new LightLevelProvider.Custom<T>(lightLevel)));
        }
    }

    public <T extends Entity> void register(@Nullable Function<T, Integer> lightFunction) {
        this.register((EntityType)null, lightFunction);
    }

    public <T extends Entity> void register(ResourceLocation entityTypeId, @Nullable Function<T, Integer> lightFunction) {
        if (BuiltInRegistries.ENTITY_TYPE.containsKey(entityTypeId)) {
            this.register((EntityType)BuiltInRegistries.ENTITY_TYPE.get(entityTypeId), lightFunction);
        } else if (((Boolean)LucentConfig.CLIENT.logRegistry.get()).booleanValue()) {
            LucentMod.LOGGER.warn("  [" + LucentRegistry.sourceName + "] -> [" + entityTypeId + "] was not found in registry", new Object[0]);
        }
    }

    public <T extends Entity> void register(String entityTypeId, @Nullable Function<T, Integer> lightFunction) {
        if (ResourceLocation.isValidResourceLocation((String)entityTypeId)) {
            this.register(new ResourceLocation(entityTypeId), lightFunction);
        } else {
            LucentRegistry.logInvalidResourceLocation(entityTypeId);
        }
    }

    public void remove(EntityType<?> entityType) {
        if (PROVIDER_REGISTRY.remove(entityType) != null && ((Boolean)LucentConfig.CLIENT.logRegistry.get()).booleanValue()) {
            LucentMod.LOGGER.info("  [" + LucentRegistry.sourceName + "] -> Removed [" + BuiltInRegistries.ENTITY_TYPE.getKey(entityType) + "]", new Object[0]);
        }
    }

    public List<EntityType<?>> getMatching(Predicate<EntityType<?>> itemPredicate) {
        return BuiltInRegistries.ENTITY_TYPE.stream().filter(itemPredicate).toList();
    }

    public List<EntityType<?>> getMatchingByName(Predicate<ResourceLocation> namePredicate) {
        return BuiltInRegistries.ENTITY_TYPE.keySet().stream().filter(namePredicate).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ENTITY_TYPE).get(arg_0)).toList();
    }

    public static int get(Entity entity) {
        List<EntityLighting<?>> lightings = PROVIDER_REGISTRY.getOrDefault(entity.getType(), DEFAULT_PROVIDERS);
        if (lightings.isEmpty()) {
            return 0;
        }
        int ret = 0;
        for (EntityLighting<?> lighting : lightings) {
            LightLevelProvider<?> prov;
            if (!lighting.worksUnderwater() && entity.level().getFluidState(entity.blockPosition()).is(FluidTags.WATER) || !lighting.worksOnLand() && !entity.level().getFluidState(entity.blockPosition()).is(FluidTags.WATER) || !(prov = lighting.provider()).getSource().isValidClass(entity)) continue;
            int l = prov.getLightLevel(entity.level().registryAccess(), entity);
            if (l >= 15) {
                return l;
            }
            if (l <= ret) continue;
            ret = l;
        }
        return ret;
    }

    @Deprecated
    public static void clear() {
        PROVIDER_REGISTRY.clear();
        DEFAULT_PROVIDERS.clear();
        EntityLightingRegistry.clearCache();
    }

    @Deprecated
    public static void clearCache() {
        registeredBy.clear();
    }
}

