/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lucent.core;

import com.legacy.lucent.api.plugin.ILucentPlugin;
import com.legacy.lucent.api.plugin.LucentPlugin;
import com.legacy.lucent.api.registry.LightLevelProviderRegistry;
import com.legacy.lucent.core.LucentConfig;
import com.legacy.lucent.core.LucentMod;
import com.legacy.lucent.core.LucentRegistry;
import com.legacy.lucent.core.PluginManager;
import com.legacy.lucent.core.data.managers.LucentAssets;
import com.legacy.lucent.core.dynamic_lighting.DynamicLightingEngine;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.SectionPos;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TickEvent;

public class LucentClient {
    private static PluginManager<ILucentPlugin> plugins = null;
    private static Set<SectionPos> toMarkDirty = new HashSet<SectionPos>();

    public static void init(IEventBus modBus) {
        plugins = new PluginManager<ILucentPlugin>(ILucentPlugin.class, LucentPlugin.class, LucentMod.LOGGER::getLogger, () -> "lucent", modBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)LucentConfig.CLIENT_SPEC);
        modBus.addListener(LucentClient::loadComplete);
        modBus.addListener(LucentAssets::registerListeners);
        IEventBus forgeBus = NeoForge.EVENT_BUS;
        forgeBus.register(LucentClient.class);
    }

    public static List<ILucentPlugin> getPlugins() {
        return plugins.get();
    }

    public static PluginManager<ILucentPlugin> pluginManager() {
        return plugins;
    }

    protected static void loadComplete(FMLLoadCompleteEvent event) {
        DynamicLightingEngine.start();
        event.enqueueWork(() -> {
            LightLevelProviderRegistry provRegistry = new LightLevelProviderRegistry();
            plugins.forEach(p -> p.registerLightLevelProviderTypes(provRegistry));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    protected static void onLogin(ClientPlayerNetworkEvent.LoggingIn event) {
        LucentRegistry.registerData();
        LucentConfig.detectEnvironment();
        Class<LucentClient> clazz = LucentClient.class;
        synchronized (LucentClient.class) {
            toMarkDirty = new HashSet<SectionPos>();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @SubscribeEvent
    protected static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            DynamicLightingEngine.clearForcedLights();
            DynamicLightingEngine.tickDeepDark();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SubscribeEvent
    protected static void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.START || Minecraft.getInstance().level == null || toMarkDirty.isEmpty()) return;
        Class<LucentClient> clazz = LucentClient.class;
        synchronized (LucentClient.class) {
            SectionPos[] poses = (SectionPos[])toMarkDirty.toArray(SectionPos[]::new);
            toMarkDirty = new HashSet<SectionPos>();
            for (SectionPos section : poses) {
                LucentClient.setDirty(section);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void setDirty(SectionPos section) {
        Minecraft.getInstance().levelRenderer.setSectionDirty(section.getX(), section.getY(), section.getZ());
        plugins.forEach(p -> p.onSectionMarkedDirty(section));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduleSetDirty(SectionPos section) {
        Class<LucentClient> clazz = LucentClient.class;
        synchronized (LucentClient.class) {
            toMarkDirty.add(section);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static int packLight(float blockLight, int skyLight) {
        return (int)(blockLight * 16.0f) | skyLight << 20;
    }
}

