/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lucent.core;

import com.legacy.lucent.api.registry.ArmorTrimLightingRegistry;
import com.legacy.lucent.api.registry.BlockTextureLightingRegistry;
import com.legacy.lucent.api.registry.EntityLightSourcePosRegistry;
import com.legacy.lucent.api.registry.EntityLightingRegistry;
import com.legacy.lucent.api.registry.ItemLightingRegistry;
import com.legacy.lucent.core.LucentClient;
import com.legacy.lucent.core.LucentConfig;
import com.legacy.lucent.core.LucentMod;
import com.legacy.lucent.core.PluginManager;
import com.legacy.lucent.core.data.managers.LucentAssets;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.ModConfigSpec;

@OnlyIn(value=Dist.CLIENT)
public class LucentRegistry {
    public static Source currentSource = Source.UNKNOWN;
    public static String sourceName = Source.UNKNOWN.text;
    public static final BlockPos DEFAULT_POS = new BlockPos(0, 70, 0);

    public static void registerData() {
        LucentRegistry.loadItemLightLevels();
        LucentRegistry.loadEntityLightLevels();
        LucentRegistry.loadBlockTextureLightLevels();
        LucentRegistry.loadArmorTrimLightLevels();
        LucentRegistry.loadEntityLightSourcePosGetters();
    }

    private static void loadItemLightLevels() {
        if (((Boolean)LucentConfig.CLIENT.logRegistry.get()).booleanValue()) {
            LucentMod.LOGGER.info("Registering item light levels", new Object[0]);
        }
        ItemLightingRegistry.clear();
        ItemLightingRegistry registry = new ItemLightingRegistry();
        if (((Boolean)LucentConfig.CLIENT.vanillaDynamicLighting.get()).booleanValue()) {
            LucentRegistry.setSource(Source.REGISTRY);
            Minecraft mc = Minecraft.getInstance();
            if (mc.level != null) {
                BuiltInRegistries.ITEM.forEach(item -> {
                    int lightLevel = LucentRegistry.getItemLightLevel(item);
                    if (lightLevel > 0) {
                        registry.register((Item)item, lightLevel);
                    }
                });
            }
        }
        LucentClient.getPlugins().forEach(plugin -> {
            LucentRegistry.setSource(Source.PLUGIN, LucentClient.pluginManager().getPluginName((PluginManager.IBasePlugin)plugin));
            plugin.registerItemLightings(registry);
        });
        LucentRegistry.setSource(Source.RESOURCE_PACK);
        LucentAssets.ITEM_LIGHTING.getData().values().forEach(registry::register);
        LucentRegistry.setSource(Source.CONFIG);
        LucentRegistry.loadRegistryConfigLightLevels(LucentConfig.CLIENT.itemBrightnessOverrides, BuiltInRegistries.ITEM, registry::register, "item", "minecraft:torch=14");
        LucentRegistry.setSource(Source.UNKNOWN);
        ItemLightingRegistry.clearCache();
    }

    public static int getItemLightLevel(Item item) {
        int lightLevel;
        block5: {
            lightLevel = 0;
            try {
                Minecraft mc = Minecraft.getInstance();
                if (item instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)item;
                    lightLevel = blockItem.getBlock().defaultBlockState().getLightEmission((BlockGetter)mc.level, DEFAULT_POS);
                } else if (item instanceof BucketItem) {
                    BucketItem bucketItem = (BucketItem)item;
                    lightLevel = bucketItem.getFluid().defaultFluidState().createLegacyBlock().getLightEmission((BlockGetter)mc.level, DEFAULT_POS);
                }
            }
            catch (Exception e) {
                if (!((Boolean)LucentConfig.CLIENT.logRegistry.get()).booleanValue()) break block5;
                LucentMod.LOGGER.error("Couldn't get light level for {}. {}", Optional.ofNullable(BuiltInRegistries.ITEM.getKey((Object)item)).orElse((ResourceLocation)item), e);
            }
        }
        return lightLevel;
    }

    private static void loadEntityLightLevels() {
        if (((Boolean)LucentConfig.CLIENT.logRegistry.get()).booleanValue()) {
            LucentMod.LOGGER.info("Registering entity light levels", new Object[0]);
        }
        EntityLightingRegistry.clear();
        EntityLightingRegistry registry = new EntityLightingRegistry();
        LucentClient.getPlugins().forEach(plugin -> {
            LucentRegistry.setSource(Source.PLUGIN, LucentClient.pluginManager().getPluginName((PluginManager.IBasePlugin)plugin));
            plugin.registerEntityLightings(registry);
        });
        LucentRegistry.setSource(Source.RESOURCE_PACK);
        LucentAssets.ENTITY_LIGHTING.getData().values().forEach(registry::register);
        LucentRegistry.setSource(Source.CONFIG);
        LucentRegistry.loadRegistryConfigLightLevels(LucentConfig.CLIENT.entityBrightnessOverrides, BuiltInRegistries.ENTITY_TYPE, registry::register, "entity", "minecraft:blaze=9");
        LucentRegistry.setSource(Source.UNKNOWN);
        EntityLightingRegistry.clearCache();
    }

    private static void loadBlockTextureLightLevels() {
        if (((Boolean)LucentConfig.CLIENT.logRegistry.get()).booleanValue()) {
            LucentMod.LOGGER.info("Registering block texture light levels", new Object[0]);
        }
        BlockTextureLightingRegistry.clear();
        BlockTextureLightingRegistry registry = new BlockTextureLightingRegistry();
        LucentClient.getPlugins().forEach(plugin -> {
            LucentRegistry.setSource(Source.PLUGIN, LucentClient.pluginManager().getPluginName((PluginManager.IBasePlugin)plugin));
            plugin.registerBlockTextureLightings(registry);
        });
        LucentRegistry.setSource(Source.RESOURCE_PACK);
        LucentAssets.EMISSIVE_BLOCK_TEXTURE.getData().values().forEach(registry::register);
        LucentRegistry.setSource(Source.CONFIG);
        LucentRegistry.loadNameConfigLightLevels(LucentConfig.CLIENT.blockTextureBrightnessOverrides, registry::register, "block texture", "minecraft:block/end_portal_frame_eye=12");
        LucentRegistry.setSource(Source.UNKNOWN);
    }

    private static void loadArmorTrimLightLevels() {
        if (((Boolean)LucentConfig.CLIENT.logRegistry.get()).booleanValue()) {
            LucentMod.LOGGER.info("Registering armor trim texture light levels", new Object[0]);
        }
        ArmorTrimLightingRegistry.clear();
        ArmorTrimLightingRegistry registry = new ArmorTrimLightingRegistry();
        LucentClient.getPlugins().forEach(plugin -> {
            LucentRegistry.setSource(Source.PLUGIN, LucentClient.pluginManager().getPluginName((PluginManager.IBasePlugin)plugin));
            plugin.registerArmorTrimTextureLightings(registry);
        });
        LucentRegistry.setSource(Source.RESOURCE_PACK);
        LucentAssets.EMISSIVE_ARMOR_TRIM_TEXTURE.getData().values().forEach(registry::register);
        LucentRegistry.setSource(Source.CONFIG);
        LucentRegistry.loadRegistryConfigLightLevels(LucentConfig.CLIENT.armorTrimBrightnessOverrides, Registries.TRIM_MATERIAL, registry::register, "armor trim texture", "minecraft:gold=10");
        LucentRegistry.setSource(Source.UNKNOWN);
    }

    private static void loadEntityLightSourcePosGetters() {
        EntityLightSourcePosRegistry.REGISTRY.clear();
        EntityLightSourcePosRegistry registry = new EntityLightSourcePosRegistry((entity, getterFunc) -> EntityLightSourcePosRegistry.REGISTRY.put((EntityType<?>)entity, (Function<Entity, Vec3>)getterFunc));
        LucentClient.getPlugins().forEach(plugin -> {
            LucentRegistry.setSource(Source.PLUGIN, LucentClient.pluginManager().getPluginName((PluginManager.IBasePlugin)plugin));
            plugin.registerEntityLightSourcePositionGetter(registry);
        });
        LucentRegistry.setSource(Source.UNKNOWN);
    }

    protected static void setSource(Source source) {
        LucentRegistry.setSource(source, source.text);
    }

    protected static void setSource(Source source, String extra) {
        currentSource = source;
        sourceName = source.text + " (" + extra + ")";
    }

    private static <T> void loadRegistryConfigLightLevels(ModConfigSpec.ConfigValue<List<? extends String>> values, Registry<T> registry, BiConsumer<T, Integer> registerMethod, String name, String example) {
        ((List)values.get()).forEach(s -> {
            if (s.contains("=")) {
                String[] data = s.split("=");
                try {
                    ResourceLocation registryObjectName = new ResourceLocation(data[0]);
                    if (registry.containsKey(registryObjectName)) {
                        Object registryObject = registry.get(registryObjectName);
                        Integer lightLevel = Integer.parseInt(data[1]);
                        registerMethod.accept(registryObject, lightLevel);
                    }
                }
                catch (ResourceLocationException e) {
                    LucentMod.LOGGER.error("\"" + s + "\" is not a valid config value. The " + name + " ID may have disallowed characters. " + e.getLocalizedMessage(), new Object[0]);
                }
                catch (NumberFormatException e) {
                    LucentMod.LOGGER.error("\"" + s + "\" is not a valid config value. The brightness number could not be read as a number. " + e.getLocalizedMessage(), new Object[0]);
                }
            } else {
                LucentMod.LOGGER.error("\"" + s + "\" is not a valid config value. It must be formatted as \"<" + name + "_id>=<brightness>\". Example, \"" + example + "\"", new Object[0]);
            }
        });
    }

    private static <T> void loadRegistryConfigLightLevels(ModConfigSpec.ConfigValue<List<? extends String>> values, ResourceKey<Registry<T>> registryKey, BiConsumer<ResourceKey<T>, Integer> registerMethod, String name, String example) {
        ((List)values.get()).forEach(s -> {
            if (s.contains("=")) {
                String[] data = s.split("=");
                try {
                    ResourceLocation registryObjectName = new ResourceLocation(data[0]);
                    ResourceKey key = ResourceKey.create((ResourceKey)registryKey, (ResourceLocation)registryObjectName);
                    Integer lightLevel = Integer.parseInt(data[1]);
                    registerMethod.accept(key, lightLevel);
                }
                catch (ResourceLocationException e) {
                    LucentMod.LOGGER.error("\"" + s + "\" is not a valid config value. The " + name + " ID may have disallowed characters. " + e.getLocalizedMessage(), new Object[0]);
                }
                catch (NumberFormatException e) {
                    LucentMod.LOGGER.error("\"" + s + "\" is not a valid config value. The brightness number could not be read as a number. " + e.getLocalizedMessage(), new Object[0]);
                }
            } else {
                LucentMod.LOGGER.error("\"" + s + "\" is not a valid config value. It must be formatted as \"<" + name + "_id>=<brightness>\". Example, \"" + example + "\"", new Object[0]);
            }
        });
    }

    private static void loadNameConfigLightLevels(ModConfigSpec.ConfigValue<List<? extends String>> values, BiConsumer<ResourceLocation, Integer> registerMethod, String name, String example) {
        ((List)values.get()).forEach(s -> {
            if (s.contains("=")) {
                String[] data = s.split("=");
                try {
                    ResourceLocation registryObjectName = new ResourceLocation(data[0]);
                    Integer lightLevel = Integer.parseInt(data[1]);
                    registerMethod.accept(registryObjectName, lightLevel);
                }
                catch (ResourceLocationException e) {
                    LucentMod.LOGGER.error("\"" + s + "\" is not a valid config value. The " + name + " may have disallowed characters. " + e.getLocalizedMessage(), new Object[0]);
                }
                catch (NumberFormatException e) {
                    LucentMod.LOGGER.error("\"" + s + "\" is not a valid config value. The brightness number could not be read as a number. " + e.getLocalizedMessage(), new Object[0]);
                }
            } else {
                LucentMod.LOGGER.error("\"" + s + "\" is not a valid config value. It must be formatted as \"<" + name + ">=<brightness>\". Example, \"" + example + "\"", new Object[0]);
            }
        });
    }

    public static int clampLight(int lightLevel) {
        return Mth.clamp((int)lightLevel, (int)0, (int)15);
    }

    public static void logInvalidResourceLocation(String attemptedResourceLocation) {
        LucentMod.LOGGER.warn("{} is not a valid resource location.", attemptedResourceLocation);
    }

    public static enum Source {
        UNKNOWN("Unknown", 0, true),
        REGISTRY("Registry", 1, true),
        PLUGIN("Plugin", 2, false),
        RESOURCE_PACK("Resource Pack", 3, false),
        CONFIG("Config", 4, false);

        private final String text;
        public final int priority;
        public final boolean isBuiltin;

        private Source(String text, int priority, boolean isBuiltin) {
            this.text = text;
            this.priority = priority;
            this.isBuiltin = isBuiltin;
        }

        public String toString() {
            return this.text;
        }
    }
}

