/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lucent.core.data.managers;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.legacy.lucent.core.LucentMod;
import com.legacy.lucent.core.data.managers.DatapackType;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.Logger;

public abstract class LucentDataManager<K, V>
extends SimplePreparableReloadListener<Map<ResourceLocation, List<JsonElement>>> {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final Logger LOGGER = LucentMod.LOGGER.getLogger();
    protected final DatapackType<K, V> type;
    protected BiMap<K, V> data = HashBiMap.create();
    private final String directory;
    private final String oldDirectory;

    public LucentDataManager(DatapackType<K, V> type) {
        this.type = type;
        this.directory = "lucent_data/" + type.folder();
        this.oldDirectory = "lucent/" + type.folder();
    }

    private Map<ResourceLocation, List<Resource>> listResourceStacks(ResourceManager resourceManager, FileToIdConverter fileToId, FileToIdConverter fileToIdOld) {
        boolean canMerge = DatapackType.Mergable.class.isAssignableFrom(this.type.valueClass());
        Map<ResourceLocation, List> data = canMerge ? fileToId.listMatchingResourceStacks(resourceManager) : fileToId.listMatchingResources(resourceManager).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> List.of((Resource)e.getValue())));
        Map<ResourceLocation, List> old = canMerge ? fileToIdOld.listMatchingResourceStacks(resourceManager) : fileToIdOld.listMatchingResources(resourceManager).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> List.of((Resource)e.getValue())));
        HashMap<ResourceLocation, List<Resource>> ret = new HashMap<ResourceLocation, List<Resource>>();
        data.forEach((rl, l) -> ret.computeIfAbsent((ResourceLocation)rl, k -> new ArrayList()).addAll(l));
        old.forEach((rl, l) -> {
            LOGGER.warn(rl + " is using a deprecated resource pack folder structure. Use \"" + rl.toString().replace(this.oldDirectory, this.directory) + "\" instead. Using the old structure will no longer work in 1.21.");
            ResourceLocation convertedName = rl.withPath(rl.getPath().replace(this.oldDirectory, this.directory));
            ret.computeIfAbsent(convertedName, k -> new ArrayList()).addAll(l);
        });
        return ret;
    }

    protected Map<ResourceLocation, List<JsonElement>> prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        HashMap map = Maps.newHashMap();
        FileToIdConverter fileToId = FileToIdConverter.json((String)this.directory);
        FileToIdConverter fileToIdOld = FileToIdConverter.json((String)this.oldDirectory);
        for (Map.Entry<ResourceLocation, List<Resource>> entry : this.listResourceStacks(resourceManager, fileToId, fileToIdOld).entrySet()) {
            ResourceLocation fullLocation = entry.getKey();
            ResourceLocation id = fileToId.fileToId(fullLocation);
            try {
                ArrayList<JsonElement> jsons = new ArrayList<JsonElement>(entry.getValue().size());
                for (Resource resource : entry.getValue()) {
                    BufferedReader reader = resource.openAsReader();
                    try {
                        JsonElement json = (JsonElement)GsonHelper.fromJson((Gson)GSON, (Reader)reader, JsonElement.class);
                        jsons.add(json);
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                map.put(id, jsons);
            }
            catch (JsonParseException | IOException | IllegalArgumentException e) {
                LOGGER.error("Couldn't parse data file {} from {}", (Object)id, (Object)fullLocation, (Object)e);
            }
        }
        return map;
    }

    protected void apply(Map<ResourceLocation, List<JsonElement>> jsonMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        HashBiMap newDataMap = HashBiMap.create();
        String folderName = this.type.folder();
        for (Map.Entry<ResourceLocation, List<JsonElement>> entry : jsonMap.entrySet()) {
            ResourceLocation fileName = entry.getKey();
            try {
                for (JsonElement json : entry.getValue()) {
                    Object val = ((Pair)this.type.valueCodec().decode((DynamicOps)JsonOps.INSTANCE, (Object)json.getAsJsonObject()).getOrThrow(false, JsonParseException::new)).getFirst();
                    K key = this.type.keyCompute().apply(fileName, val);
                    Pair parsedData = Pair.of(key, (Object)val);
                    this.registerData((BiMap<K, V>)newDataMap, (K)parsedData.getFirst(), (V)parsedData.getSecond());
                }
            }
            catch (Exception e) {
                LOGGER.error("Parsing error loading {}: {}", (Object)folderName, (Object)fileName, (Object)e);
            }
        }
        this.data = newDataMap;
        this.afterLoad();
        LOGGER.info("Loaded {} {}", (Object)newDataMap.size(), (Object)folderName);
    }

    protected void afterLoad() {
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void registerData(BiMap<K, V> activeData, K key, V value) {
        Object oldVal = activeData.get(key);
        if (oldVal instanceof DatapackType.Mergable) {
            DatapackType.Mergable mergable;
            DatapackType.Mergable oldMergable = (DatapackType.Mergable)oldVal;
            if (value instanceof DatapackType.Mergable && !(mergable = (DatapackType.Mergable)value).override()) {
                oldMergable.merge(mergable);
                return;
            }
        }
        activeData.put(key, value);
    }

    public void injectData(Map<K, V> registryData) {
        for (Map.Entry<K, V> entry : registryData.entrySet()) {
            this.registerData(this.data, entry.getKey(), entry.getValue());
        }
        this.afterLoad();
    }

    public DatapackType<K, V> getType() {
        return this.type;
    }

    public BiMap<K, V> getData() {
        return this.data;
    }

    @Nullable
    public V getValue(K key) {
        return (V)this.data.get(key);
    }

    @Nullable
    public K getKey(V value) {
        return (K)this.data.inverse().get(value);
    }

    public boolean containsKey(K key) {
        return key == null ? false : this.data.containsKey(key);
    }

    public String getDirectory() {
        return this.directory;
    }
}

