/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lucent.core.dynamic_lighting;

import com.legacy.lucent.api.EntityBrightness;
import com.legacy.lucent.api.EntityBrightnessMap;
import com.legacy.lucent.api.VecTransformer;
import com.legacy.lucent.api.plugin.ILucentPlugin;
import com.legacy.lucent.api.registry.EntityLightSourcePosRegistry;
import com.legacy.lucent.core.LucentClient;
import com.legacy.lucent.core.LucentConfig;
import com.legacy.lucent.core.LucentMod;
import com.legacy.lucent.core.capability.IEntityLightingData;
import com.legacy.lucent.core.dynamic_lighting.LightData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class DynamicLightingEngine
implements Runnable {
    private static final Thread INSTANCE = new Thread(new DynamicLightingEngine());
    private static Map<BlockPos, LightData> lightData = new HashMap<BlockPos, LightData>();
    private static Map<BlockPos, LightData> forcedLightData = new HashMap<BlockPos, LightData>();
    private static Set<SectionPos> sectionsToUpdate = new HashSet<SectionPos>();
    private static boolean inDeepDark = false;
    private static int deepDarkTransitionTime;
    private static int deepDarkTransition;
    private static float deepDarkScale;

    private DynamicLightingEngine() {
    }

    private static Minecraft MC() {
        return Minecraft.getInstance();
    }

    private static Level level() {
        return DynamicLightingEngine.MC().level;
    }

    private static Player player() {
        return DynamicLightingEngine.MC().player;
    }

    private static Vec3 playerPos() {
        return DynamicLightingEngine.player().position();
    }

    public static boolean hasLightSource(BlockPos pos) {
        return lightData.containsKey(pos) || forcedLightData.containsKey(pos);
    }

    @Nullable
    public static LightData getLightSource(BlockPos pos) {
        LightData data = lightData.get(pos);
        if (data == null) {
            data = forcedLightData.get(pos);
        }
        return data;
    }

    public static boolean sectionNeedsUpdate(BlockPos pos) {
        return DynamicLightingEngine.sectionNeedsUpdate(SectionPos.of((BlockPos)pos));
    }

    public static boolean sectionNeedsUpdate(SectionPos sectionPos) {
        return sectionsToUpdate.contains(sectionPos);
    }

    public static int calcLight(BlockAndTintGetter level, BlockState state, BlockPos pos, LightData lightData) {
        int blockStateLight;
        int skyLight = level.getBrightness(LightLayer.SKY, pos);
        float blockLight = DynamicLightingEngine.calcBlockLight(level, pos, lightData);
        if (blockLight < (float)(blockStateLight = state.getLightEmission((BlockGetter)level, pos))) {
            blockLight = blockStateLight;
        }
        return LucentClient.packLight(blockLight, skyLight);
    }

    public static float calcBlockLight(BlockAndTintGetter level, BlockPos pos, LightData lightData) {
        int levelBlockLight = level.getBrightness(LightLayer.BLOCK, pos);
        if (lightData != null) {
            if (lightData.calculatedBlockLight == -1.0f) {
                float blockLight = lightData.lightLevel;
                if (((Boolean)LucentConfig.CLIENT.smoothBlending.get()).booleanValue()) {
                    List<LightData.SourcePos> sourcePoses = lightData.sourcePoses;
                    float maxBlockLight = 0.0f;
                    for (int i = sourcePoses.size() - 1; i > -1; --i) {
                        LightData parentData;
                        LightData.SourcePos sourcePos = sourcePoses.get(i);
                        if (sourcePos == null || (parentData = DynamicLightingEngine.getLightSource(BlockPos.containing((double)sourcePos.x, (double)sourcePos.y, (double)sourcePos.z))) == null) continue;
                        int parentLight = parentData.lightLevel;
                        float actualDist = DynamicLightingEngine.calcDist((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, sourcePos.x, sourcePos.y, sourcePos.z);
                        int dist = DynamicLightingEngine.calcDist(pos.getX(), pos.getY(), pos.getZ(), (int)Math.floor(sourcePos.x), (int)Math.floor(sourcePos.y), (int)Math.floor(sourcePos.z));
                        int wrappedDist = parentLight - (int)blockLight;
                        float light = (float)parentLight - actualDist;
                        if (wrappedDist > dist) {
                            light -= (float)(wrappedDist - dist);
                        }
                        maxBlockLight = Math.max(maxBlockLight, Mth.clamp((float)light, (float)0.0f, (float)15.0f));
                    }
                    blockLight = maxBlockLight;
                }
                lightData.calculatedBlockLight = blockLight;
            }
            return Math.max(lightData.calculatedBlockLight, (float)levelBlockLight);
        }
        return levelBlockLight;
    }

    public static void blockChanged(BlockPos pos, BlockState state) {
        if (state.isSolid() || DynamicLightingEngine.level() == null) {
            return;
        }
        LightData brightestLight = LightData.NONE;
        for (Direction dir : Direction.values()) {
            LightData offsetLight;
            BlockPos relativePos = pos.relative(dir);
            if (!DynamicLightingEngine.canLightPass(pos, relativePos, dir) || (offsetLight = DynamicLightingEngine.getLightSource(relativePos)) == null || offsetLight.lightLevel <= brightestLight.lightLevel) continue;
            brightestLight = offsetLight;
        }
        LightData data = DynamicLightingEngine.getLightSource(pos);
        if (data != null) {
            LightData.SourcePos sourcePos = data.sourcePoses.get(0);
            if (!pos.equals((Object)BlockPos.containing((double)sourcePos.x, (double)sourcePos.y, (double)sourcePos.z)) && brightestLight.lightLevel - 1 != data.lightLevel) {
                lightData.remove(pos);
                forcedLightData.remove(pos);
            }
        }
        if (brightestLight.lightLevel > 0) {
            LightData inserted = new LightData(brightestLight.lightLevel - 1, brightestLight.sourcePoses.get(0));
            forcedLightData.put(pos, inserted);
            DynamicLightingEngine.setDirty(SectionPos.of((BlockPos)pos));
        }
    }

    public static void clearForcedLights() {
        if (!forcedLightData.isEmpty()) {
            try {
                boolean needsCleared = true;
                for (BlockPos pos : forcedLightData.keySet().stream().toList()) {
                    if (lightData.containsKey(pos)) {
                        forcedLightData.remove(pos);
                    } else {
                        for (Direction dir : Direction.values()) {
                            BlockPos offset = pos.relative(dir);
                            if (!DynamicLightingEngine.hasLightSource(offset)) continue;
                            forcedLightData.remove(pos);
                            break;
                        }
                    }
                    needsCleared = false;
                }
                if (needsCleared) {
                    forcedLightData = new HashMap<BlockPos, LightData>();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void tickDeepDark() {
        Level level;
        Player player = DynamicLightingEngine.player();
        if (player != null && (level = DynamicLightingEngine.level()) != null) {
            if (player.tickCount % 20 == 0) {
                inDeepDark = level.getBiome(BlockPos.containing((Position)DynamicLightingEngine.playerPos())).is(Biomes.DEEP_DARK);
            }
            if (inDeepDark) {
                if (deepDarkTransition > 0) {
                    --deepDarkTransition;
                }
            } else if (deepDarkTransition < deepDarkTransitionTime) {
                ++deepDarkTransition;
            }
            float ddScale = LucentConfig.CLIENT.deepDarkScaling.get().floatValue();
            deepDarkScale = (1.0f - ddScale) * ((float)deepDarkTransition / (float)deepDarkTransitionTime) + ddScale;
        }
    }

    public static void start() {
        if (!INSTANCE.isAlive()) {
            LucentMod.LOGGER.info("Starting dynamic lighting engine", new Object[0]);
            INSTANCE.start();
        } else {
            LucentMod.LOGGER.info("Attempted to start the dynamic lighting engine, but it was already running.", new Object[0]);
        }
    }

    @Override
    public void run() {
        long totalTime = 0L;
        int runs = 0;
        Minecraft mc = DynamicLightingEngine.MC();
        while (true) {
            try {
                while (true) {
                    if (mc.level != null && mc.player != null) {
                        long sleepTime;
                        long startTime = System.currentTimeMillis();
                        DynamicLightingEngine.tick();
                        long time = System.currentTimeMillis() - startTime;
                        int refreshRate = LucentConfig.CLIENT.lightRefreshRate.get();
                        if (((Boolean)LucentConfig.CLIENT.logLightCalculationTime.get()).booleanValue()) {
                            totalTime += time;
                            if (++runs >= 100) {
                                long avTime = totalTime / (long)runs;
                                LucentMod.LOGGER.info("Light calculations took {}ms with a {}ms refresh rate", avTime, refreshRate);
                                if (avTime > (long)(refreshRate + 2)) {
                                    LucentMod.LOGGER.info("{} is the fastest refresh rate your computer can handle in this environment with the current settings", 1000L / avTime);
                                }
                                totalTime = 0L;
                                runs = 0;
                            }
                        }
                        Thread.sleep((sleepTime = (long)refreshRate - time) < 0L ? 0L : sleepTime);
                        continue;
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (Throwable t) {
                if (((Boolean)LucentConfig.CLIENT.logDynamicLightingErrors.get()).booleanValue()) {
                    t.printStackTrace();
                    LucentMod.LOGGER.printStacktrace("Dynamic Lighting Engine Error", t);
                }
                EntityBrightness.activeEntity = null;
                continue;
            }
            break;
        }
    }

    private static void tick() {
        lightData.entrySet().forEach(entry -> {
            ((LightData)entry.getValue()).shouldStay = false;
        });
        HashMap<BlockPos, LightData> newLightData = new HashMap<BlockPos, LightData>(lightData);
        Player player = DynamicLightingEngine.player();
        List entitiesInRange = DynamicLightingEngine.level().getEntitiesOfClass(Entity.class, AABB.unitCubeFromLowerCorner((Vec3)DynamicLightingEngine.playerPos()).inflate((double)((Integer)LucentConfig.CLIENT.maxVisibleDistance.get()).intValue()));
        if (!entitiesInRange.contains(player)) {
            entitiesInRange.add(player);
        }
        entitiesInRange.forEach(e -> {
            EntityBrightnessMap sources = DynamicLightingEngine.getEntityLightLevel(e);
            for (Map.Entry<VecTransformer, Integer> s : sources.getAll().entrySet()) {
                int lightLevel = s.getValue();
                if (lightLevel <= 0) continue;
                Vec3 entityPos = s.getKey().applyForEntity((Entity)e);
                DynamicLightingEngine.addLights(newLightData, BlockPos.containing((Position)entityPos), lightLevel, new LightData.SourcePos(entityPos.x, entityPos.y, entityPos.z));
            }
        });
        newLightData.entrySet().forEach(entry -> {
            LightData newData;
            LightData oldData = lightData.get(entry.getKey());
            if (oldData != null && oldData.equals(newData = (LightData)entry.getValue())) {
                newData.dirty = false;
            }
        });
        lightData = newLightData;
        sectionsToUpdate.clear();
        if (!lightData.isEmpty()) {
            lightData.entrySet().stream().filter(entry -> ((LightData)entry.getValue()).dirty || !((LightData)entry.getValue()).shouldStay).forEach(entry -> {
                BlockPos pos = (BlockPos)entry.getKey();
                SectionPos section = SectionPos.of((BlockPos)pos);
                sectionsToUpdate.add(section);
                int x = pos.getX() & 0xF;
                int y = pos.getY() & 0xF;
                int z = pos.getZ() & 0xF;
                if (x == 0) {
                    sectionsToUpdate.add(SectionPos.of((BlockPos)pos.west()));
                } else if (x == 15) {
                    sectionsToUpdate.add(SectionPos.of((BlockPos)pos.east()));
                }
                if (y == 0) {
                    sectionsToUpdate.add(SectionPos.of((BlockPos)pos.below()));
                } else if (y == 15) {
                    sectionsToUpdate.add(SectionPos.of((BlockPos)pos.above()));
                }
                if (z == 0) {
                    sectionsToUpdate.add(SectionPos.of((BlockPos)pos.north()));
                } else if (z == 15) {
                    sectionsToUpdate.add(SectionPos.of((BlockPos)pos.south()));
                }
            });
            sectionsToUpdate.stream().forEach(DynamicLightingEngine::setDirty);
        }
        lightData.entrySet().removeIf(entry -> !((LightData)entry.getValue()).shouldStay);
        forcedLightData = new HashMap<BlockPos, LightData>();
    }

    private static EntityBrightnessMap getEntityLightLevel(Entity entity) {
        Player player = DynamicLightingEngine.player();
        EntityBrightness.activeEntity = entity;
        EntityBrightness brightness = new EntityBrightness();
        for (ILucentPlugin plugin : LucentClient.getPlugins()) {
            plugin.getEntityLightLevel(brightness);
        }
        int l = brightness.getLightLevel();
        ((IEntityLightingData)entity).lucent$setBrightness(l);
        if (l > 0) {
            l = Math.round(deepDarkScale * (float)l);
        }
        EntityBrightnessMap brightnessMap = new EntityBrightnessMap();
        brightnessMap.add(new VecTransformer.Direct(EntityLightSourcePosRegistry.get(entity)), l);
        for (ILucentPlugin plugin : LucentClient.getPlugins()) {
            plugin.getAdditionalEntityLightLevels(brightnessMap);
        }
        brightnessMap.getAll().entrySet().removeIf(e -> {
            boolean visible = (Boolean)LucentConfig.CLIENT.seeThroughWalls.get();
            if (!visible) {
                Vec3 pos = ((VecTransformer)e.getKey()).applyForEntity(entity);
                boolean bl = visible = DynamicLightingEngine.level().clip(new ClipContext(DynamicLightingEngine.playerPos().add(0.0, (double)player.getEyeHeight(), 0.0), pos, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, entity)).getType() == HitResult.Type.MISS;
                if (!visible && DynamicLightingEngine.playerPos().distanceTo(entity.position()) < 24.0 || DynamicLightingEngine.level().getBrightness(LightLayer.SKY, BlockPos.containing((Position)pos)) > 8) {
                    visible = true;
                }
            }
            return !visible;
        });
        EntityBrightness.activeEntity = null;
        return brightnessMap;
    }

    private static void addLights(Map<BlockPos, LightData> newLightData, BlockPos pos, int lightLevel, LightData.SourcePos sourcePos) {
        if (DynamicLightingEngine.addLightSource(newLightData, pos, lightLevel, sourcePos)) {
            HashMap<BlockPos, Integer> positions = new HashMap<BlockPos, Integer>();
            positions.put(pos, lightLevel);
            for (int l = lightLevel - 1; l > ((Boolean)LucentConfig.CLIENT.smoothBlending.get() != false ? -1 : 0); --l) {
                int lightFilter = l + 1;
                for (BlockPos currentPos : (BlockPos[])positions.entrySet().stream().filter(e -> (Integer)e.getValue() == lightFilter).map(Map.Entry::getKey).toArray(BlockPos[]::new)) {
                    for (Direction dir : Direction.values()) {
                        BlockPos relativePos = currentPos.relative(dir);
                        if (positions.containsKey(relativePos) || !DynamicLightingEngine.canLightPass(currentPos, relativePos, dir) || !DynamicLightingEngine.addLightSource(newLightData, relativePos, l, sourcePos)) continue;
                        positions.put(relativePos, l);
                    }
                }
            }
        }
    }

    private static boolean addLightSource(Map<BlockPos, LightData> newLightData, BlockPos pos, int lightLevel, LightData.SourcePos sourcePos) {
        LightData oldData = newLightData.get(pos);
        if (oldData != null && oldData.shouldStay) {
            if (((Boolean)LucentConfig.CLIENT.smoothBlending.get()).booleanValue()) {
                if (oldData.lightLevel > lightLevel + 1) {
                    return false;
                }
                if (lightLevel > oldData.lightLevel) {
                    oldData.lightLevel = lightLevel;
                }
                oldData.sourcePoses.add(sourcePos);
                return true;
            }
            if (lightLevel > oldData.lightLevel) {
                newLightData.put(pos, new LightData(lightLevel, sourcePos));
                forcedLightData.remove(pos);
                return true;
            }
        } else {
            newLightData.put(pos, new LightData(lightLevel, sourcePos));
            forcedLightData.remove(pos);
            return true;
        }
        return false;
    }

    private static float calcDist(double x1, double y1, double z1, double x2, double y2, double z2) {
        return (float)(Math.abs(x1 - x2) + Math.abs(y1 - y2) + Math.abs(z1 - z2));
    }

    private static int calcDist(int x1, int y1, int z1, int x2, int y2, int z2) {
        return Math.abs(x1 - x2) + Math.abs(y1 - y2) + Math.abs(z1 - z2);
    }

    private static VoxelShape getShape(BlockState state, BlockPos pos, Direction dir) {
        Level level = DynamicLightingEngine.level();
        return state.getLightBlock((BlockGetter)level, pos) < 15 && !state.canOcclude() || !state.isSolid() ? Shapes.empty() : state.getFaceOcclusionShape((BlockGetter)level, pos, dir);
    }

    private static boolean canLightPass(BlockPos currentPos, BlockPos relativePos, Direction dir) {
        Level level = DynamicLightingEngine.level();
        return !Shapes.faceShapeOccludes((VoxelShape)DynamicLightingEngine.getShape(level.getBlockState(currentPos), currentPos, dir), (VoxelShape)DynamicLightingEngine.getShape(level.getBlockState(relativePos), relativePos, dir.getOpposite()));
    }

    private static void setDirty(SectionPos sectionPos) {
        if (LucentClient.pluginManager().post(p -> p.markSectionDirty(sectionPos))) {
            return;
        }
        LucentClient.scheduleSetDirty(sectionPos);
    }

    public static void clearAllData() {
        lightData.clear();
        forcedLightData.clear();
        sectionsToUpdate.clear();
        lightData = new HashMap<BlockPos, LightData>();
        forcedLightData = new HashMap<BlockPos, LightData>();
        sectionsToUpdate = new HashSet<SectionPos>();
    }

    static {
        deepDarkTransition = deepDarkTransitionTime = 20;
        deepDarkScale = 0.0f;
    }
}

