/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lucent.core.plugin;

import com.legacy.lucent.api.EntityBrightnessMap;
import com.legacy.lucent.api.VecTransformer;
import com.legacy.lucent.api.data.objects.ItemLighting;
import com.legacy.lucent.api.plugin.ILucentPlugin;
import com.legacy.lucent.api.plugin.LucentPlugin;
import com.legacy.lucent.api.registry.ItemLightingRegistry;
import com.legacy.lucent.core.LucentConfig;
import com.legacy.lucent.core.LucentMod;
import com.legacy.lucent.core.compat.create.IContraptionEntityInfo;
import com.legacy.lucent.core.reflection.ReflectedClass;
import com.legacy.lucent.core.reflection.ReflectedField;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.ModConfigSpec;

@OnlyIn(value=Dist.CLIENT)
@LucentPlugin
public class CreatePlugin
implements ILucentPlugin {
    public static final ReflectedClass ORIENTED_CONTRAPTION = ReflectedClass.of("com.simibubi.create.content.contraptions.OrientedContraptionEntity");
    public static final ReflectedClass CONTROLLED_CONTRAPTION = ReflectedClass.of("com.simibubi.create.content.contraptions.ControlledContraptionEntity");
    public static final ReflectedField<Float> ORIENTED_CONTRAPTION_YAW = ReflectedField.of(ORIENTED_CONTRAPTION, "yaw", Float.class, () -> Float.valueOf(0.0f));
    public static final ReflectedField<Float> ORIENTED_CONTRAPTION_PITCH = ReflectedField.of(ORIENTED_CONTRAPTION, "pitch", Float.class, () -> Float.valueOf(0.0f));
    public static final ReflectedField<Direction.Axis> CONTROLLED_CONTRAPTION_AXIS = ReflectedField.of(CONTROLLED_CONTRAPTION, "rotationAxis", Direction.Axis.class, () -> Direction.Axis.Y);
    public static final ReflectedField<Float> CONTROLLED_CONTRAPTION_ANGLE = ReflectedField.of(CONTROLLED_CONTRAPTION, "angle", Float.class, () -> Float.valueOf(0.0f));

    @Override
    public void registerItemLightings(ItemLightingRegistry registry) {
        if (!LucentConfig.CLIENT.createPlugin.map(ModConfigSpec.ConfigValue::get).orElse(false).booleanValue()) {
            return;
        }
        registry.register(ItemLighting.builder().item(this.locate("blaze_burner")).light(7));
    }

    @Override
    public void getAdditionalEntityLightLevels(EntityBrightnessMap map) {
        if (!LucentConfig.CLIENT.createPlugin.map(ModConfigSpec.ConfigValue::get).orElse(false).booleanValue()) {
            return;
        }
        try {
            Entity entity = map.getEntity();
            CreatePlugin.storePackedData(entity);
            CreatePlugin.addLighting(map, entity);
        }
        catch (ReportedException entity) {
        }
        catch (Throwable t) {
            LucentMod.LOGGER.error(t, new Object[0]);
            LucentMod.LOGGER.printStacktrace("Encountered an error with Create. You can disable Create compat in the config to prevent further errors.", t);
        }
    }

    private static void storePackedData(Entity entity) {
        IContraptionEntityInfo contraption;
        if (entity instanceof IContraptionEntityInfo && (contraption = (IContraptionEntityInfo)entity).lucent$shouldAttemptRead()) {
            contraption.lucent$incrementReadAttempt();
            Data data = CreatePlugin.readStaticData(entity.saveWithoutId(new CompoundTag()));
            if (data != Data.INVALID) {
                contraption.lucent$setLightData(data);
            }
        }
    }

    private static void addLighting(EntityBrightnessMap map, Entity entity) {
        IContraptionEntityInfo contraption;
        Data data;
        if (entity instanceof IContraptionEntityInfo && (data = (contraption = (IContraptionEntityInfo)entity).lucent$getLightData()) != null) {
            for (Pair<BlockPos, Integer> pair : data.lights) {
                VecTransformer pos = CreatePlugin.getEmissionPos((BlockPos)pair.getFirst(), contraption);
                if (pos == null) continue;
                map.add(pos, (Integer)pair.getSecond());
            }
        }
    }

    public static VecTransformer getEmissionPos(BlockPos pos, IContraptionEntityInfo contraption) {
        Vec3 posVec = new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        if (CONTROLLED_CONTRAPTION.isInstance(contraption)) {
            Direction.Axis axis = CONTROLLED_CONTRAPTION_AXIS.get(contraption);
            return new VecTransformer.Rotated(posVec, CONTROLLED_CONTRAPTION_ANGLE.get(contraption).floatValue(), axis == null ? Direction.Axis.Y : axis);
        }
        if (ORIENTED_CONTRAPTION.isInstance(contraption) && !contraption.lucent$getLightData().type.equals("stabilized")) {
            return new VecTransformer.PitchAndYaw(VecTransformer.rotateVec(posVec, contraption.lucent$getLightData().initOrientation().toYRot(), Direction.Axis.Y), ORIENTED_CONTRAPTION_PITCH.get(contraption).floatValue(), -ORIENTED_CONTRAPTION_YAW.get(contraption).floatValue(), Direction.Axis.Z);
        }
        return new VecTransformer.Relative(posVec);
    }

    private static Data readStaticData(CompoundTag tag) {
        CompoundTag blocks;
        CompoundTag contraption;
        ArrayList<String> missingTags = new ArrayList<String>();
        if (CreatePlugin.contains(tag, "Contraption", (byte)10, missingTags) && CreatePlugin.contains(contraption = tag.getCompound("Contraption"), "Blocks", (byte)10, missingTags) && CreatePlugin.contains(blocks = contraption.getCompound("Blocks"), "Palette", (byte)9, missingTags) && CreatePlugin.contains(blocks, "BlockList", (byte)9, missingTags)) {
            ListTag palette = blocks.getList("Palette", 10);
            HashMap<Integer, BlockState> states = new HashMap<Integer, BlockState>();
            for (int i = 0; i < palette.size(); ++i) {
                Iterator name;
                Block block;
                CompoundTag c;
                Tag tag2 = palette.get(i);
                if (!(tag2 instanceof CompoundTag) || !CreatePlugin.contains(c = (CompoundTag)tag2, "Name", (byte)8, missingTags) || (block = (Block)BuiltInRegistries.BLOCK.get((ResourceLocation)(name = new ResourceLocation(c.getString("Name"))))) == null) continue;
                BlockState state = block.defaultBlockState();
                Map<String, Property> propertiesMap = state.getProperties().stream().collect(Collectors.toMap(p -> p.getName(), p -> p));
                if (CreatePlugin.contains(c, "Properties", (byte)10, missingTags)) {
                    CompoundTag properties = c.getCompound("Properties");
                    for (String k : properties.getAllKeys()) {
                        String v;
                        Optional opVal;
                        Property prop = propertiesMap.get(k);
                        if (prop == null || !state.hasProperty(prop) || !(opVal = prop.getValue(v = properties.getString(k))).isPresent()) continue;
                        state = (BlockState)state.setValue(prop, (Comparable)opVal.get());
                    }
                }
                states.put(i, state);
            }
            ListTag blockList = blocks.getList("BlockList", 10);
            ArrayList<Pair> statesByPos = new ArrayList<Pair>();
            for (Tag blockInfo : blockList) {
                int stateID;
                BlockState state;
                CompoundTag c;
                if (!(blockInfo instanceof CompoundTag) || !CreatePlugin.contains(c = (CompoundTag)blockInfo, "Pos", (byte)4, missingTags) || !CreatePlugin.contains(c, "State", (byte)3, missingTags) || (state = (BlockState)states.get(stateID = c.getInt("State"))) == null) continue;
                BlockPos pos = BlockPos.of((long)c.getLong("Pos"));
                statesByPos.add(Pair.of((Object)pos, (Object)state));
            }
            String type = "";
            if (CreatePlugin.contains(contraption, "Type", (byte)8, missingTags)) {
                type = contraption.getString("Type");
            }
            Direction initialOrientation = null;
            if (CreatePlugin.contains(tag, "InitialOrientation", (byte)8, missingTags)) {
                initialOrientation = Direction.byName((String)tag.getString("InitialOrientation").toLowerCase(Locale.ENGLISH));
            }
            if (initialOrientation == null) {
                initialOrientation = Direction.NORTH;
            }
            ArrayList<Pair<BlockPos, Integer>> lights = new ArrayList<Pair<BlockPos, Integer>>();
            for (Pair stateAndPos : statesByPos) {
                int l = ((BlockState)stateAndPos.getSecond()).getLightEmission();
                if (l <= 0) continue;
                lights.add((Pair<BlockPos, Integer>)Pair.of((Object)((BlockPos)stateAndPos.getFirst()), (Object)l));
            }
            return new Data(lights, type, initialOrientation);
        }
        if (!missingTags.isEmpty()) {
            LucentMod.LOGGER.error("Could not read nbt tags from a Create contraption. They may have moved or are missing.", String.join((CharSequence)", ", missingTags));
        }
        return Data.INVALID;
    }

    private static boolean contains(CompoundTag tag, String key, byte type, List<String> missing) {
        if (tag.contains(key, (int)type)) {
            return true;
        }
        missing.add(key + "=" + missing);
        return false;
    }

    @Override
    public String ownerModID() {
        return "create";
    }

    @Override
    public boolean isInternal() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return LucentConfig.CLIENT.createPlugin.map(ModConfigSpec.ConfigValue::get).orElse(false);
    }

    public record Data(List<Pair<BlockPos, Integer>> lights, String type, Direction initOrientation) {
        private static final Data INVALID = new Data(Collections.emptyList(), "", Direction.NORTH);
    }
}

