/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lucent.core.plugin;

import com.legacy.lucent.api.EntityBrightness;
import com.legacy.lucent.api.EntityBrightnessMap;
import com.legacy.lucent.api.data.objects.EmissiveArmorTrimTexture;
import com.legacy.lucent.api.data.objects.EntityLighting;
import com.legacy.lucent.api.data.objects.ItemLighting;
import com.legacy.lucent.api.plugin.ILucentPlugin;
import com.legacy.lucent.api.plugin.LucentPlugin;
import com.legacy.lucent.api.registry.ArmorTrimLightingRegistry;
import com.legacy.lucent.api.registry.BlockTextureLightingRegistry;
import com.legacy.lucent.api.registry.EntityLightSourcePosRegistry;
import com.legacy.lucent.api.registry.EntityLightingRegistry;
import com.legacy.lucent.api.registry.ItemLightingRegistry;
import com.legacy.lucent.core.LucentClient;
import com.legacy.lucent.core.LucentConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@LucentPlugin
public final class InternalLucentPlugin
implements ILucentPlugin {
    @Override
    public void registerItemLightings(ItemLightingRegistry registry) {
        if (((Boolean)LucentConfig.CLIENT.vanillaDynamicLighting.get()).booleanValue()) {
            registry.register(Items.BLAZE_ROD, 11);
            registry.register(Items.NETHER_STAR, 15);
            registry.register(Items.PRISMARINE_CRYSTALS, 9);
            registry.register(Items.SPECTRAL_ARROW, 5);
            registry.register(Items.GLOWSTONE_DUST, 10);
            registry.register(Items.GLOW_BERRIES, 9);
            registry.register(Items.GLOW_INK_SAC, 5);
            registry.register(Items.GLOW_ITEM_FRAME, 2);
            registry.register(Items.GLOW_LICHEN, 7);
            registry.register(ItemLighting.builder().item(Items.LIGHT).light(stack -> {
                CompoundTag stateTag = stack.getTagElement("BlockStateTag");
                try {
                    Tag tag;
                    if (stateTag != null && (tag = stateTag.get(LightBlock.LEVEL.getName())) != null) {
                        return Integer.parseInt(tag.getAsString());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return 15;
            }));
            if (((Boolean)LucentConfig.CLIENT.torchesDoNothingInWater.get()).booleanValue()) {
                for (Item i : BuiltInRegistries.ITEM) {
                    Block b;
                    int l;
                    if (!(i instanceof BlockItem) || (l = (b = ((BlockItem)i).getBlock()).defaultBlockState().getLightEmission()) <= 0 || !(b instanceof TorchBlock) && !(b instanceof CampfireBlock) && !(b instanceof CarvedPumpkinBlock) && !(b instanceof FireBlock)) continue;
                    registry.register(ItemLighting.builder().item(i).light(l).worksUnderwater(false));
                }
            }
        }
    }

    @Override
    public void registerEntityLightings(EntityLightingRegistry registry) {
        if (((Boolean)LucentConfig.CLIENT.vanillaDynamicLighting.get()).booleanValue()) {
            registry.register(EntityType.BLAZE, 9);
            registry.register(EntityType.SPECTRAL_ARROW, 5);
            registry.register(EntityType.DRAGON_FIREBALL, 11);
            registry.register(EntityLighting.builder().entity(EntityType.ITEM).light(itemEntity -> (Boolean)LucentConfig.CLIENT.itemEntitiesGlow.get() != false ? ItemLightingRegistry.get(itemEntity.getItem()) : 0));
            registry.register(EntityLighting.builder().entity(EntityType.MAGMA_CUBE).light(magmaCube -> (magmaCube.getSize() + 1) * 2));
            registry.register(EntityLighting.builder().entity(EntityType.GLOW_SQUID).light(glowSquid -> (int)Mth.clampedLerp((float)0.0f, (float)7.0f, (float)(1.0f - (float)glowSquid.getDarkTicksRemaining() / 10.0f))));
            registry.register(EntityLighting.builder().entity(EntityType.CREEPER).light(creeper -> (Boolean)LucentConfig.CLIENT.creepersGlow.get() != false ? (int)(10.0f * creeper.getSwelling(0.0f)) : 0));
            registry.register(EntityLighting.builder().entity(EntityType.FALLING_BLOCK).light(fallingBlock -> fallingBlock.getBlockState().getLightEmission()));
            registry.register(EntityLighting.builder().entity(EntityType.BLOCK_DISPLAY).light(display -> display.blockRenderState().blockState().getLightEmission()));
            registry.register(EntityLighting.builder().entity(EntityType.ITEM_DISPLAY).light(display -> ItemLightingRegistry.get(display.itemRenderState().itemStack())));
        }
    }

    @Override
    public void registerBlockTextureLightings(BlockTextureLightingRegistry registery) {
        int soulLight = 14;
        registery.register("block/end_portal_frame_eye", 12);
        registery.register("block/soul_lantern", soulLight);
        registery.register("block/soul_campfire_fire", soulLight);
        registery.register("block/soul_fire_0", soulLight);
        registery.register("block/soul_fire_1", soulLight);
        registery.register("block/soul_torch", soulLight);
    }

    @Override
    public void registerEntityLightSourcePositionGetter(EntityLightSourcePosRegistry registry) {
        registry.register(EntityType.ARROW, Entity::position);
        registry.register(EntityType.SPECTRAL_ARROW, Entity::position);
    }

    @Override
    public void getEntityLightLevel(EntityBrightness entityBrightness) {
        Entity entity = entityBrightness.getEntity();
        if (entity.isSpectator()) {
            return;
        }
        entityBrightness.setLightLevel(EntityLightingRegistry.get(entity));
        if (((Boolean)LucentConfig.CLIENT.vanillaDynamicLighting.get()).booleanValue()) {
            if (((Boolean)LucentConfig.CLIENT.burningEntitiesGlow.get()).booleanValue() && entity.isOnFire()) {
                entityBrightness.setLightLevel((Integer)LucentConfig.CLIENT.burningEntityLightLevel.get());
            }
            if (((Boolean)LucentConfig.CLIENT.glowingEntitiesGlow.get()).booleanValue() && entity.isCurrentlyGlowing()) {
                entityBrightness.setLightLevel((Integer)LucentConfig.CLIENT.glowingEntityLightLevel.get());
            }
        }
        if (((Boolean)LucentConfig.CLIENT.heldItemsGlow.get()).booleanValue()) {
            ArrayList equipped = new ArrayList(6);
            LucentClient.pluginManager().forEach(plugin -> equipped.addAll(plugin.gatherEquippedItems(entity)));
            int light = 0;
            for (ItemStack stack : equipped) {
                light = Math.max(light, ItemLightingRegistry.get(stack));
            }
            if (light > 0) {
                entityBrightness.setLightLevel(light);
            }
        }
    }

    @Override
    public List<ItemStack> gatherEquippedItems(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ArrayList<ItemStack> items = new ArrayList<ItemStack>(6);
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                items.add(livingEntity.getItemBySlot(slot));
            }
            return items;
        }
        if (entity instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entity;
            if (((Boolean)LucentConfig.CLIENT.itemFramesGlow.get()).booleanValue()) {
                return List.of(itemFrame.getItem());
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void getAdditionalEntityLightLevels(EntityBrightnessMap map) {
    }

    @Override
    public void registerArmorTrimTextureLightings(ArmorTrimLightingRegistry registry) {
        registry.register(new EmissiveArmorTrimTexture((ResourceKey<TrimMaterial>)TrimMaterials.AMETHYST, 5));
    }

    @Override
    public String ownerModID() {
        return "lucent";
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }
}

