/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.enchdesc;

import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.enchdesc.ConfigSchema;
import net.darkhax.enchdesc.DescriptionManager;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.apache.commons.lang3.StringUtils;

public class EnchDescCommon {
    private final ConfigSchema config;

    public EnchDescCommon(Path configPath) {
        this.config = ConfigSchema.load(configPath.resolve("enchdesc.json").toFile());
        Services.EVENTS.addItemTooltipListener(this::onItemTooltip);
    }

    private void onItemTooltip(ItemStack stack, List<Component> tooltip, TooltipFlag tooltipFlag) {
        Set enchantments;
        if (this.config.enableMod && !stack.isEmpty() && stack.hasTag() && (!this.config.onlyDisplayOnBooks && stack.isEnchanted() || stack.getItem() instanceof EnchantedBookItem) && (!this.config.onlyDisplayInEnchantingTable || Minecraft.getInstance().screen instanceof EnchantmentScreen) && !(enchantments = EnchantmentHelper.getEnchantments((ItemStack)stack).keySet()).isEmpty()) {
            if (!this.config.requireKeybindPress || Screen.hasShiftDown()) {
                block0: for (Enchantment enchantment : enchantments) {
                    for (Component line : tooltip) {
                        TranslatableContents translatable;
                        ComponentContents componentContents = line.getContents();
                        if (!(componentContents instanceof TranslatableContents) || !(translatable = (TranslatableContents)componentContents).getKey().equals(enchantment.getDescriptionId())) continue;
                        MutableComponent descriptionText = DescriptionManager.getDescription(enchantment);
                        if (this.config.indentSize > 0) {
                            descriptionText = Component.literal((String)StringUtils.repeat((char)' ', (int)this.config.indentSize)).append((Component)descriptionText);
                        }
                        tooltip.add(tooltip.indexOf(line) + 1, (Component)descriptionText);
                        continue block0;
                    }
                }
            } else {
                tooltip.add((Component)Component.translatable((String)"enchdesc.activate.message").withStyle(ChatFormatting.DARK_GRAY));
            }
        }
    }
}

