/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import noobanidus.mods.lootr.command.CommandLootr;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.init.ModAdvancements;
import noobanidus.mods.lootr.init.ModBlockEntities;
import noobanidus.mods.lootr.init.ModBlocks;
import noobanidus.mods.lootr.init.ModEntities;
import noobanidus.mods.lootr.init.ModItems;
import noobanidus.mods.lootr.init.ModLoot;
import noobanidus.mods.lootr.init.ModStats;
import noobanidus.mods.lootr.init.ModTabs;
import noobanidus.mods.lootr.network.PacketHandler;

@Mod(value="lootr")
public class Lootr {
    public static final String VERSION = "0.8";
    public static Lootr instance;
    private final PacketHandler packetHandler;
    public CommandLootr COMMAND_LOOTR;
    public CreativeModeTab TAB;

    public Lootr(ModContainer modContainer, IEventBus modBus) {
        instance = this;
        ModLoadingContext context = ModLoadingContext.get();
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigManager.COMMON_CONFIG);
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigManager.CLIENT_CONFIG);
        ConfigManager.loadConfig(ConfigManager.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("lootr-common.toml"));
        if ((Integer)ConfigManager.MAXIMUM_AGE.get() == 6000) {
            ConfigManager.MAXIMUM_AGE.set((Object)18000);
            ConfigManager.COMMON_CONFIG.save();
        }
        ConfigManager.loadConfig(ConfigManager.CLIENT_CONFIG, FMLPaths.CONFIGDIR.get().resolve("lootr-client.toml"));
        NeoForge.EVENT_BUS.addListener(this::onCommands);
        ModTabs.register(modBus);
        ModBlockEntities.register(modBus);
        ModBlocks.register(modBus);
        ModEntities.register(modBus);
        ModItems.register(modBus);
        ModLoot.register(modBus);
        ModStats.register(modBus);
        ModAdvancements.register(modBus);
        this.packetHandler = new PacketHandler(modBus, "lootr", VERSION);
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation("lootr", path);
    }

    public static PacketHandler getPacketHandler() {
        return Lootr.instance.packetHandler;
    }

    public void onCommands(RegisterCommandsEvent event) {
        this.COMMAND_LOOTR = new CommandLootr((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        this.COMMAND_LOOTR.register();
    }
}

