/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.block.entities;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;
import noobanidus.mods.lootr.api.LootrAPI;
import noobanidus.mods.lootr.api.blockentity.ILootBlockEntity;
import noobanidus.mods.lootr.block.LootrBarrelBlock;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.data.SpecialChestInventory;
import noobanidus.mods.lootr.init.ModBlockEntities;
import noobanidus.mods.lootr.util.ChestUtil;
import noobanidus.mods.lootr.util.Getter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LootrBarrelBlockEntity
extends RandomizableContainerBlockEntity
implements ILootBlockEntity {
    public Set<UUID> openers = new HashSet<UUID>();
    protected ResourceLocation savedLootTable = null;
    protected long seed = -1L;
    protected UUID tileId = null;
    protected boolean opened = false;
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level leve, BlockPos pos, BlockState state) {
            LootrBarrelBlockEntity.this.playSound(state, SoundEvents.BARREL_OPEN);
            LootrBarrelBlockEntity.this.updateBlockState(state, true);
        }

        protected void onClose(Level level, BlockPos pos, BlockState state) {
            LootrBarrelBlockEntity.this.playSound(state, SoundEvents.BARREL_CLOSE);
            LootrBarrelBlockEntity.this.updateBlockState(state, false);
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int p_155069_, int p_155070_) {
        }

        protected boolean isOwnContainer(Player player) {
            Container container;
            if (player.containerMenu instanceof ChestMenu && (container = ((ChestMenu)player.containerMenu).getContainer()) instanceof SpecialChestInventory) {
                SpecialChestInventory data = (SpecialChestInventory)container;
                if (data.getTileId() == null) {
                    return data.getBlockEntity(LootrBarrelBlockEntity.this.getLevel()) == LootrBarrelBlockEntity.this;
                }
                return data.getTileId().equals(LootrBarrelBlockEntity.this.getTileId());
            }
            return false;
        }
    };
    private ModelData modelData = null;
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
    private boolean savingToItem = false;

    public LootrBarrelBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.LOOTR_BARREL.get(), pWorldPosition, pBlockState);
    }

    @NotNull
    public ModelData getModelData() {
        Player player;
        if (this.modelData == null) {
            this.modelData = ModelData.builder().with(LootrBarrelBlock.OPENED, (Object)false).build();
        }
        if ((player = Getter.getPlayer()) != null) {
            return this.modelData.derive().with(LootrBarrelBlock.OPENED, (Object)this.openers.contains(player.getUUID())).build();
        }
        return this.modelData;
    }

    @Override
    public UUID getTileId() {
        if (this.tileId == null) {
            this.tileId = UUID.randomUUID();
        }
        return this.tileId;
    }

    public void setLootTable(ResourceLocation lootTableIn, long seedIn) {
        this.savedLootTable = lootTableIn;
        this.seed = seedIn;
        super.setLootTable(lootTableIn, seedIn);
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> pItems) {
    }

    public void unpackLootTable(@Nullable Player player) {
    }

    @Override
    public void unpackLootTable(Player player, Container inventory, @Nullable ResourceLocation overrideTable, long seed) {
        if (this.level != null && this.savedLootTable != null && this.level.getServer() != null) {
            LootTable loottable = this.level.getServer().getLootData().getLootTable(overrideTable != null ? overrideTable : this.savedLootTable);
            if (loottable == LootTable.EMPTY) {
                LootrAPI.LOG.error("Unable to fill loot barrel in " + this.level.dimension().location() + " at " + this.worldPosition + " as the loot table '" + (overrideTable != null ? overrideTable : this.savedLootTable) + "' couldn't be resolved! Please search the loot table in `latest.log` to see if there are errors in loading.");
                if (((Boolean)ConfigManager.REPORT_UNRESOLVED_TABLES.get()).booleanValue()) {
                    player.displayClientMessage(ChestUtil.getInvalidTable(overrideTable != null ? overrideTable : this.savedLootTable), false);
                }
            }
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.GENERATE_LOOT.trigger((ServerPlayer)player, overrideTable != null ? overrideTable : this.lootTable);
            }
            LootParams.Builder builder = new LootParams.Builder((ServerLevel)this.level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)this.worldPosition));
            if (player != null) {
                builder.withLuck(player.getLuck()).withParameter(LootContextParams.THIS_ENTITY, (Object)player);
            }
            loottable.fill(inventory, builder.create(LootContextParamSets.CHEST), LootrAPI.getLootSeed(seed == Long.MIN_VALUE ? this.seed : seed));
        }
    }

    @Override
    public ResourceLocation getTable() {
        return this.savedLootTable;
    }

    @Override
    public BlockPos getPosition() {
        return this.getBlockPos();
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public Set<UUID> getOpeners() {
        return this.openers;
    }

    public void load(CompoundTag compound) {
        if (compound.contains("LootTable", 8)) {
            this.savedLootTable = new ResourceLocation(compound.getString("LootTable"));
            if (compound.contains("LootTableSeed", 4)) {
                this.seed = compound.getLong("LootTableSeed");
            }
            this.setLootTable(this.savedLootTable, this.seed);
        }
        if (compound.hasUUID("tileId")) {
            this.tileId = compound.getUUID("tileId");
        }
        if (this.tileId == null) {
            this.getTileId();
        }
        if (compound.contains("LootrOpeners")) {
            ListTag openers = compound.getList("LootrOpeners", 11);
            this.openers.clear();
            for (Tag item : openers) {
                this.openers.add(NbtUtils.loadUUID((Tag)item));
            }
        }
        this.requestModelDataUpdate();
        super.load(compound);
    }

    public void saveToItem(ItemStack itemstack) {
        this.savingToItem = true;
        super.saveToItem(itemstack);
        this.savingToItem = false;
    }

    protected void saveAdditional(CompoundTag compound) {
        super.saveAdditional(compound);
        if (this.savedLootTable != null) {
            compound.putString("LootTable", this.savedLootTable.toString());
        }
        if (this.seed != -1L) {
            compound.putLong("LootTableSeed", this.seed);
        }
        if (!LootrAPI.shouldDiscard() && !this.savingToItem) {
            compound.putUUID("tileId", this.getTileId());
            ListTag list = new ListTag();
            for (UUID opener : this.openers) {
                list.add((Object)NbtUtils.createUUID((UUID)opener));
            }
            compound.put("LootrOpeners", (Tag)list);
        }
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.barrel");
    }

    protected AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory) {
        return null;
    }

    public int getContainerSize() {
        return 27;
    }

    public void startOpen(Player pPlayer) {
        if (!this.remove && !pPlayer.isSpectator()) {
            this.openersCounter.incrementOpeners(pPlayer, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player pPlayer) {
        if (!this.remove && !pPlayer.isSpectator()) {
            this.openersCounter.decrementOpeners(pPlayer, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    protected void updateBlockState(BlockState pState, boolean pOpen) {
        this.level.setBlock(this.getBlockPos(), (BlockState)pState.setValue((Property)BarrelBlock.OPEN, (Comparable)Boolean.valueOf(pOpen)), 3);
    }

    protected void playSound(BlockState pState, SoundEvent pSound) {
        Vec3i vec3i = ((Direction)pState.getValue((Property)BarrelBlock.FACING)).getNormal();
        double d0 = (double)this.worldPosition.getX() + 0.5 + (double)vec3i.getX() / 2.0;
        double d1 = (double)this.worldPosition.getY() + 0.5 + (double)vec3i.getY() / 2.0;
        double d2 = (double)this.worldPosition.getZ() + 0.5 + (double)vec3i.getZ() / 2.0;
        this.level.playSound(null, d0, d1, d2, pSound, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
    }

    @Override
    public void updatePacketViaState() {
        if (this.level != null && !this.level.isClientSide) {
            BlockState state = this.level.getBlockState(this.getBlockPos());
            this.level.sendBlockUpdated(this.getBlockPos(), state, state, 8);
        }
    }

    @Override
    public void setOpened(boolean opened) {
        this.opened = opened;
    }

    @NotNull
    public CompoundTag getUpdateTag() {
        CompoundTag result = super.getUpdateTag();
        this.saveAdditional(result);
        return result;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, BlockEntity::getUpdateTag);
    }

    public void onDataPacket(@NotNull Connection net, @NotNull ClientboundBlockEntityDataPacket pkt) {
        if (pkt.getTag() != null) {
            this.load(pkt.getTag());
        }
    }
}

