/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.block.entities;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import noobanidus.mods.lootr.api.LootrAPI;
import noobanidus.mods.lootr.api.blockentity.ILootBlockEntity;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.event.HandleChunk;

@Mod.EventBusSubscriber(modid="lootr")
public class TileTicker {
    private static final Object listLock = new Object();
    private static final Object worldLock = new Object();
    private static final Set<Entry> tileEntries = new ObjectLinkedOpenHashSet();
    private static final Set<Entry> pendingEntries = new ObjectLinkedOpenHashSet();
    private static boolean tickingList = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEntry(Level level, BlockPos position) {
        if (((Boolean)ConfigManager.DISABLE.get()).booleanValue()) {
            return;
        }
        if (ServerLifecycleHooks.getCurrentServer() == null) {
            return;
        }
        ResourceKey dimension = level.dimension();
        if (ConfigManager.isDimensionBlocked((ResourceKey<Level>)dimension)) {
            return;
        }
        ChunkPos chunkPos = new ChunkPos(position);
        WorldBorder border = level.getWorldBorder();
        ObjectLinkedOpenHashSet chunks = new ObjectLinkedOpenHashSet();
        chunks.add(chunkPos);
        int oX = chunkPos.x;
        int oZ = chunkPos.z;
        chunks.add(chunkPos);
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                ChunkPos newPos = new ChunkPos(oX + x, oZ + z);
                if (((Boolean)ConfigManager.CHECK_WORLD_BORDER.get()).booleanValue() && !border.isWithinBounds(newPos)) continue;
                chunks.add(newPos);
            }
        }
        Entry newEntry = new Entry((ResourceKey<Level>)dimension, position, (Set<ChunkPos>)chunks, ServerLifecycleHooks.getCurrentServer().getTickCount());
        Object object = listLock;
        synchronized (object) {
            if (tickingList) {
                pendingEntries.add(newEntry);
            } else {
                tileEntries.add(newEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        ObjectLinkedOpenHashSet copy;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (((Boolean)ConfigManager.DISABLE.get()).booleanValue()) {
            return;
        }
        ObjectLinkedOpenHashSet toRemove = new ObjectLinkedOpenHashSet();
        Object object = listLock;
        synchronized (object) {
            tickingList = true;
            copy = new ObjectLinkedOpenHashSet(tileEntries);
            tickingList = false;
        }
        object = worldLock;
        synchronized (object) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            for (Entry entry : copy) {
                RandomizableContainerBlockEntity be;
                BlockEntity blockEntity;
                ServerLevel level;
                block28: {
                    block27: {
                        level = server.getLevel(entry.getDimension());
                        if (level == null || entry.age(server) > (long)((Integer)ConfigManager.MAXIMUM_AGE.get()).intValue() || ((Boolean)ConfigManager.CHECK_WORLD_BORDER.get()).booleanValue() && !level.getWorldBorder().isWithinBounds(entry.getPosition())) {
                            toRemove.add(entry);
                            continue;
                        }
                        if (!level.getChunkSource().hasChunk(entry.getPosition().getX() >> 4, entry.getPosition().getZ() >> 4)) continue;
                        boolean skip = false;
                        for (ChunkPos chunkPos : entry.getChunkPositions()) {
                            if (level.getChunkSource().hasChunk(chunkPos.x, chunkPos.z)) continue;
                            skip = true;
                            break;
                        }
                        Map<ResourceKey<Level>, Set<ChunkPos>> map = HandleChunk.LOADED_CHUNKS;
                        synchronized (map) {
                            Set<ChunkPos> loadedChunks = HandleChunk.LOADED_CHUNKS.get(entry.dimension);
                            if (loadedChunks != null) {
                                for (ChunkPos chunkPos : entry.getChunkPositions()) {
                                    if (loadedChunks.contains(chunkPos)) continue;
                                    skip = true;
                                    break;
                                }
                            }
                        }
                        if (skip) continue;
                        blockEntity = level.getBlockEntity(entry.getPosition());
                        if (!(blockEntity instanceof RandomizableContainerBlockEntity)) break block27;
                        be = (RandomizableContainerBlockEntity)blockEntity;
                        if (!(blockEntity instanceof ILootBlockEntity)) break block28;
                    }
                    toRemove.add(entry);
                    continue;
                }
                if (be.lootTable == null || ConfigManager.isBlacklisted(be.lootTable)) {
                    toRemove.add(entry);
                    continue;
                }
                BlockState stateAt = level.getBlockState(entry.getPosition());
                BlockState replacement = ConfigManager.replacement(stateAt);
                if (replacement == null) {
                    toRemove.add(entry);
                    continue;
                }
                ResourceLocation table = be.lootTable;
                long seed = be.lootTableSeed;
                be.lootTable = null;
                CompoundTag oldData = be.getPersistentData();
                level.destroyBlock(entry.getPosition(), false);
                level.setBlock(entry.getPosition(), replacement, 2);
                blockEntity = level.getBlockEntity(entry.getPosition());
                if (blockEntity != null) {
                    blockEntity.getPersistentData().merge(oldData);
                }
                if (blockEntity instanceof ILootBlockEntity) {
                    ((RandomizableContainerBlockEntity)blockEntity).setLootTable(table, seed);
                } else {
                    LootrAPI.LOG.error("replacement " + replacement + " is not an ILootTile " + entry.getDimension() + " at " + entry.getPosition());
                }
                toRemove.add(entry);
            }
        }
        object = listLock;
        synchronized (object) {
            tickingList = true;
            tileEntries.removeAll((Collection<?>)toRemove);
            tileEntries.addAll(pendingEntries);
            tickingList = false;
            pendingEntries.clear();
        }
    }

    public static class Entry {
        private final ResourceKey<Level> dimension;
        private final BlockPos position;
        private final Set<ChunkPos> chunks;
        private final long addedAt;

        public Entry(ResourceKey<Level> dimension, BlockPos position, Set<ChunkPos> chunks, long addedAt) {
            this.dimension = dimension;
            this.position = position;
            this.chunks = chunks;
            this.addedAt = addedAt;
        }

        public ResourceKey<Level> getDimension() {
            return this.dimension;
        }

        public BlockPos getPosition() {
            return this.position;
        }

        public Set<ChunkPos> getChunkPositions() {
            return this.chunks;
        }

        public long age(MinecraftServer server) {
            return (long)server.getTickCount() - this.addedAt;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (!this.dimension.equals(entry.dimension)) {
                return false;
            }
            return this.position.equals((Object)entry.position);
        }

        public int hashCode() {
            int result = this.dimension.hashCode();
            result = 31 * result + this.position.hashCode();
            return result;
        }
    }
}

