/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.client.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ShulkerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import noobanidus.mods.lootr.block.entities.LootrShulkerBlockEntity;
import noobanidus.mods.lootr.config.ConfigManager;

public class LootrShulkerBlockRenderer
implements BlockEntityRenderer<LootrShulkerBlockEntity> {
    public static final Material MATERIAL = new Material(Sheets.SHULKER_SHEET, new ResourceLocation("lootr", "shulker"));
    public static final Material MATERIAL2 = new Material(Sheets.SHULKER_SHEET, new ResourceLocation("lootr", "shulker_opened"));
    public static final Material MATERIAL3 = new Material(Sheets.SHULKER_SHEET, new ResourceLocation("lootr", "old_shulker"));
    public static final Material MATERIAL4 = new Material(Sheets.SHULKER_SHEET, new ResourceLocation("lootr", "old_shulker_opened"));
    private final ShulkerModel<?> model;
    private UUID playerId;

    public LootrShulkerBlockRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new ShulkerModel(context.bakeLayer(ModelLayers.SHULKER));
    }

    protected Material getMaterial(LootrShulkerBlockEntity tile) {
        if (ConfigManager.isVanillaTextures()) {
            return Sheets.DEFAULT_SHULKER_TEXTURE_LOCATION;
        }
        if (this.playerId == null) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null) {
                return ConfigManager.isOldTextures() ? MATERIAL3 : MATERIAL;
            }
            this.playerId = mc.player.getUUID();
        }
        if (tile.getOpeners().contains(this.playerId)) {
            return ConfigManager.isOldTextures() ? MATERIAL4 : MATERIAL2;
        }
        return ConfigManager.isOldTextures() ? MATERIAL3 : MATERIAL;
    }

    public void render(LootrShulkerBlockEntity pBlockEntity, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pCombinedLight, int pCombinedOverlay) {
        BlockState blockstate;
        Direction direction = Direction.UP;
        if (pBlockEntity.hasLevel() && (blockstate = pBlockEntity.getLevel().getBlockState(pBlockEntity.getBlockPos())).getBlock() instanceof ShulkerBoxBlock) {
            direction = (Direction)blockstate.getValue((Property)ShulkerBoxBlock.FACING);
        }
        Material material = this.getMaterial(pBlockEntity);
        pMatrixStack.pushPose();
        pMatrixStack.translate(0.5, 0.5, 0.5);
        pMatrixStack.scale(0.9995f, 0.9995f, 0.9995f);
        pMatrixStack.mulPose(direction.getRotation());
        pMatrixStack.scale(1.0f, -1.0f, -1.0f);
        pMatrixStack.translate(0.0, -1.0, 0.0);
        ModelPart modelpart = this.model.getLid();
        modelpart.setPos(0.0f, 24.0f - pBlockEntity.getProgress(pPartialTicks) * 0.5f * 16.0f, 0.0f);
        modelpart.yRot = 270.0f * pBlockEntity.getProgress(pPartialTicks) * ((float)Math.PI / 180);
        VertexConsumer vertexconsumer = material.buffer(pBuffer, RenderType::entityCutoutNoCull);
        this.model.renderToBuffer(pMatrixStack, vertexconsumer, pCombinedLight, pCombinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        pMatrixStack.popPose();
    }
}

