/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.command;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import noobanidus.mods.lootr.api.blockentity.ILootBlockEntity;
import noobanidus.mods.lootr.block.LootrBarrelBlock;
import noobanidus.mods.lootr.block.LootrChestBlock;
import noobanidus.mods.lootr.block.LootrInventoryBlock;
import noobanidus.mods.lootr.block.LootrShulkerBlock;
import noobanidus.mods.lootr.block.entities.LootrInventoryBlockEntity;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.data.DataStorage;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;
import noobanidus.mods.lootr.init.ModBlocks;
import noobanidus.mods.lootr.util.ChestUtil;
import org.jetbrains.annotations.Nullable;

public class CommandLootr {
    private static final Map<String, UUID> profileMap = new HashMap<String, UUID>();
    private static List<ResourceLocation> tables = null;
    private static List<String> tableNames = null;
    private final CommandDispatcher<CommandSourceStack> dispatcher;

    public CommandLootr(CommandDispatcher<CommandSourceStack> dispatcher) {
        this.dispatcher = dispatcher;
    }

    private static List<ResourceLocation> getTables() {
        if (tables == null) {
            tables = new ArrayList<ResourceLocation>(BuiltInLootTables.all());
            tableNames = tables.stream().map(ResourceLocation::toString).collect(Collectors.toList());
        }
        return tables;
    }

    private static List<String> getProfiles() {
        return Lists.newArrayList(ServerLifecycleHooks.getCurrentServer().getProfileCache().profilesByName.keySet());
    }

    private static List<String> getTableNames() {
        CommandLootr.getTables();
        return tableNames;
    }

    public static void createBlock(CommandSourceStack c, @Nullable Block block, @Nullable ResourceLocation incomingTable) {
        ServerLevel world = c.getLevel();
        Vec3 incomingPos = c.getPosition();
        BlockPos pos = new BlockPos((int)incomingPos.x, (int)incomingPos.y, (int)incomingPos.z);
        ResourceLocation table = incomingTable == null ? CommandLootr.getTables().get(world.getRandom().nextInt(CommandLootr.getTables().size())) : incomingTable;
        if (block == null) {
            LootrChestMinecartEntity cart = new LootrChestMinecartEntity((Level)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
            Entity e = c.getEntity();
            if (e != null) {
                cart.setYRot(e.getYRot());
            }
            cart.setLootTable(table, world.getRandom().nextLong());
            world.addFreshEntity((Entity)cart);
            c.sendSuccess(() -> Component.translatable((String)"lootr.commands.summon", (Object[])new Object[]{ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)"lootr.commands.blockpos", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}).setStyle(Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GREEN)).withBold(Boolean.valueOf(true)))), table.toString()}), false);
        } else {
            BlockState placementState = block.defaultBlockState();
            Entity e = c.getEntity();
            if (e != null) {
                DirectionProperty prop = null;
                Direction dir = Direction.orderedByNearest((Entity)e)[0].getOpposite();
                if (placementState.hasProperty((Property)LootrBarrelBlock.FACING)) {
                    prop = LootrBarrelBlock.FACING;
                } else if (placementState.hasProperty((Property)LootrChestBlock.FACING)) {
                    prop = LootrChestBlock.FACING;
                    dir = e.getDirection().getOpposite();
                } else if (placementState.hasProperty((Property)LootrShulkerBlock.FACING)) {
                    prop = LootrShulkerBlock.FACING;
                }
                if (prop != null) {
                    placementState = (BlockState)placementState.setValue((Property)prop, (Comparable)dir);
                }
            }
            world.setBlock(pos, placementState, 2);
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof RandomizableContainerBlockEntity) {
                RandomizableContainerBlockEntity randomizableBe = (RandomizableContainerBlockEntity)blockEntity;
                randomizableBe.setLootTable(table, world.getRandom().nextLong());
            }
            c.sendSuccess(() -> Component.translatable((String)"lootr.commands.create", (Object[])new Object[]{Component.translatable((String)block.getDescriptionId()), ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)"lootr.commands.blockpos", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}).setStyle(Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GREEN)).withBold(Boolean.valueOf(true)))), table.toString()}), false);
        }
    }

    public CommandLootr register() {
        this.dispatcher.register(this.builder((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)Commands.literal((String)"lootr").requires(p -> p.hasPermission(2)))));
        return this;
    }

    private RequiredArgumentBuilder<CommandSourceStack, ResourceLocation> suggestTables() {
        return Commands.argument((String)"table", (ArgumentType)ResourceLocationArgument.id()).suggests((c, build) -> SharedSuggestionProvider.suggest(CommandLootr.getTableNames(), (SuggestionsBuilder)build));
    }

    private RequiredArgumentBuilder<CommandSourceStack, String> suggestProfiles() {
        return Commands.argument((String)"profile", (ArgumentType)StringArgumentType.string()).suggests((c, build) -> SharedSuggestionProvider.suggest(CommandLootr.getProfiles(), (SuggestionsBuilder)build));
    }

    public LiteralArgumentBuilder<CommandSourceStack> builder(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.translatable((String)"lootr.commands.usage"), false);
            return 1;
        });
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"barrel").executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), (Block)ModBlocks.BARREL.get(), null);
            return 1;
        })).then(this.suggestTables().executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), (Block)ModBlocks.BARREL.get(), ResourceLocationArgument.getId((CommandContext)c, (String)"table"));
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"trapped_chest").executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), (Block)ModBlocks.TRAPPED_CHEST.get(), null);
            return 1;
        })).then(this.suggestTables().executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), (Block)ModBlocks.TRAPPED_CHEST.get(), ResourceLocationArgument.getId((CommandContext)c, (String)"table"));
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"chest").executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), (Block)ModBlocks.CHEST.get(), null);
            return 1;
        })).then(this.suggestTables().executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), (Block)ModBlocks.CHEST.get(), ResourceLocationArgument.getId((CommandContext)c, (String)"table"));
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"shulker").executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), (Block)ModBlocks.SHULKER.get(), null);
            return 1;
        })).then(this.suggestTables().executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), (Block)ModBlocks.SHULKER.get(), ResourceLocationArgument.getId((CommandContext)c, (String)"table"));
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"clear").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Must provide player name."), true);
            return 1;
        })).then(this.suggestProfiles().executes(c -> {
            String playerName = StringArgumentType.getString((CommandContext)c, (String)"profile");
            Optional opt_profile = ((CommandSourceStack)c.getSource()).getServer().getProfileCache().get(playerName);
            if (!opt_profile.isPresent()) {
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Invalid player name: " + playerName + ", profile not found in the cache.")));
                return 0;
            }
            GameProfile profile = (GameProfile)opt_profile.get();
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)(DataStorage.clearInventories(profile.getId()) ? "Cleared stored inventories for " + playerName : "No stored inventories for " + playerName + " to clear")), true);
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"cart").executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), null, null);
            return 1;
        })).then(this.suggestTables().executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), null, ResourceLocationArgument.getId((CommandContext)c, (String)"table"));
            return 1;
        })));
        builder.then(Commands.literal((String)"custom").executes(c -> {
            BlockPos pos = BlockPos.containing((Position)((CommandSourceStack)c.getSource()).getPosition());
            ServerLevel world = ((CommandSourceStack)c.getSource()).getLevel();
            BlockState state = world.getBlockState(pos);
            if (!state.is(Blocks.CHEST) && !state.is(Blocks.BARREL)) {
                pos = pos.below();
                state = world.getBlockState(pos);
            }
            if (!state.is(Blocks.CHEST) && !state.is(Blocks.BARREL)) {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Please stand on the chest or barrel you wish to convert."), false);
            } else {
                BlockState newState;
                NonNullList reference;
                if (state.is(Blocks.CHEST)) {
                    reference = ((ChestBlockEntity)Objects.requireNonNull(world.getBlockEntity((BlockPos)pos))).items;
                    newState = (BlockState)((BlockState)((LootrInventoryBlock)((Object)((Object)ModBlocks.INVENTORY.get()))).defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)((Direction)state.getValue((Property)ChestBlock.FACING)))).setValue((Property)ChestBlock.WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)ChestBlock.WATERLOGGED)));
                } else {
                    Direction facing = (Direction)state.getValue((Property)BarrelBlock.FACING);
                    if (facing == Direction.UP || facing == Direction.DOWN) {
                        facing = Direction.NORTH;
                    }
                    reference = ((BarrelBlockEntity)Objects.requireNonNull(world.getBlockEntity((BlockPos)pos))).items;
                    newState = (BlockState)((LootrInventoryBlock)((Object)((Object)ModBlocks.INVENTORY.get()))).defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)facing);
                }
                NonNullList<ItemStack> custom = ChestUtil.copyItemList((NonNullList<ItemStack>)reference);
                world.removeBlockEntity(pos);
                world.setBlockAndUpdate(pos, newState);
                BlockEntity te = world.getBlockEntity(pos);
                if (!(te instanceof LootrInventoryBlockEntity)) {
                    ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Unable to convert chest, BlockState is not a Lootr Inventory block."), false);
                } else {
                    LootrInventoryBlockEntity inventory = (LootrInventoryBlockEntity)te;
                    inventory.setCustomInventory(custom);
                    inventory.setChanged();
                }
            }
            return 1;
        }));
        builder.then(Commands.literal((String)"id").executes(c -> {
            BlockPos pos = BlockPos.containing((Position)((CommandSourceStack)c.getSource()).getPosition());
            ServerLevel world = ((CommandSourceStack)c.getSource()).getLevel();
            BlockEntity te = world.getBlockEntity(pos);
            if (!(te instanceof ILootBlockEntity)) {
                pos = pos.below();
                te = world.getBlockEntity(pos);
            }
            if (!(te instanceof ILootBlockEntity)) {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Please stand on a valid Lootr container."), false);
            } else {
                ILootBlockEntity ibe = (ILootBlockEntity)te;
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("The ID of this inventory is: " + ibe.getTileId().toString())), false);
            }
            return 1;
        }));
        builder.then(Commands.literal((String)"refresh").executes(c -> {
            BlockPos pos = BlockPos.containing((Position)((CommandSourceStack)c.getSource()).getPosition());
            ServerLevel level = ((CommandSourceStack)c.getSource()).getLevel();
            BlockEntity be = level.getBlockEntity(pos);
            if (!(be instanceof ILootBlockEntity)) {
                pos = pos.below();
                be = level.getBlockEntity(pos);
            }
            if (be instanceof ILootBlockEntity) {
                ILootBlockEntity ibe = (ILootBlockEntity)be;
                DataStorage.setRefreshing(((ILootBlockEntity)be).getTileId(), (Integer)ConfigManager.REFRESH_VALUE.get());
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("Container with ID " + ibe.getTileId() + " has been set to refresh with a delay of " + ConfigManager.REFRESH_VALUE.get())), false);
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Please stand on a valid Lootr container."), false);
            }
            return 1;
        }));
        builder.then(Commands.literal((String)"decay").executes(c -> {
            BlockPos pos = BlockPos.containing((Position)((CommandSourceStack)c.getSource()).getPosition());
            ServerLevel level = ((CommandSourceStack)c.getSource()).getLevel();
            BlockEntity be = level.getBlockEntity(pos);
            if (!(be instanceof ILootBlockEntity)) {
                pos = pos.below();
                be = level.getBlockEntity(pos);
            }
            if (be instanceof ILootBlockEntity) {
                ILootBlockEntity ibe = (ILootBlockEntity)be;
                DataStorage.setDecaying(ibe.getTileId(), (Integer)ConfigManager.DECAY_VALUE.get());
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("Container with ID " + ibe.getTileId() + " has been set to decay with a delay of " + ConfigManager.DECAY_VALUE.get())), false);
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Please stand on a valid Lootr container."), false);
            }
            return 1;
        }));
        builder.then(Commands.literal((String)"openers").then(Commands.argument((String)"location", (ArgumentType)Vec3Argument.vec3()).executes(c -> {
            BlockPos position = Vec3Argument.getCoordinates((CommandContext)c, (String)"location").getBlockPos((CommandSourceStack)c.getSource());
            ServerLevel world = ((CommandSourceStack)c.getSource()).getLevel();
            BlockEntity tile = world.getBlockEntity(position);
            if (tile instanceof ILootBlockEntity) {
                ILootBlockEntity ibe = (ILootBlockEntity)tile;
                Set<UUID> openers = ((ILootBlockEntity)tile).getOpeners();
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("Tile at location " + position + " has " + openers.size() + " openers. UUIDs as follows:")), true);
                for (UUID uuid : openers) {
                    Optional prof = ((CommandSourceStack)c.getSource()).getServer().getProfileCache().get(uuid);
                    ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("UUID: " + uuid + ", user profile: " + (prof.isPresent() ? ((GameProfile)prof.get()).getName() : "null"))), true);
                }
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("No Lootr tile exists at location: " + position)), false);
            }
            return 1;
        })));
        return builder;
    }
}

