/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.data;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import noobanidus.mods.lootr.api.LootrAPI;
import noobanidus.mods.lootr.api.MenuBuilder;
import noobanidus.mods.lootr.api.inventory.ILootrInventory;
import noobanidus.mods.lootr.data.ChestData;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;
import org.jetbrains.annotations.Nullable;

public class SpecialChestInventory
implements ILootrInventory {
    private final Component name;
    private final ChestData newChestData;
    private NonNullList<ItemStack> contents;
    private MenuBuilder menuBuilder = null;

    public SpecialChestInventory(ChestData newChestData, NonNullList<ItemStack> contents, Component name) {
        this.newChestData = newChestData;
        this.contents = !contents.isEmpty() ? contents : NonNullList.withSize((int)newChestData.getSize(), (Object)ItemStack.EMPTY);
        this.name = name;
    }

    public SpecialChestInventory(ChestData newChestData, CompoundTag items, String componentAsJSON) {
        this.newChestData = newChestData;
        this.name = Component.Serializer.fromJson((String)componentAsJSON);
        this.contents = NonNullList.withSize((int)newChestData.getSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)items, this.contents);
    }

    public void setMenuBuilder(MenuBuilder builder) {
        this.menuBuilder = builder;
    }

    @Override
    @Nullable
    public BaseContainerBlockEntity getBlockEntity(Level level) {
        if (level == null || level.isClientSide() || this.newChestData.getPos() == null) {
            return null;
        }
        BlockEntity te = level.getBlockEntity(this.newChestData.getPos());
        if (te instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity be = (BaseContainerBlockEntity)te;
            return be;
        }
        return null;
    }

    @Override
    @Nullable
    public LootrChestMinecartEntity getEntity(Level world) {
        if (world == null || world.isClientSide() || this.newChestData.getEntityId() == null) {
            return null;
        }
        if (!(world instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        Entity entity = serverWorld.getEntity(this.newChestData.getEntityId());
        if (entity instanceof LootrChestMinecartEntity) {
            return (LootrChestMinecartEntity)entity;
        }
        return null;
    }

    @Override
    @Nullable
    public BlockPos getPos() {
        return this.newChestData.getPos();
    }

    public int getContainerSize() {
        return this.contents.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.contents) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.contents.get(index);
    }

    public ItemStack removeItem(int index, int count) {
        ItemStack itemstack = ContainerHelper.removeItem(this.contents, (int)index, (int)count);
        if (!itemstack.isEmpty()) {
            this.setChanged();
        }
        return itemstack;
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack result = ContainerHelper.takeItem(this.contents, (int)index);
        if (!result.isEmpty()) {
            this.setChanged();
        }
        return result;
    }

    public void setItem(int index, ItemStack stack) {
        this.contents.set(index, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    public void setChanged() {
        this.newChestData.setDirty();
    }

    public boolean stillValid(Player player) {
        if (!player.level().dimension().equals(this.newChestData.getDimension())) {
            return false;
        }
        if (this.newChestData.isEntity()) {
            if (this.newChestData.getEntityId() == null) {
                return false;
            }
            Level level = player.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Entity entity = serverLevel.getEntity(this.newChestData.getEntityId());
                if (entity instanceof ContainerEntity) {
                    ContainerEntity container = (ContainerEntity)entity;
                    return container.isChestVehicleStillValid(player);
                }
                return false;
            }
            return true;
        }
        BlockEntity be = player.level().getBlockEntity(this.newChestData.getPos());
        if (be == null) {
            return false;
        }
        return Container.stillValidBlockEntity((BlockEntity)be, (Player)player);
    }

    public void clearContent() {
        this.contents.clear();
        this.setChanged();
    }

    public Component getDisplayName() {
        return this.name;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        if (this.menuBuilder != null) {
            return this.menuBuilder.build(id, inventory, this, this.getContainerSize() / 9);
        }
        return switch (this.getContainerSize()) {
            case 9 -> new ChestMenu(MenuType.GENERIC_9x1, id, inventory, (Container)this, 1);
            case 18 -> new ChestMenu(MenuType.GENERIC_9x2, id, inventory, (Container)this, 2);
            case 36 -> new ChestMenu(MenuType.GENERIC_9x4, id, inventory, (Container)this, 4);
            case 45 -> new ChestMenu(MenuType.GENERIC_9x5, id, inventory, (Container)this, 5);
            case 54 -> ChestMenu.sixRows((int)id, (Inventory)inventory, (Container)this);
            default -> ChestMenu.threeRows((int)id, (Inventory)inventory, (Container)this);
        };
    }

    public void startOpen(Player player) {
        LootrChestMinecartEntity entity;
        Level world = player.level();
        BaseContainerBlockEntity tile = this.getBlockEntity(world);
        if (tile != null) {
            tile.startOpen(player);
        }
        if (this.newChestData.getEntityId() != null && (entity = this.getEntity(world)) != null) {
            entity.startOpen(player);
        }
    }

    public void stopOpen(Player player) {
        LootrChestMinecartEntity entity;
        BaseContainerBlockEntity tile;
        this.setChanged();
        Level world = player.level();
        if (this.newChestData.getPos() != null && (tile = this.getBlockEntity(world)) != null) {
            tile.stopOpen(player);
        }
        if (this.newChestData.getEntityId() != null && (entity = this.getEntity(world)) != null) {
            entity.stopOpen(player);
        }
    }

    @Nullable
    public UUID getTileId() {
        if (this.newChestData == null) {
            return null;
        }
        return this.newChestData.getTileId();
    }

    public CompoundTag writeItems() {
        CompoundTag result = new CompoundTag();
        return ContainerHelper.saveAllItems((CompoundTag)result, this.contents);
    }

    public String writeName() {
        return Component.Serializer.toJson((Component)this.name);
    }

    @Override
    public NonNullList<ItemStack> getInventoryContents() {
        return this.contents;
    }

    public void resizeInventory(int newSize) {
        if (newSize > this.contents.size()) {
            NonNullList<ItemStack> oldContents = this.contents;
            this.contents = NonNullList.withSize((int)newSize, (Object)ItemStack.EMPTY);
            for (int i = 0; i < oldContents.size(); ++i) {
                this.contents.set(i, (Object)((ItemStack)oldContents.get(i)));
            }
            LootrAPI.LOG.info("Resized inventory with key '" + this.newChestData.getKey() + "' in dimension '" + this.newChestData.getDimension() + "' at location '" + this.newChestData.getPos() + "' from " + oldContents.size() + " slots to " + newSize + " slots.");
        } else if (newSize < this.contents.size()) {
            throw new IllegalArgumentException("Cannot resize inventory associated with '" + this.newChestData.getKey() + "' in dimension '" + this.newChestData.getDimension() + "' at location '" + this.newChestData.getPos() + "' to a smaller size.");
        }
    }
}

