/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.entity;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.AbstractMinecartContainer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import noobanidus.mods.lootr.api.LootrAPI;
import noobanidus.mods.lootr.api.entity.ILootCart;
import noobanidus.mods.lootr.block.LootrChestBlock;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.event.HandleBreak;
import noobanidus.mods.lootr.init.ModBlocks;
import noobanidus.mods.lootr.init.ModEntities;
import noobanidus.mods.lootr.network.PacketUtils;
import noobanidus.mods.lootr.network.to_client.PacketOpenCart;
import noobanidus.mods.lootr.util.ChestUtil;
import org.jetbrains.annotations.Nullable;

public class LootrChestMinecartEntity
extends AbstractMinecartContainer
implements ILootCart {
    private static BlockState cartNormal = null;
    private final Set<UUID> openers = new HashSet<UUID>();
    private boolean opened = false;

    public LootrChestMinecartEntity(EntityType<LootrChestMinecartEntity> type, Level world) {
        super(type, world);
    }

    public LootrChestMinecartEntity(Level worldIn, double x, double y, double z) {
        super((EntityType)ModEntities.LOOTR_MINECART_ENTITY.get(), x, y, z, worldIn);
    }

    public void unpackChestVehicleLootTable(@Nullable Player p_219950_) {
    }

    @Override
    public Set<UUID> getOpeners() {
        return this.openers;
    }

    public void addOpener(Player player) {
        this.openers.add(player.getUUID());
        this.setChanged();
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void setOpened() {
        this.opened = true;
    }

    public void setClosed() {
        this.opened = false;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        if (this.isInvulnerable() && source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return true;
        }
        Entity entity = source.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (LootrAPI.isFakePlayer(player) && ((Boolean)ConfigManager.ENABLE_FAKE_PLAYER_BREAK.get()).booleanValue() || ((Boolean)ConfigManager.ENABLE_BREAK.get()).booleanValue()) {
                return false;
            }
            if (((Boolean)ConfigManager.DISABLE_BREAK.get()).booleanValue()) {
                if (player.getAbilities().instabuild) {
                    if (!player.isShiftKeyDown()) {
                        player.displayClientMessage((Component)Component.translatable((String)"lootr.message.cannot_break_sneak").setStyle(HandleBreak.getChatStyle()), false);
                        return true;
                    }
                    return false;
                }
                player.displayClientMessage((Component)Component.translatable((String)"lootr.message.cannot_break").setStyle(HandleBreak.getChatStyle()), false);
                return true;
            }
            if (!source.getEntity().isShiftKeyDown()) {
                ((Player)source.getEntity()).displayClientMessage((Component)Component.translatable((String)"lootr.message.cart_should_sneak").setStyle(HandleBreak.getChatStyle()), false);
                ((Player)source.getEntity()).displayClientMessage((Component)Component.translatable((String)"lootr.message.should_sneak2", (Object[])new Object[]{Component.translatable((String)"lootr.message.cart_should_sneak3").setStyle(Style.EMPTY.withBold(Boolean.valueOf(true)))}).setStyle(HandleBreak.getChatStyle()), false);
            }
        } else {
            return true;
        }
        return true;
    }

    public Item getDropItem() {
        return Items.CHEST_MINECART;
    }

    public int getContainerSize() {
        return 27;
    }

    public AbstractMinecart.Type getMinecartType() {
        return AbstractMinecart.Type.CHEST;
    }

    public BlockState getDefaultDisplayBlockState() {
        if (cartNormal == null) {
            cartNormal = (BlockState)((LootrChestBlock)((Object)ModBlocks.CHEST.get())).defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)Direction.NORTH);
        }
        return cartNormal;
    }

    public int getDefaultDisplayOffset() {
        return 8;
    }

    public AbstractContainerMenu createMenu(int id, Inventory playerInventoryIn) {
        return ChestMenu.threeRows((int)id, (Inventory)playerInventoryIn, (Container)this);
    }

    public void remove(Entity.RemovalReason reason) {
        this.setRemoved(reason);
        if (reason == Entity.RemovalReason.KILLED) {
            this.gameEvent(GameEvent.ENTITY_DIE);
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        if (this.lootTable != null) {
            compound.putString("LootTable", this.lootTable.toString());
        }
        compound.putLong("LootTableSeed", this.lootTableSeed);
        ListTag list = new ListTag();
        for (UUID opener : this.openers) {
            list.add((Object)NbtUtils.createUUID((UUID)opener));
        }
        compound.put("LootrOpeners", (Tag)list);
        super.addAdditionalSaveData(compound);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.lootTable = new ResourceLocation(compound.getString("LootTable"));
        this.lootTableSeed = compound.getLong("LootTableSeed");
        if (compound.contains("LootrOpeners", 9)) {
            ListTag openers = compound.getList("LootrOpeners", 11);
            this.openers.clear();
            for (Tag item : openers) {
                this.openers.add(NbtUtils.loadUUID((Tag)item));
            }
        }
        super.readAdditionalSaveData(compound);
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        InteractionResult ret = InteractionResult.PASS;
        if (ret.consumesAction()) {
            return ret;
        }
        if (player.isShiftKeyDown()) {
            ChestUtil.handleLootCartSneak(player.level(), this, player);
            if (!player.level().isClientSide) {
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        ChestUtil.handleLootCart(player.level(), this, player);
        if (!player.level().isClientSide) {
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public void addLoot(@Nullable Player player, Container inventory, @Nullable ResourceLocation overrideTable, long seed) {
        if (this.lootTable != null && this.level().getServer() != null) {
            LootTable loottable = this.level().getServer().getLootData().getLootTable(overrideTable != null ? overrideTable : this.lootTable);
            if (loottable == LootTable.EMPTY) {
                LootrAPI.LOG.error("Unable to fill loot in " + this.level().dimension().location() + " at " + this.position() + " as the loot table '" + (overrideTable != null ? overrideTable : this.lootTable) + "' couldn't be resolved! Please search the loot table in `latest.log` to see if there are errors in loading.");
                if (((Boolean)ConfigManager.REPORT_UNRESOLVED_TABLES.get()).booleanValue() && player != null) {
                    player.displayClientMessage(ChestUtil.getInvalidTable(overrideTable != null ? overrideTable : this.lootTable), false);
                }
            }
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.GENERATE_LOOT.trigger((ServerPlayer)player, overrideTable != null ? overrideTable : this.lootTable);
            }
            LootParams.Builder builder = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.ORIGIN, (Object)this.position());
            builder.withParameter(LootContextParams.KILLER_ENTITY, (Object)this);
            if (player != null) {
                builder.withLuck(player.getLuck()).withParameter(LootContextParams.THIS_ENTITY, (Object)player);
            }
            loottable.fill(inventory, builder.create(LootContextParamSets.CHEST), LootrAPI.getLootSeed(seed == Long.MIN_VALUE ? this.lootTableSeed : seed));
        }
    }

    public void startOpen(Player player) {
        if (!player.isSpectator()) {
            PacketUtils.sendTo(new PacketOpenCart(this.getId()), (ServerPlayer)player);
        }
    }

    public void stopOpen(Player player) {
        if (!player.isSpectator()) {
            this.addOpener(player);
        }
    }

    public void startSeenByPlayer(ServerPlayer pPlayer) {
        super.startSeenByPlayer(pPlayer);
        if (this.getOpeners().contains(pPlayer.getUUID())) {
            PacketUtils.sendTo(new PacketOpenCart(this.getId()), pPlayer);
        }
    }
}

