/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.event;

import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import noobanidus.mods.lootr.api.LootrAPI;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.entity.EntityTicker;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;

@Mod.EventBusSubscriber(modid="lootr")
public class HandleCart {
    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        Entity entity;
        if (ConfigManager.isDimensionBlocked((ResourceKey<Level>)event.getLevel().dimension()) || ((Boolean)ConfigManager.DISABLE.get()).booleanValue()) {
            return;
        }
        if (event.getEntity().getType() == EntityType.CHEST_MINECART && (entity = event.getEntity()) instanceof MinecartChest) {
            Level level;
            MinecartChest chest = (MinecartChest)entity;
            if (!chest.level().isClientSide && chest.lootTable != null && ((Boolean)ConfigManager.CONVERT_MINESHAFTS.get()).booleanValue() && !ConfigManager.getLootBlacklist().contains(chest.lootTable) && (level = chest.level()) instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                LootrChestMinecartEntity lootr = new LootrChestMinecartEntity(chest.level(), chest.getX(), chest.getY(), chest.getZ());
                lootr.setLootTable(chest.lootTable, chest.lootTableSeed);
                lootr.getPersistentData().merge(chest.getPersistentData());
                event.setCanceled(true);
                if (!level2.getServer().isSameThread()) {
                    LootrAPI.LOG.error("Minecart with Loot table created off main thread. Falling back on EntityTicker.");
                    EntityTicker.addEntity(lootr);
                } else {
                    level2.addFreshEntity((Entity)lootr);
                }
            }
        }
    }
}

